/*!
 * PennController for IBEX
 * This software is licensed under a BSD license; see the LICENSE file for details.
 * 
 *  - Version 2.0
 *  - Last Update:  2021, July 26
 *  - Major changes in version 2.0:
 *    * Fixed Controller element duplicating lines and not rerunning properly
 *    * Fixed selector.shuffle and its order logging
 *    * Improved handling of trial end for the MediaRecorder element
 *    * Improved audio/video recording upload
 *    * Fixed print/canvas.add coordinates format bug (introduced in 1.9)
 *    * Can now pass opacity of 0 to audio.disable and video.disable
 *    * Fixed all-digit strings passed to Key element
 *    * Fixed MediaRecorder stop / end of trials
 *    * Fixed problems with some special commands (eg. fullscreen) not being properly executed as callback
 *    * Fixed: Controller elements no longer appear multiple times when printed onto a Canvas element
 *    * Fixed: calling print() after print(x,y[, canvas]) no longer preserves old positioning
 *    * Fixed: referencing PennController element in scale.label before printing it
 *    * Fixed elusive flickering with scaling
 *    * Fixed selector.shuffle with elements printed before/after other elements
 *    * Replaced the EyeTracker test with a smoother one
 *    * Resources are now preloading 4 at a time, following the running order (= less aggressive requests)
 *    * Fixed audio and video preloading problems
 *    * Fixed video.disable semi-opaque layer
 *    + Added newTrial().noTrialLog("start","end") to skip the tria's Start and/or End lines in the results file
 *    + Added controller.callback
 *    + Added textinput.callback
 *    + Added specialcommand jump to navigate the sequence
 *    + Added element DragDrop
 *    + Added support of flac audios in zip files
 * 
 */!function(e){var t={};function n(i){if(t[i])return t[i].exports;var r=t[i]={i:i,l:!1,exports:{}};return e[i].call(r.exports,r,r.exports,n),r.l=!0,r.exports}n.m=e,n.c=t,n.d=function(e,t,i){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:i})},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},n.t=function(e,t){if(1&t&&(e=n(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var i=Object.create(null);if(n.r(i),Object.defineProperty(i,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var r in e)n.d(i,r,function(t){return e[t]}.bind(null,r));return i},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,"a",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p="",n(n.s=45)}([function(e,t,n){"use strict";n.d(t,"a",(function(){return a}));var i=n(1);let r=[],s={keypress:[]};class o{constructor(e,t,n){this.name=e,this.value=e,this.creator=t,this.controllers=[],this.object=null,this.status="void",this.useURLs=void 0===n||n,this.created_at=0}create(){this.status="pending",this.created_at=Date.now(),this.creator.call(this,()=>this.resolve())}resolve(){this.status="ready",a.debug.log("<div style='color: purple;'>Successfully preloaded resource "+this.name+"</div>")}}var a={resources:{list:[],fetch:function(e,t,n){var i=a.resources.list.filter(t=>t.name==e&&t.controllers.indexOf(a.controllers.underConstruction.id)<0);return(i=i.length?i[0]:new o(e,t,n)).controllers.push(a.controllers.underConstruction.id),a.controllers.underConstruction.resources.push(i),"void"!=i.status||(i.creator=t,a.resources.list.push(i)),i}},controllers:{list:[],running:null,underConstruction:null},elements:{list:[]},events:{keypress:e=>{let t=[e,a.controllers.running||a.controllers.underConstruction];if(s.keypress.push(t),a.controllers.running){let e=a.controllers._endTrial;a.controllers.running._endTrial=async function(){await e.apply(a.controllers.running),t[0]=()=>{}}}else{let e=a.controllers.underConstruction.sequence;a.controllers.underConstruction.sequence=Object(i.d)([e,e=>{t[0]=()=>{},e()}])}}},URLs:[],utils:{guidGenerator:i.b,parseCoordinates:i.h,printAndRefreshUntil:i.j,levensthein:i.e,upload:i.k,overToScale:i.g},tmpItems:[],tables:{},Prerun:function(e){r.push(e)}};let l=window.ibex_controller_set_properties;window.ibex_controller_set_properties=function(e,t){if(l(e,t),"__SendResults__"==e){document.addEventListener("keydown",e=>{if(!e.repeat&&a.controllers.running)for(let t=0;t<s.keypress.length;t++)a.controllers.running!=s.keypress[t][1]&&a.controllers.running.id!=s.keypress[t][1]||s.keypress[t][0].apply(this,[e])});for(let e in r)r[e]instanceof Function&&r[e].call()}};a.Prerun(async()=>{const e=t=>{a.runningOrder&&a.runningOrder.active?t():window.requestAnimationFrame(()=>e(t))};await new Promise(e);let t=[];a.runningOrder.active.forEach(e=>e.forEach(e=>{"PennController"==e.controller&&(t=[...t,...e.options.resources])}));let n=[];const i=()=>{if(n=n.filter(e=>"ready"!=e.status||e.created_at&&Date.now()-e.created_at>1e4),t.length>0&&n.length<4){let e=t.shift();for(;(void 0===e||"ready"==e.status)&&t.length;)e=t.shift();e&&"ready"!=e.status&&n.push(e)}0!=n.length&&(n.forEach(e=>{if(e instanceof o&&"void"==e.status&&(e.create(),e.useURLs))for(let t in a.URLs)e.create.apply($.extend({},e,{value:a.URLs[t]+e.name,resolve:function(){"ready"!=e.status&&(e.object=this.object,e.resolve())}}))}),window.requestAnimationFrame(i))};i()})},function(e,t,n){"use strict";function i(e){return()=>new Promise((async function(t){for(let t in e)if(e[t]instanceof Function)var n=await e[t]();t(n)}))}function r(e){const t=new Uint8Array(e);let n=[];return t.forEach(e=>{n.push(e.toString(16))}),n.join("").toUpperCase()}n.d(t,"d",(function(){return i})),n.d(t,"c",(function(){return r})),n.d(t,"g",(function(){return o})),n.d(t,"k",(function(){return a})),n.d(t,"a",(function(){return l})),n.d(t,"f",(function(){return u})),n.d(t,"b",(function(){return h})),n.d(t,"i",(function(){return c})),n.d(t,"h",(function(){return d})),n.d(t,"j",(function(){return p})),n.d(t,"e",(function(){return m}));const s=function(e){const t=this.css("transform").match(/matrix\(\s*(-?\d+(.\d+)?),[^,]+,[^,]+,\s*(-?\d+(.\d+)?),/);return t&&(e.x=e.x*Number(t[1]),e.y=e.y*Number(t[3])),e};function o(e,t){let n=this,i={x:1,y:1};for(;n;)s.call(n,i),n=n.parent(),n[0]===document&&(n=void 0);let r=this.offset(),o=this.width(),a=this.height(),l=o*i.x,u=a*i.y;return r.left<=e&&r.top<=t&&r.left+l>=e&&r.top+u>=t}async function a(e,t,n,i){let r;try{r=await new Promise((n,r)=>{const s=new XMLHttpRequest,o=e.match(/\?/)?"&":"?";s.open("GET",e+o+"filename="+encodeURIComponent(t)+"&mimetype="+encodeURIComponent(i),!0),s.setRequestHeader("Content-Type","application/json"),s.onerror=t=>r("Could not GET "+e+";"),s.onload=function(){let e=null;try{e=JSON.parse(this.responseText)}catch{e=this.responseText}console.log("response",e),n(e)},console.log("before sending xhr"),s.send(),console.log("after sending xhr")})}catch(e){return new Promise((t,n)=>n(e))}console.log("presignedPostData",r);const s=new FormData;return void 0===r||"string"==typeof r?(s.append("fileName",t),s.append("mimeType",i),s.append("file",n)):(Object.keys(r).forEach(t=>{"url"==t?e=r.url:s.append(t,r[t])}),s.append("file",n),r.key&&(t=r.key)),new Promise((n,i)=>{const r=new XMLHttpRequest;r.open("POST",e,!0),r.onload=()=>n(t),r.onerror=()=>i(r.responseText);try{r.send(s)}catch(t){return i("Could not POST to "+e+"; "+t)}})}function l(e,t){if(e.match(/^00000[12]00/i))return"image/x-icon";if(e.match(/424D/i))return"image/bmp";if(e.match(/^89504E470?D0?A1A0?A/i))return"image/png";if(e.match(/^474946383[79]61/i))return"image/gif";if(e.match(/^52494646........574542505650/i))return"image/webp";if(e.match(/^FFD8FF/i))return"image/jpeg";if(e.match(/^2E736E64/i))return"audio/basic";if(e.match(/^464F524D........41494646/i))return"audio/aiff";if(e.match(/^(fff[b3a2]|494433)/i))return"audio/mpeg";if(e.match(/^664C6143/i))return"audio/flac";if(e.match(/^4F67675300/i))return"application/ogg";if(e.match(/^4D546864......06/i))return"audio/midi";if(e.match(/^52494646........41564920/i))return"video/avi";if(e.match(/^52494646.{4,8}57415645/i))return"audio/wave";if(e.match(/^1A45DFA3/i))return"video/webm";if(e.match(/^25504446/i))return"application/pdf";if(e.match(/^504B0304/i))return"application/zip";{let e=t.match(/\.([^.]+)$/);if(!e)return"";switch(e[1].toLowerCase()){case"bmp":return"image/bmp";case"png":return"image/png";case"gif":return"image/gif";case"webp":return"image/webp";case"jpg":case"jpeg":return"image/jpeg";case"mp3":return"audio/mpeg";case"flac":return"audio/flac";case"ogg":case"oga":return"audio/ogg";case"midi":case"mid":return"audio/midi";case"wav":return"audio/wave";case"webm":return"video/webm";case"avi":return"video/avi";case"mp4":return"video/mp4";case"ogv":return"video/ogg";case"mov":return"video/quicktime";default:return""}}}function u(e){let t=e/1e3%60,n=Math.trunc(e/6e4);return(n>0?n+"min":"")+(t>0?t+"s":"")}function h(){var e=function(){return(65536*(1+Math.random())|0).toString(16).substring(1)};return e()+e()+"-"+e()+"-"+e()+"-"+e()+"-"+e()+e()+e()}function c(e){return e.map(e=>e instanceof Object&&e.hasOwnProperty("_promises")&&e.type&&e._element?e.type+":"+e._element.id:e)}function d(e,t){const n=this.css("transform").match(/matrix\(\s*(-?\d+(.\d+)?),[^,]+,[^,]+,\s*(-?\d+(.\d+)?),/),i=window.getComputedStyle(this[0]),r=Number(i.width.replace(/px$/,"")),s=Number(i.height.replace(/px$/,""));let o=r,a=s;n&&(o=Math.abs(o*n[1]),a=Math.abs(a*n[3]));let l=String(e).match(/^(.+)\s+at\s+(.+)$/i),u=String(t).match(/^(.+)\s+at\s+(.+)$/i);if(l&&(e=String(l[2])),u&&(t=String(u[2])),isNaN(e)||(e+="px"),isNaN(t)||(t+="px"),l){if(l[1].match(/top|bottom/i))throw"Passed Y coordinate in place of X";e=l[1].match(/center|middle/i)?`calc(${e} - ${r/2}px)`:l[1].match(/right/i)?`calc(${e} - ${o-(o-r)/2}px)`:`calc(${e} + ${(o-r)/2}px)`}else e=`calc(${e} + ${(o-r)/2}px)`;if(u){if(u[1].match(/left|right/i))throw"Passed X coordinate in place of Y";t=u[1].match(/center|middle/i)?`calc(${t} - ${s/2}px)`:u[1].match(/bottom/i)?`calc(${t} - ${a-(a-s)/2}px)`:`calc(${t} + ${(a-s)/2}px)`}else t=`calc(${t} + ${(a-s)/2}px)`;return{x:e,y:t}}function f(e,t,n,i,r){if(i instanceof Function&&i())return this.css(r);const s=d.call(this,e,t);this.css({position:"absolute",left:s.x,top:s.y}),window.requestAnimationFrame(()=>f.call(this,e,t,n,i,r))}function p(e,t,n,i){n=n||$("body");const r=this.parent()[0],s={display:this.css("display"),position:this.css("position"),left:this.css("left"),top:this.css("top")};void 0!==r&&r==n[0]||this.appendTo(n).css("display","inline-block"),f.call(this,e,t,n,i,s)}function m(e,t){let n=[];n[0]=("a"+t).split("").map((e,t)=>t);for(let i=1;i<e.length+1;i++)n[i]=[i,...t.split("").map(()=>0)];for(let i=1;i<t.length+1;i++)for(let r=1;r<e.length+1;r++){let s=e.charAt(r)!=t.charAt(i),o=n[r-1][i]+1,a=n[r][i-1]+1,l=n[r-1][i-1]+s;n[r][i]=o<a&&o<l?o:a<o&&a<l?a:l}return n[e.length][t.length]}let g=["Unidentified","Alt","AltGraph","CapsLock","Control","Fn","FnLock","Meta","NumLock","ScrollLock","Shift","Symbol","SymbolLock","Hyper","Super","Enter","Tab","ArrowDown","ArrowLeft","ArrowRight","ArrowUp","End","Home","PageDown","PageUp","Backspace","Clear","Copy","CrSel","Cut","Delete","EraseEof","ExSel","Insert","Paste","Redo","Undo","Accept","Again","Attn","Cancel","ContextMenu","Escape","Execute","Find","Help","Pause","Play","Props","Select","ZoomIn","ZoomOut","BrightnessDown","BrightnessUp","Eject","LogOff","Power","PowerOff","PrintScreen","Hibernate","Standby","WakeUp","AllCandidates","Alphanumeric","CodeInput","Compose","Convert","Dead","FinalMode","GroupFirst","GroupLast","GroupNext","GroupPrevious","ModeChange","NextCandidate","NonConvert","PreviousCandidate","Process","SingleCandidate","HangulMode","HanjaMode","JunjaMode","Eisu","Hankaku","Hiragana","HiraganaKatakana","KanaMode","KanjiMode","Katakana","Romaji","Zenkaku","ZenkakuHankaku","F1","F2","F3","F4","F5","F6","F7","F8","F9","F10","F11","F12","Soft1","Soft2","Soft3","Soft4","ChannelDown","ChannelUp","Close","MailForward","MailReply","MailSend","MediaClose","MediaFastForward","MediaPause","MediaPlay","MediaPlayPause","MediaRecord","MediaRewind","MediaStop","MediaTrackNext","MediaTrackPrevious","New","Open","Print","Save","SpellCheck","Key11","Key12","AudioBalanceLeft","AudioBalanceRight","AudioBassBoostDown","AudioBassBoostToggle","AudioBassBoostUp","AudioFaderFront","AudioFaderRear","AudioSurroundModeNext","AudioTrebleDown","AudioTrebleUp","AudioVolumeDown","AudioVolumeUp","AudioVolumeMute","MicrophoneToggle","MicrophoneVolumeDown","MicrophoneVolumeUp","MicrophoneVolumeMute","SpeechCorrectionList","SpeechInputToggle","LaunchApplication1","LaunchApplication2","LaunchCalendar","LaunchContacts","LaunchMail","LaunchMediaPlayer","LaunchMusicPlayer","LaunchPhone","LaunchScreenSaver","LaunchSpreadsheet","LaunchWebBrowser","LaunchWebCam","LaunchWordProcessor","BrowserBack","BrowserFavorites","BrowserForward","BrowserHome","BrowserRefresh","BrowserSearch","BrowserStop","AppSwitch","Call","Camera","CameraFocus","EndCall","GoBack","GoHome","HeadsetHook","LastNumberRedial","Notification","MannerMode","VoiceDial","TV","TV3DMode","TVAntennaCable","TVAudioDescription","TVAudioDescriptionMixDown","TVAudioDescriptionMixUp","TVContentsMenu","TVDataService","TVInput","TVInputComponent1","TVInputComponent2","TVInputComposite1","TVInputComposite2","TVInputHDMI1","TVInputHDMI2","TVInputHDMI3","TVInputHDMI4","TVInputVGA1","TVMediaContext","TVNetwork","TVNumberEntry","TVPower","TVRadioService","TVSatellite","TVSatelliteBS","TVSatelliteCS","TVSatelliteToggle","TVTerrestrialAnalog","TVTerrestrialDigital","TVTimer","AVRInput","AVRPower","ColorF0Red","ColorF1Green","ColorF2Yellow","ColorF3Blue","ColorF4Grey","ColorF5Brown","ClosedCaptionToggle","Dimmer","DisplaySwap","DVR","Exit","FavoriteClear0","FavoriteClear1","FavoriteClear2","FavoriteClear3","FavoriteRecall0","FavoriteRecall1","FavoriteRecall2","FavoriteRecall3","FavoriteStore0","FavoriteStore1","FavoriteStore2","FavoriteStore3","Guide","GuideNextDay","GuidePreviousDay","Info","InstantReplay","Link","ListProgram","LiveContent","Lock","MediaApps","MediaAudioTrack","MediaLast","MediaSkipBackward","MediaSkipForward","MediaStepBackward","MediaStepForward","MediaTopMenu","NavigateIn","NavigateNext","NavigateOut","NavigatePrevious","NextFavoriteChannel","NextUserProfile","OnDemand","Pairing","PinPDown","PinPMove","PinPToggle","PinPUp","PlaySpeedDown","PlaySpeedReset","PlaySpeedUp","RandomToggle","RcLowBattery","RecordSpeedNext","RfBypass","ScanChannelsToggle","ScreenModeNext","Settings","SplitScreenToggle","STBInput","STBPower","Subtitle","Teletext","VideoModeNext","Wink","ZoomToggle","AudioVolumeDown","AudioVolumeUp","AudioVolumeMute","BrowserBack","BrowserForward","ChannelDown","ChannelUp","ContextMenu","Eject","End","Enter","Home","MediaFastForward","MediaPlay","MediaPlayPause","MediaRecord","MediaRewind","MediaStop","MediaNextTrack","MediaPause","MediaPreviousTrack","Power"],y=g.map(e=>e.toUpperCase());String.prototype.isSpecialKey=function(e){return e?g.indexOf(this)>-1:y.indexOf(this.toUpperCase())>-1},jQuery.fn.printed=function(){let e=this.parent();for(;e.length;){if(e[0]==document.body)return!0;e=e.parent()}return!1}},function(e,t,n){"use strict";n.d(t,"a",(function(){return l})),n.d(t,"b",(function(){return h}));var i=n(0),r=n(1);let s=null,o=null,a=[];class l{constructor(){if(this.id=i.a.controllers.list.length,this.useLabel=!1,this.addToItems=!0,this.appendResultLine=[],this.linesToSave=[],this.resources=[],this.elements={},this.ambiguousElementNames=[],this.preloadDelay=6e4,i.a.controllers.list.push(this),this.defaultCommands={},this.headerDefaultCommands={},s&&s.defaultCommands)for(let e in s.defaultCommands)this.defaultCommands[e]=[].concat(s.defaultCommands[e])}_addElement(e){if(!e.hasOwnProperty("type")||!e.hasOwnProperty("id"))return i.a.debug.error("Attempted to create an invalid element");this.elements.hasOwnProperty(e.type)||(this.elements[e.type]={}),this.elements[e.type].hasOwnProperty(e.id)&&i.a.debug.warning("Overwrting another "+e.type+" element with the same name ("+e.id+")"),this.elements[e.type][e.id]=e}_getElement(e,t){if("string"!=typeof e||e.length<1||"string"!=typeof t||t.length<1)return i.a.debug.error("Attempted to get an invalid element",e,t);if(!this.elements.hasOwnProperty(t))return i.a.debug.error("Attempted to get an element of an invalid type ("+t+")",e);if(!this.elements[t].hasOwnProperty(e)){let n=[];for(let t in this.elements)this.elements[t].hasOwnProperty(e)&&n.push(t);return i.a.debug.error("No "+t+" element named &quot;"+e+"&quot; found",n.length?"Found &quot;"+e+"&quot; of type "+n.join(","):null)}return this.elements[t][e]}label(e){return this.useLabel=e,this}logAppend(e,t,n){return this.linesToSave.push(["PennController",this.id,e,t,Date.now(),n]),this}log(e,t){return null==t&&(t=e),void 0===e?(i.a.debug.warning("Used <tt>newTrial().log</tt> with no arguments"),this):(this.appendResultLine.push([csv_url_encode(e),t]),this)}noHeader(){return this.runHeader=!1,this}noFooter(){return this.runFooter=!1,this}setOption(e,t){return this[e]=t,this}noTrialLog(...e){return this.skipLog=e,this}}i.a.controllers.underConstruction=new l,i.a.controllers.new=()=>new l;const u=[];var h=function(...e){let t=i.a.controllers.underConstruction;if(window.items)for(let e in window.items)i.a.tmpItems.indexOf(window.items[e])<0&&i.a.tmpItems.push(window.items[e]);i.a.tmpItems.push(t),e.length&&"string"==typeof e[0]&&(t.useLabel=e[0]);let n=[];return function e(...t){for(let n in t)u.filter(e=>e instanceof Function&&e.call(null,t[n])),t[n]&&t[n]._promises?this.push(Object(r.d)(t[n]._promises)):t[n]&&t[n]instanceof Array&&e.apply(this,t[n])}.apply(n,e),t.sequence=Object(r.d)(n),i.a.controllers.underConstruction=new l,t};i.a.NewTrialArgumentCallback=e=>u.push(e),h.newTrial=h,h.Debug=function(e){i.a.debug.on=null==e||e},h.DebugOff=()=>h.Debug(!1),h.Sequence=function(...e){for(let t=0;t<e.length;t++)if(e[t]._item&&e[t]._item instanceof Array&&e[t]._item.length>1&&"__SendResults__"==e[t]._item[1]){let n="sendResults-"+Object(r.b)();e[t].label(n),e[t]=n}window.shuffleSequence=window.seq(...e)};let c={};h.GetURLParameter=function(e){if(!Object.keys(c).length){let e=window.location.search.replace("?","").split("&");for(let t in e)c[e[t].split("=")[0]]=e[t].split("=")[1]}if(c.hasOwnProperty(e))return c[e]},h.AddHost=function(...e){for(let t in e)"string"==typeof e[t]&&e[t].match(/^https?:\/\//i)?i.a.URLs.push(e[t]):i.a.debug.warning("URL #"+t+" is not a valid URL (PennController.AddHost).",e[t])},h.CheckPreloaded=function(...e){let t=new l;t.id="Preloader-"+a.length,t.runHeader=!1,t.runFooter=!1,a.push(t),i.a.controllers.list.pop(),t.sequence=()=>new Promise(e=>e()),t.ignoreWhenCheckingPreload=!0,i.a.tmpItems.push(t),e.length&&Number(e[e.length-1])>0&&(t.preloadDelay=Number(e[e.length-1]),e.pop());let n=[];if(e.length)for(let t in e){let i=e[t];"string"==typeof i&&(i=n=>n==e[t]),i instanceof Function&&n.push(i)}else n=[e=>!0];return i.a.Prerun(()=>{let e=window.conf_modifyRunningOrder;window.conf_modifyRunningOrder=function(i){e instanceof Function&&(i=e.call(this,i));for(let e=0;e<i.length;e++){let r=i[e].filter(e=>{let t=!1;for(let i=0;i<n.length;i++)t=t||n[i](e.type);return t=t&&"PennController"==e.controller,t=t&&!e.options.ignoreWhenCheckingPreload,t});for(let e=0;e<r.length;e++)t.resources=t.resources.concat(r[e].options.resources.filter(e=>t.resources.indexOf(e)<0))}return i}}),t};const d=window.JSON.stringify;window.JSON.stringify=function(...e){const t=d.apply(this,e);if(1==e.length&&e[0]instanceof Array&&6==e[0].length&&!1===e[0][0]&&e[0][1]==window.__counter_value_from_server__&&e[0][4]==(()=>{for(var e=(new Date).getTimezoneOffset()+":",t=["Java","QuickTime","DevalVR","Shockwave","Flash","Windows Media Player","Silverlight","VLC Player"],n=0;n<t.length;++n){var i=PluginDetect.getVersion(t[n]);i&&(e+=t[n]+":"+i)}return createCookie("TEST","TEST",.01),"TEST"==readCookie("TEST")&&(e+="C"),e+=(screen.width?screen.width:1)+":"+(screen.height?screen.height:1)+":"+(screen.colorDepth?screen.colorDepth:1),b64_md5(e)})())for(;e[0][3].length;)e[0][3].pop();return t};const f=window.alert;window.alert=function(e,...t){return"WARNING: Results have already been sent once. Did you forget to set the 'manualSendResults' config option?"!=e&&f.call(this,e,...t)},h.SendResults=function(e,t){null==window.items&&(window.items=[]),null!=window.manualSendResults&&0==window.manualSendResults||(window.manualSendResults=!0),"string"==typeof e&&e.match(/^http/i)&&(t=e,e=void 0);let n={},r=[e||"sendResults","__SendResults__",n],s=()=>new Promise(e=>{const n=window.__server_py_script_name__;let r={_finishedCallback:()=>{window.__server_py_script_name__=n,e()},_cssPrefix:"",_utils:i.a.controllers.running.utils},s=window.$("<p>").addClass("PennController-SendResults");i.a.controllers.running.element.append(s),addSafeBindMethodPair("__SendResults__"),"string"==typeof t&&(window.__server_py_script_name__=t),s.__SendResults__(r)}),o={label:e=>(r[0]=e,o),setOption:(e,t)=>(n[e]=t,o)};o._item=r,o.type="__SendResults__",o._element={id:"SendResults"};const a=e=>{if(e==o){let e=window.items&&window.items.indexOf(r);e>=0&&window.items.splice(e,1),i.a.tmpItems=i.a.tmpItems.filter(e=>e!=r)}};return i.a.ArgumentCallback(a),i.a.NewTrialArgumentCallback(a),o._promises=[s],o._runPromises=s,window.items.push(r),o},h.SetCounter=function(...e){null==window.items&&(window.items=[]);let t="setCounter",n={};e.length&&(isNaN(Number(e[0]))?1==e.length?isNaN(Number(e[0]))?t=e[0]:n.set=Number(e[0]):2!=e.length||isNaN(Number(e[1]))?e.length>2&&!isNaN(Number(e[2]))?(t=e[0],e[1].match(/\s*inc\s*$/i)?n.inc=e[2]:n.set=e[2]):t=e[0]:e[0].match(/\s*inc\s*$/i)?n.inc=e[1]:(n.set=e[1],e[0].match(/\s*set\s*$/i)||(t=e[0])):n.set=Number(e[0]));let i=[t,"__SetCounter__",n];return n.label=e=>(i[0]=e,n),n.setOption=(e,t)=>(n[e]=t,n),window.items.push(i),n},h.Header=function(...e){let t=i.a.controllers.underConstruction;t.id="Header",t.addToItems=!1,i.a.controllers.list.pop(),t.sequence=Object(r.d)(e.map(e=>Object(r.d)(e._promises)));for(let e in t.defaultCommands)for(let n in t.defaultCommands[e])t.defaultCommands[e][n].push("header");return s?(s.resources=s.resources.concat(t.resources),$.extend(!0,s.elements,t.elements),s.headerDefaultCommands=t.headerDefaultCommands,s.sequence=Object(r.d)([s.sequence,t.sequence])):s=t,i.a.controllers.underConstruction=new l,s},h.Footer=function(...e){let t=i.a.controllers.underConstruction;return t.id="Footer",t.addToItems=!1,i.a.controllers.list.pop(),t.sequence=Object(r.d)(e.map(e=>Object(r.d)(e._promises))),o?(o.resources=o.resources.concat(t.resources),$.extend(!0,o.elements,t.elements),o.headerDefaultCommands=t.headerDefaultCommands,o.sequence=Object(r.d)([o.sequence,t.sequence])):o=t,i.a.controllers.underConstruction=new l,o},define_ibex_controller({name:"PennController",jqueryWidget:{_init:function(){var e=this;i.a.controllers.running=e,e.cssPrefix=e.options._cssPrefix,e.utils=e.options._utils,e.finishedCallback=e.options._finishedCallback,e.id=e.options.id,"string"==typeof e.id&&e.id.match(/^Preloader-/)?e.controller=a[Number(e.id.replace(/Preloader-/,""))]:"Header"==e.id?e.controller=s:"Footer"==e.id?e.controller=o:Number(e.id)>=0&&Number(e.id)<i.a.controllers.list.length?e.controller=i.a.controllers.list[e.id]:e.controller=e.options,e.runHeader=null==e.controller.runHeader||e.controller.runHeader,e.runFooter=null==e.controller.runFooter||e.controller.runFooter,void 0===e.controller.appendResultLine&&(e.controller.appendResultLine=[]);let t=e.controller.preloadDelay;if(e.runHeader&&s instanceof l&&!e.controller.inheritedHeader){e.controller.resources=e.controller.resources.concat(s.resources.filter(t=>e.controller.resources.indexOf(t)<0)),$.extend(!0,e.controller.elements,s.elements);for(let t=0;t<s.appendResultLine.length;t++)e.controller.appendResultLine.unshift(s.appendResultLine[t]);e.controller.inheritedHeader=!0}if(e.runFooter&&o instanceof l&&!e.controller.inheritedFooter){e.controller.resources=e.controller.resources.concat(o.resources.filter(t=>e.controller.resources.indexOf(t)<0)),$.extend(!0,e.controller.elements,o.elements);for(let t=0;t<o.appendResultLine.length;t++)e.controller.appendResultLine.push(o.appendResultLine[t]);e.controller.inheritedFooter=!0}let n=[];e.save=function(t,i,r,s,o,...a){a.length||(a=["NULL"]);let l=[["PennElementType",t],["PennElementName",i],["Parameter",r],["Value",s],["EventTime",o]];for(let t=0;t<e.controller.appendResultLine.length;t++){let n=[e.controller.appendResultLine[t][0],e.controller.appendResultLine[t][1]];n instanceof Array&&2==n.length&&l.push(n)}l.push(["Comments",a.join(",")]),n.push(l)};for(let t in e.controller.linesToSave)e.save(e.controller.linesToSave[t]);let u=!1,h=async function(){if(!u){u=!0,e.runFooter&&o instanceof l&&(o.skipLog instanceof Array&&!(o.skipLog.length>0&&0==o.skipLog.filter(e=>e.match(/start/i)).length)||e.save("PennController",e.id,"_Footer_","Start",Date.now(),"NULL"),o._getElement=(t,n)=>e.controller._getElement(t,n),await o.sequence(),o.skipLog instanceof Array&&!(o.skipLog.length>0&&0==o.skipLog.filter(e=>e.match(/end/i)).length)||e.save("PennController",e.id,"_Footer_","End",Date.now(),"NULL"));for(let t in e.controller.elements)for(let n in e.controller.elements[t])await e.controller.elements[t][n].end();e.controller.skipLog instanceof Array&&!(e.controller.skipLog.length>0&&0==e.controller.skipLog.filter(e=>e.match(/end/i)).length)||e.save("PennController",e.id,"_Trial_","End",Date.now(),"NULL"),n.sort((e,t)=>e[4][1]>t[4][1]),n.map(e=>{for(let t in e){e[t][1]instanceof Function&&(e[t][1]=e[t][1]());let n=[];for(;e[t][1].value&&e[t][1].value._element;)n.indexOf(e[t][1]._element)<0?(n.push(e[t][1]._element),e[t][1]=e[t][1].value):e[t][1]=e[t][1]._element.id;e[t][1]._element&&e[t][1]._element.id&&(e[t][1]=e[t][1]._element.value),e[t][1]=csv_url_encode(""+e[t][1])}}),e.finishedCallback(n)}};e.endTrial=h;let c=!1,d=async function(t){if(!c){if(e.element.css({display:"flex","flex-direction":"column",position:"absolute",left:0,width:"100vw"}),c=!0,t)for(let t in e.controller.resources.filter(e=>"ready"!=e.status))e.save("PennController",e.id,"_PreloadFailed_",csv_url_encode(e.controller.resources[t].name),Date.now(),"NULL");f.remove(),e.controller.skipLog instanceof Array&&!(e.controller.skipLog.length>0&&0==e.controller.skipLog.filter(e=>e.match(/start/i)).length)||e.save("PennController",e.id,"_Trial_","Start",Date.now(),"NULL"),e.runHeader&&s instanceof l&&(s.skipLog instanceof Array&&!(s.skipLog.length>0&&0==s.skipLog.filter(e=>e.match(/start/i)).length)||e.save("PennController",e.id,"_Header_","Start",Date.now(),"NULL"),await s.sequence(),s.skipLog instanceof Array&&!(s.skipLog.length>0&&0==s.skipLog.filter(e=>e.match(/end/i)).length)||e.save("PennController",e.id,"_Header_","End",Date.now(),"NULL")),e.controller.sequence().then(h)}},f=$("<div><p>Please wait while the resources are preloading</p><p>This may take up to "+Object(r.f)(t)+".</p></div>");e.element.append(f);for(let t in e.controller.resources){let n=e.controller.resources[t],i=n.resolve;"ready"!=n.status&&(n.resolve=function(){i.apply(n),0==e.controller.resources.filter(e=>"ready"!=e.status).length&&d()})}0==e.controller.resources.filter(e=>"ready"!=e.status).length?d():setTimeout((function(){d(!0)}),t)}},properties:{obligatory:[],countsForProgressBar:!0,htmlDescription:null}}),window.PennController=new Proxy(h,{get:(e,t)=>{if(t in e)return e[t];i.a.debug.error("Unknown global PennController command: &lsquo;"+t+"&rsquo;")}})},function(e,t){var n;n=function(){return this}();try{n=n||new Function("return this")()}catch(e){"object"==typeof window&&(n=window)}e.exports=n},function(e,t,n){"use strict";var i={};function r(){try{return new window.XMLHttpRequest}catch(e){}}i._getBinaryFromXHR=function(e){return e.response||e.responseText};var s=window.ActiveXObject?function(){return r()||function(){try{return new window.ActiveXObject("Microsoft.XMLHTTP")}catch(e){}}()}:r;i.getBinaryContent=function(e,t){try{var n=s();n.open("GET",e,!0),"responseType"in n&&(n.responseType="arraybuffer"),n.overrideMimeType&&n.overrideMimeType("text/plain; charset=x-user-defined"),n.onreadystatechange=function(r){var s,o;if(4===n.readyState)if(200===n.status||0===n.status){s=null,o=null;try{s=i._getBinaryFromXHR(n)}catch(e){o=new Error(e)}t(o,s)}else t(new Error("Ajax error for "+e+" : "+this.status+" "+this.statusText),null)},n.send()}catch(e){t(new Error(e),null)}},e.exports=i},function(e,t,n){(function(n){var i,r,s;r=[],void 0===(s="function"==typeof(i=function(){"use strict";function t(e,t,n){var i=new XMLHttpRequest;i.open("GET",e),i.responseType="blob",i.onload=function(){o(i.response,t,n)},i.onerror=function(){console.error("could not download file")},i.send()}function i(e){var t=new XMLHttpRequest;return t.open("HEAD",e,!1),t.send(),200<=t.status&&299>=t.status}function r(e){try{e.dispatchEvent(new MouseEvent("click"))}catch(n){var t=document.createEvent("MouseEvents");t.initMouseEvent("click",!0,!0,window,0,0,0,80,20,!1,!1,!1,!1,0,null),e.dispatchEvent(t)}}var s="object"==typeof window&&window.window===window?window:"object"==typeof self&&self.self===self?self:"object"==typeof n&&n.global===n?n:void 0,o=s.saveAs||"object"!=typeof window||window!==s?function(){}:"download"in HTMLAnchorElement.prototype?function(e,n,o){var a=s.URL||s.webkitURL,l=document.createElement("a");n=n||e.name||"download",l.download=n,l.rel="noopener","string"==typeof e?(l.href=e,l.origin===location.origin?r(l):i(l.href)?t(e,n,o):r(l,l.target="_blank")):(l.href=a.createObjectURL(e),setTimeout((function(){a.revokeObjectURL(l.href)}),4e4),setTimeout((function(){r(l)}),0))}:"msSaveOrOpenBlob"in navigator?function(e,n,s){if(n=n||e.name||"download","string"!=typeof e)navigator.msSaveOrOpenBlob(function(e,t){return void 0===t?t={autoBom:!1}:"object"!=typeof t&&(console.warn("Depricated: Expected third argument to be a object"),t={autoBom:!t}),t.autoBom&&/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(e.type)?new Blob(["\ufeff",e],{type:e.type}):e}(e,s),n);else if(i(e))t(e,n,s);else{var o=document.createElement("a");o.href=e,o.target="_blank",setTimeout((function(){r(o)}))}}:function(e,n,i,r){if((r=r||open("","_blank"))&&(r.document.title=r.document.body.innerText="downloading..."),"string"==typeof e)return t(e,n,i);var o="application/octet-stream"===e.type,a=/constructor/i.test(s.HTMLElement)||s.safari,l=/CriOS\/[\d]+/.test(navigator.userAgent);if((l||o&&a)&&"object"==typeof FileReader){var u=new FileReader;u.onloadend=function(){var e=u.result;e=l?e:e.replace(/^data:[^;]*;/,"data:attachment/file;"),r?r.location.href=e:location=e,r=null},u.readAsDataURL(e)}else{var h=s.URL||s.webkitURL,c=h.createObjectURL(e);r?r.location=c:location.href=c,r=null,setTimeout((function(){h.revokeObjectURL(c)}),4e4)}};s.saveAs=o.saveAs=o,e.exports=o})?i.apply(t,r):i)||(e.exports=s)}).call(this,n(3))},function(e,t,n){"use strict";var i=n(0),r=n(1);$.prototype.left=function(){return Number(this.css("left").replace(/px/,""))},$.prototype.top=function(){return Number(this.css("top").replace(/px/,""))};i.a.Prerun(()=>{const e=window.location.pathname;if(!i.a.debug.on||null==="2.0".match(/beta/i)||window.localStorage&&window.localStorage.getItem(e))return;const t=new s("Beta Version",400,200,"calc(50vw - 200px)","calc(50vh - 100px)");t.container.find("div:nth-child(3)").remove(),t.content.html("<p>Please note that this project is using a <strong>beta</strong> version of PennController (2.0).</p>\n                               <p>Report new bugs at <a href='https://www.pcibex.net/bug-report/' target='_blank'>https://www.pcibex.net/bug-report/</a>\n                                  or at <a href='mailto:support@pcibex.net'>support@pcibex.net</a></p>"),t.popIn(),t.titleExpand.click().remove();const n=t.popOut;t.popOut=()=>{window.localStorage.setItem(e,!0),n.call(t)}});class s{constructor(e,t,n,i,r){let s=this;this.title=e,this.width=t,this.height=n,this.x=i,this.y=r,this.tabs=[],this.container=$("<div>").css({width:t,height:"3em",overflow:"hidden",position:"fixed","border-radius":"5px","background-color":"floralwhite","min-height":"3em","min-width":"3em","z-index":9999}),this.titleBar=$("<div>").css({width:"100%",height:"1.5em",margin:0,padding:0,"background-color":"gray",cursor:"move",color:"white","border-radius":"5px 5px 0px 0px"}),this.titleExpand=$("<span>&#9656;</span>").css({display:"inline-block","line-height":"1.3em",padding:"2px","margin-right":"0.25em",cursor:"pointer"}).click(()=>{9656==this.titleExpand.html().charCodeAt(0)?(this.titleExpand.html("&#9662;"),this.container.css({height:this.height,overflow:"unset"})):(this.titleExpand.html("&#9656;"),this.container.css({height:"3em",overflow:"hidden"}))}),this.titleSpan=$("<span>"+e+"</span>").css({display:"inline-block",padding:"2px","line-height":"1.3em",overflow:"hidden"}),this.titleBar.append(this.titleSpan.prepend(this.titleExpand)).append($("<span>X</span>").css({width:"1.3em",height:"1.3em",margin:"0.1em","line-height":"1.3em","border-radius":"2px","text-align":"center",position:"absolute",right:0,cursor:"pointer",overflow:"hidden"}).click((function(){s.popOut()})).mouseenter((function(){$(this).css({border:"solid 1px lightgray","border-radius":"2px"})})).mouseleave((function(){$(this).css({border:"none"})}))).mousedown((function(e){s.updatePosition={x:e.clientX,y:e.clientY,left:s.container.left(),top:s.container.top()},e.preventDefault()})),this.tabBar=$("<div>").css({width:"calc(100% - 10px)",height:"1.5em","margin-bottom":"0px",overflow:"hidden",display:"flex","margin-left":"5px","margin-right":"5px"}),this.tabBar.append($("<div>").css({width:"100%","border-bottom":"solid 1px lightgray"})),this.newTab=(e,t)=>{e instanceof jQuery||(e=$("<span>").append(e)),t instanceof jQuery||(t=$("<div>").append(t));let n={title:e,content:t,jQuery:$("<div>").append(e).css({border:"solid 1px lightgray","border-top-right-radius":"5px","border-top-left-radius":"5px","padding-left":"5px","padding-right":"5px",cursor:"pointer"}).click(()=>{this.content.children().detach(),this.content.append(n.content),this.tabBar.children().css({background:"linen",color:"darkgray","border-bottom":"solid 1px lightgray"}),n.jQuery.css({color:"black",background:"inherit","border-bottom":"none"}),a.activeTab=n}),remove:()=>this.jQuery.remove()};return this.tabs.push(n),this.tabBar.prepend(n.jQuery),n},this.container.append($("<div>").css({display:"inline-block",width:"1.3em",height:"1.3em",position:"absolute",bottom:0,right:0,cursor:"se-resize",background:"repeating-linear-gradient(135deg,rgba(255,255,255,.5),rgba(255,255,255,.5) 2px,#777 2px,#777 4px)","clip-path":"polygon(90% 0,90% 90%,0 90%)",opacity:"0.5"}).mousedown((function(e){s.updateSize=!0,s.offsetRight=e.clientX-(s.container.left()+s.container.width()),s.offsetBottom=e.clientY-(s.container.top()+s.container.height()),e.preventDefault()}))),this.content=$("<div>").css({border:"solid 1px lightgray","font-family":"monospace","font-size":"0.9em",margin:"0px 5px 5px 5px",padding:"2px",height:"calc(100% - 4.5em - 30px)",overflow:"auto","border-top":"none"}),this.container.append(this.titleBar),this.container.append($("<div>Use <tt>DebugOff()</tt> before publishing.</div>").css({height:"1.5em","overflow-x":"hidden"})),this.container.append(this.tabBar),this.container.append(this.content),this.container.css({left:i,top:r}),$(document).mousemove((function(e){s.updatePosition&&(s.x=s.updatePosition.left+(e.clientX-s.updatePosition.x),s.y=s.updatePosition.top+(e.clientY-s.updatePosition.y),s.container.css({left:s.x,top:s.y})),s.updateSize&&(s.width=e.clientX-s.container.left()-s.offsetRight,s.height=e.clientY-s.container.top()-s.offsetBottom,s.container.css({width:s.width,height:s.height}))})).mouseup((function(){s.updatePosition=void 0,s.updateSize=!1}))}popIn(){$(document.body).append(this.container)}popOut(){this.container.detach()}}let o=!1,a={popin:{},tablePopin:{},infoTab:null,runningOrder:null,runningIndex:-1,runningElement:-1,currentController:null,currentTable:null,activeTab:null};i.a.debug={on:!0,currentPromise:null,forceResolve:()=>{i.a.debug.currentPromise instanceof Function&&i.a.debug.currentPromise()},addToTab:(e,...t)=>{if(!i.a.debug.on)return;let n;n=i.a.controllers.running?i.a.controllers.list[i.a.controllers.running.id]:i.a.controllers.underConstruction,null==n&&(n={id:"NA"});let r=new Date;e.prepend($("<div>["+[r.getHours(),r.getMinutes(),r.getSeconds()].join(":")+"] "+t.join(";")+" (newTrial: "+n.id+(n.useLabel?"-"+n.useLabel:"")+")</div>").css({"border-bottom":"dotted 1px gray","margin-bottom":"1px","padding-bottom":"1px"}))},log:(...e)=>i.a.debug.addToTab(a.logTab.log,...e),warning:(...e)=>{i.a.debug.on&&(i.a.debug.addToTab(a.warningsTab.content,...e),a.warningsTab.title.css("color","orange"),a.warningsTab.content.find(".PennController-debug-nowarnings").css("display","none"),9656==a.popin.titleExpand.html().charCodeAt(0)&&a.popin.titleExpand.click(),a.warningsTab.jQuery.click())},error:(...e)=>{i.a.debug.on&&(i.a.debug.addToTab(a.errorsTab.content,...e),a.errorsTab.title.css("color","red"),a.errorsTab.content.find(".PennController-debug-noerrors").css("display","none"),9656==a.popin.titleExpand.html().charCodeAt(0)&&a.popin.titleExpand.click(),a.errorsTab.jQuery.click())}},a.popin=new s("Debug (PennController 2.0)",440,240,window.innerWidth-450,10),a.logTab=a.popin.newTab("Log"),a.logTab.controls=$("<div>").append($("<button>Next screen</button>").click(()=>{"PennController-"==a.currentController._cssPrefix?i.a.controllers.running.endTrial():a.currentController._finishedCallback()})).append($("<button>Next command</button>").click(()=>i.a.debug.forceResolve())).css({background:"lightgray","border-bottom":"dotted 1px black"}).appendTo(a.logTab.content),a.logTab.log=$("<div>").appendTo(a.logTab.content),a.warningsTab=a.popin.newTab("Warnings"),a.warningsTab.content.prepend($("<div>No warnings</div>").css({"font-style":"italic","text-align":"center",margin:"5px"}).addClass("PennController-debug-nowarnings")),a.errorsTab=a.popin.newTab("Errors"),a.errorsTab.content.prepend($("<div>No errors found</div>").css({"font-style":"italic","text-align":"center",margin:"5px"}).addClass("PennController-debug-noerrors"));let l=()=>{a.currentTable&&a.currentTable.debug&&(a.currentTable.debug.content.find("tr").css("background-color","transparent"),$(a.currentTable.debug.content.find("tr")[a.currentRow+1]).css("background-color","pink"),a.tablePopin.titleSpan.after(u),a.currentTable.hasOwnProperty("group")&&a.currentTable.table[0].hasOwnProperty(a.currentTable.group)&&u.after(c))},u=$("<a title='Jump to current row'>&#9755;</a>").click((function(){a.currentTable.debug.jQuery.click();let e=$(a.currentTable.debug.content.find("tr")[a.currentRow+1]).position().top;a.currentTable.debug.content.children()[2].scrollTop+=e})).css({display:"inline-block",padding:"2px 5px","line-height":"1.3em",overflow:"hidden"}),h=!1,c=$("<a title='Show/Hide rows from other groups'>&#128065;</a>").click((function(){if(h)a.currentTable.debug.content.find("tr").css("display","table-row");else{let e=a.currentTable.table[a.currentRow][a.currentTable.group],t=a.currentTable.debug.content.find("tr");for(let n=0;n<a.currentTable.table.length;n++)a.currentTable.table[n][a.currentTable.group]!=e&&$(t[n+1]).css("display","none")}h=!h})).css({display:"inline-block",padding:"4px 5px 0px 5px","line-height":"1.3em",overflow:"hidden"}),d=e=>{let t=Object.keys(e.table[0]),n=$("<table>").css({display:"table","table-layout":"fixed",height:"100%",width:70*(t.length+1)}),i=$("<table>").css({display:"table","table-layout":"fixed",height:"100%",width:70*(t.length+1)}),r=$("<tr>");r.append($("<th>").html("<em>#</em>").css({width:70,overflow:"hidden"}));for(let e=0;e<t.length;e++)r.append($("<th>").html(t[e]).css({width:70,overflow:"hidden"}));i.append(r);for(let i=0;i<e.table.length;i++){let r=$("<tr>");r.append($("<td>").html("<em>"+Number(i+1)+".</em>").css({width:70,overflow:"hidden"}));for(let n=0;n<t.length;n++)r.append($("<td>").html(e.table[i][t[n]]).css({width:70,overflow:"hidden"}));n.append(r)}let s=$("<div>").css({height:"calc(100% - 1.5em)",overflow:"auto"}).append(n),o=$("<div>").css({height:"1.5em",width:"100%"}),a=$("<div>").css({width:"100%",position:"absolute",left:0,top:0}).append(i);return s.scroll(()=>a.css("margin-left",-1*s[0].scrollLeft)),$("<div>").css({width:"100%",height:"100%","white-space":"nowrap",position:"relative",overflow:"hidden"}).append(a).append(o).append(s)},f=e=>{if(a.tablePopin.hasOwnProperty("container"))a.tablePopin.container.parent().length>0?a.tablePopin.tabs[e].jQuery.click():$(document.body).append(a.tablePopin.container);else{a.tablePopin=new s("Tables",window.innerWidth-320,190,10,window.innerHeight-200);let t=Object.keys(i.a.tables);for(let e=0;e<t.length;e++)i.a.tables[t[e]].debug=a.tablePopin.newTab(t[e],d(i.a.tables[t[e]]));a.tablePopin.content.css("overflow","hidden"),a.tablePopin.tabs[e].jQuery.click()}l()};const p=()=>{if(a.runningIndex<0&&(a.runningIndex=0),a.runningElement<0?a.runningElement=0:(a.runningElement++,a.runningElement>=a.runningOrder[a.runningIndex].length&&(a.runningElement=0,a.runningIndex++)),"__SendResults__"==a.runningOrder[a.runningIndex][a.runningElement].controller&&(o=!0),!i.a.debug.on)return void(window.items=void 0);if(b(),g(),u.detach(),c.detach(),a.currentTable=null,a.currentTableName="<em>NA</em>",a.currentRow=-1,a.currentController=a.runningOrder[a.runningIndex][a.runningElement].options,a.currentController.hasOwnProperty("_PennController")){a.currentTable=a.currentController._PennController.table;for(let e in i.a.tables)i.a.tables[e]==a.currentTable&&(a.currentTableName=e);a.currentRow=Number(a.currentController._PennController.row),l()}let e=a.runningOrder[a.runningIndex][a.runningElement];a.infoTab.content.empty(),a.infoTab.content.append($("<div><strong>Trial in sequence</strong> "+Number(a.runningIndex+1)+" / "+a.runningOrder.length+"</div>")).append($("<div><strong>Element in trial</strong> "+Number(a.runningElement+1)+" / "+a.runningOrder[a.runningIndex].length+"</div>")).append($("<div><strong>Trial's label:</strong> "+e.type+"</div>")).append($("<div><strong>Trial's type (controller):</strong> "+e.controller+"</div>")).append($("<div><strong>Trial's index:</strong> "+e.itemNumber+" / "+window.items.length+"</div>")).append($("<div><strong>From table:</strong> "+a.currentTableName+"</div>")),"PennController"==e.controller?$(a.logTab.controls.children()[1]).css("display","inline-block"):$(a.logTab.controls.children()[1]).css("display","none")};let m=window.dget;window.dget=(...e)=>{let t=m(...e);return e[1]&&"displayMode"==e[1]&&e[2]&&"overwrite"==e[2]&&p(),t};const g=()=>{if(window.conf_showProgressBar){let e=0,t=0;a.runningOrder.forEach((n,i)=>n.forEach((n,r)=>{const s=ibex_controller_get_property(n.controller,"countsForProgressBar");(void 0===s||s)&&(e++,(i<a.runningIndex||i==a.runningIndex&&r<=a.runningElement)&&t++)}));const n=$("#bod > table div.bar-container"),i=n.find(".bar"),r=5*e<300?5*e:300,s=t*r/e;n.css("width",r),i.css("width",Math.round(s)+"px")}},y=e=>{a.runningIndex<e&&("PennController-"==a.currentController._cssPrefix?i.a.controllers.running.endTrial():a.currentController._finishedCallback(),setTimeout(()=>y(e),1))},b=()=>{const e=$("<ol>");for(let t=0;t<a.runningOrder.length;t++){let n=a.runningOrder[t],i=[];for(let e=0;e<n.length;e++)i.push(n[e].controller);let r=[];n[0].options.hasOwnProperty("_PennController")&&(r=[":",n[0].options._PennController.table.id,n[0].options._PennController.row+1]);let s=n[0].type+" ("+i.join(",")+r.join(":")+")";const o=$("<li>").append(s);t<=a.runningIndex?o.css({color:"gray","background-color":t==a.runningIndex?"pink":"transparent"}):o.append($("<button>Reach</button>").click(()=>y(t))),e.append(o)}a.sequenceTab.content.empty().append(e)};let w=window.$.ajax;window.$.ajax=(...e)=>(i.a.debug.on&&e[0]&&e[0].url&&e[0].url.match(/\?allchunks=1$/)&&a.popin.popIn(),w(...e)),i.a.Prerun(()=>{window.onbeforeunload=function(){if(!o)return"Your results have not been sent yet. Do you really want to leave the page?"};let e=!1;PennController.version="2.0";let t=window.assert;window.assert=function(...n){if(e||"There must be some items in the running order!"!=n[1])return t.apply(this,n);e=!0;let r=window.conf_modifyRunningOrder;return window.conf_modifyRunningOrder=function(e){a.runningOrder=r instanceof Function?r.call(this,e):e,i.a.runningOrder={active:a.runningOrder,original:[...a.runningOrder]};const t=i.a.runningOrder.active.push;let n=!1;return i.a.runningOrder.active.push=function(...e){const r=t.apply(this,e);return!n&&e[0]instanceof Array&&e[0][0]&&"__SendResults__"==e[0][0].controller&&(i.a.runningOrder.original=[...this],n=!0),r},Object.defineProperty(i.a.runningOrder,"runningIndex",{get:()=>a.runningIndex}),i.a.debug.on&&(()=>{let e=Object.keys(i.a.tables);if(e.length>0){let t=$("<ul>");for(let n=0;n<e.length;n++)t.append($("<li>").html(e[n]).click(()=>f(n)).css("cursor","pointer"));a.popin.newTab("Tables",t)}a.sequenceTab=a.popin.newTab("Sequence"),a.infoTab=a.popin.newTab("Info"),b(),a.activeTab?a.activeTab.jQuery.click():a.errorsTab.jQuery.click(),$(window.document).bind("keyup keydown",(function(e){if(e.ctrlKey&&68==e.keyCode){let t=window.innerWidth-450,n=window.innerHeight-250;return $(window.document.body).append(a.popin.container),a.popin.x=t,a.popin.y=n,a.popin.container.css({top:n,left:t}),e.preventDefault(),e.stopPropagation(),!1}}))})(),p(),a.runningOrder},t.apply(this,n)}}),window.onerror=function(e,t,n){if(!t.match(/include=data$/))return;let s=e.match(/ReferenceError: (.+) is not defined/);if(s)if(s[1].match(/^(new|get|default)/)&&PennController.Elements[s[1]])i.a.debug.error("Tried to use &lsquo;"+s[1]+"&rsquo; without a prefix on line "+n+"; did you forget to use PennController.ResetPrefix?");else{let e={score:1,command:""},t=Object.getOwnPropertyNames(PennController.Elements);for(let n=0;n<t.length;n++){let i=Object(r.e)(s[1],t[n])/s[1].length;i<e.score&&(e.score=i,e.command=t[n])}e.score<.5?i.a.debug.error("Wrong command &lsquo;"+s[1]+"&rsquo; on line "+n+". Did you mean to type &lsquo;<strong>"+e.command+"</strong>&rsquo;?"):i.a.debug.error("Unrecognized expression &lsquo;"+s[1]+"&rsquo; (line "+n+")")}else i.a.debug.error(e)};let v=window.ibex_controller_get_property;window.ibex_controller_get_property=(e,t)=>{let n=Object.getOwnPropertyNames($.ui);if(n.indexOf(e)>-1)return v(e,t);let s={score:1,controllerName:""};for(let t=0;t<n.length;t++){let i=Object(r.e)(e,n[t])/e.length;i<s.score&&(s.score=i,s.controllerName=n[t])}s.score<.5?i.a.debug.error("Invalid controller reference: &lsquo;"+e+"&rsquo;---Did you mean to type <strong>"+s.controllerName+"</strong>?"):i.a.debug.error("Invalid controller reference: &lsquo;"+e+"&rsquo;")}},function(e,t,n){"use strict";var i=n(1),r=n(2),s=n(0);r.b.Elements={};class o{constructor(){this._commands=[],this._currentType="action."}}Object.defineProperty(r.b.Elements,"self",{get:()=>{const e=new o,t=new Proxy(e,{get:(n,i)=>{if("_commands"==i||"_currentType"==i||"hasOwnProperty"==i)return e[i];if(console.log("Getting self's proxy, with",i),"settings"==i)e._currentType="settings.";else if("test"==i)e._currentType="test.";else{if("testNot"!=i){console.log("Action on self");let n={name:e._currentType.replace("action.","")+i};e._commands.push(n);const r=(...e)=>(n.args=e,console.log("Added args",e,"to",n),t);return e._currentType="action.",r}e._currentType="testNot."}return t}});return t}});const a=[];s.a.ArgumentCallback=e=>a.push(e);const l=async function(e){for(let t=0;t<e.length;t++)if(a.map(n=>n instanceof Function&&n.call(null,e[t])),e[t]instanceof f&&"Var"==e[t].type&&0==e[t]._promises.length)e[t]._runPromises instanceof Function&&await e[t]._runPromises(),e[t]=e[t].value;else if(e[t]instanceof o){let n=new f(this,m[this.type]),i=n._proxy;const r=e[t]._commands;for(let e=0;e<r.length;e++){const t=r[e];console.log("About to call",t.name,"with",t.args,"on",i),i=t.name.match(/^settings\./)?i.settings[t.name.replace(/^settings\./,"")](...t.args):t.name.match(/^test\./)?i.test[t.name.replace(/^test\./,"")](...t.args):t.name.match(/^testNot\./)?i.testNot[t.name.replace(/^test\./,"")](...t.args):i[t.name](...t.args)}e[t]=n,console.log("Replaced self with",e[t])}return e};s.a.utils.evaluateArguments=l;let u=function(e){return function(...t){let n=this;return new Promise(async i=>{let r=s.a.controllers.running;s.a.debug.currentPromise=i;await l.call(n,t),e.apply(n,[(...e)=>s.a.controllers.running!=r||i(...e)].concat(t))})}},h=function(e){let t=[],n=()=>new Promise(e=>e()),r=()=>new Promise(e=>e()),o=function(...i){let o=this;return new Promise((async function(a){let u=s.a.controllers.running;s.a.debug.currentPromise=a;let h=(...e)=>s.a.controllers.running!=u||a(...e);await l.call(o,i);let c=e.apply(o,i),d="and";for(let e=0;e<t.length;e++){let n=t[e];"and"==n?d="and":"or"==n?d="or":n&&n._runPromises&&n.success&&(n="success"==await n._runPromises(),"and"==d?c=c&&n:"or"==d&&(c=c||n))}c?(await n(),h("success")):(await r(),h("failure"))}))};return o.and=e=>{t.push("and"),t.push(e)},o.or=e=>{t.push("or"),t.push(e)},o.success=function(...e){n=Object(i.d)(e.map(e=>async()=>{const t=await l.call(this,[e]);t[0]&&t[0]._runPromises instanceof Function&&await t[0]._runPromises()}))},o.failure=function(...e){r=Object(i.d)(e.map(e=>async()=>{const t=await l.call(this,[e]);t[0]&&t[0]._runPromises instanceof Function&&await t[0]._runPromises()}))},o};class c{constructor(e,t,n){let i=$("<PennElement>"),r=i.css,o=[];i.css=(...e)=>{o.push(e),r.apply(i,e)};let a=!1;Object.defineProperty(this,"jQueryElement",{set:function(t){if(!(t instanceof jQuery))return s.a.debug.error("Tried to assign a non jQuery element to PennElement named "+e);if(a)return i=t;let n=i.data("events");n&&$.each(n,(function(){$.each(this,(function(){t.bind(this.type,this.handler)}))}));for(let e in o)t.css(...o[e]);i=t,a=!0},get:function(){return i}}),this.jQueryContainer=$("<div>"),this.id=e,this.type=t,this.validate=()=>this.hasValidated=!0,this._printCallback=[],n.hasOwnProperty("end")&&(this.end=async function(){await n.end.apply(this)})}}s.a.PennElement=c;let d=(e,t,n,r)=>{let o="",a=e.replace(/^\.(settings|testNot|test)\./,"");Object(i.e)(a,"settings")/"settings".length<.5&&(o=" Did you mean to type &lsquo;<strong>settings</strong>&rsquo;?"),Object(i.e)(a,"test")/"test".length<.5&&(o=" Did you mean to type &lsquo;<strong>test</strong>&rsquo;?"),Object(i.e)(a,"testNot")/"testNot".length<.5&&(o=" Did you mean to type &lsquo;<strong>testNot</strong>&rsquo;?");let l={score:1,command:""};for(let e=0;e<r.length;e++){let t=Object(i.e)(a,r[e])/a.length;t<l.score&&(l.score=t,l.command=r[e])}l.score<.5&&(o=" Did you mean to type <strong>"+e.replace(a,l.command)+"</strong>?"),s.a.debug.error("Command &lsquo;"+e+"&rsquo; unknown on "+t+" element &lsquo;"+n+"&rsquo;."+o)};class f{constructor(e,t){let n=new Proxy(this,{get:(e,i)=>{if(i in this)return e[i];{if("_runPromises"==i)return()=>this._runPromises.call(this);let e;try{e=this[i]}catch(e){return d(i,this.type,this._element.id,Object.getOwnPropertyNames(t.actions)),n}return void 0===e&&"string"==typeof i&&"nodeType"!=i&&d(i,this.type,this._element.id,Object.getOwnPropertyNames(t.actions)),e}}});if(this._proxy=n,e instanceof c)n._element=e;else if("string"==typeof e){let i;i=s.a.controllers.running?s.a.controllers.list[s.a.controllers.running.id]:s.a.controllers.underConstruction,Object.defineProperty(n,"_element",{get:()=>i._getElement(e,t.name)})}n.type=t.name,n._promises=[];for(let e in t.actions)n[e]=function(...r){let o=u((function(...r){s.a.debug.on&&s.a.debug.log("<div style='color: lightsalmon'>"+n._element.id+" ("+t.name+") Action command '"+e+"' running, params: "+JSON.stringify(Object(i.i)(r))+"</div>"),t.actions[e].apply(this,r)}));return n._promises.push(()=>o.apply(n._element,r)),n};n.settings=new Proxy({},{get:(e,n)=>{if(n in e)return e[n];d(".settings."+n,this.type,this._element.id,Object.getOwnPropertyNames(t.settings))}});for(let e in t.settings)n.settings[e]=function(...r){let o=u((function(...r){s.a.debug.on&&s.a.debug.log("<div style='color: salmon'>"+n._element.id+" ("+t.name+") Settings command '"+e+"' running, params: "+JSON.stringify(Object(i.i)(r))+"</div>"),t.settings[e].apply(this,r)}));return n._promises.push(()=>o.apply(n._element,r)),n};n.test=new Proxy({},{get:(e,n)=>{if(n in e)return e[n];d(".test."+n,this.type,this._element.id,Object.getOwnPropertyNames(t.test))}}),n.testNot=new Proxy({},{get:(e,n)=>{if(n in e)return e[n];d(".testNot."+n,this.type,this._element.id,Object.getOwnPropertyNames(t.test))}});for(let e in t.test)n.test[e]=function(...r){let o=h((function(...r){return s.a.debug.on&&s.a.debug.log("<div style='color: darksalmon'>"+n._element.id+" ("+t.name+") Test command '"+e+"' running, params: "+JSON.stringify(Object(i.i)(r))+"</div>"),t.test[e].apply(this,r)}));return n._promises.push(()=>o.apply(n._element,r)),n.success=(...e)=>(o.success.apply(n._element,e),n),n.failure=(...e)=>(o.failure.apply(n._element,e),n),n.and=e=>(o.and.call(n._element,e),n),n.or=e=>(o.or.call(n._element,e),n),n},n.testNot[e]=function(...r){let o=h((function(...n){return s.a.debug.on&&s.a.debug.log(t.name+" testNot command "+e+" running, params: "+JSON.stringify(Object(i.i)(n))),!t.test[e].apply(this,n)}));return n._promises.push(()=>o.apply(n._element,r)),n.success=(...e)=>(o.success.apply(n._element,e),n),n.failure=(...e)=>(o.failure.apply(n._element,e),n),n.and=e=>(o.and.call(n._element,e),n),n.or=e=>(o.or.call(n._element,e),n),n};t.value&&Object.defineProperty(n,"value",{get:()=>t.value.apply(n._element)})}_runPromises(){return Object(i.d)(this._promises)()}}s.a.PennElementCommands=f;let p={actions:{scaling:function(e,t,n){let i=this.jQueryElement,r=0,o=0,a=0,l=0;const u=s.a.controllers.running,h=(e,t)=>{let n=0;if(!isNaN(Number(e)))return Number(e);if(e.match(/(\d+(.\d+)?)px/))n=Number(e.replace(/^[^\d]*(\d+(.\d+)?)px.*$/,"$1"));else{const t=$("<div>").css("width",e);n=t.appendTo(i.parent()).width(),t.remove()}return n/t},c=()=>{if(u!=s.a.controllers.running)return;this.jQueryContainer&&this.jQueryContainer instanceof jQuery&&this.jQueryContainer.parent().length&&(i=this.jQueryContainer);const e=i.width(),d=i.height(),f=$(window).width(),p=$(window).height();window.requestAnimationFrame(c),r=e,o=d,a=f,l=p;let m="";if(t.match(/page|screen/i)){m=a/l<r/o?`scale(${h("100vw",r)})`:`scale(${h("100vh",o)})`}else m=void 0===n||n.match(/auto/i)?`scale(${h(t,r)})`:t.match(/auto/i)?`scale(${h(n,o)})`:`scale(${h(t,r)},${h(n,o)})`;let g=i.css("transform");g=g.replace(/^none$|matrix\([^)]+\)/,m),i.css("transform",g)};c(),e()},print:async function(e,t,n,o){const a=[t,n,o];if(this._lastPrint=a,o&&"string"==typeof o&&(o=r.b.Elements.getCanvas(o)),o&&o instanceof f&&"Canvas"==o.type)return o.settings.add(t,n,r.b.Elements["get"+this.type](this.id))._runPromises().then(e);if(this.jQueryElement&&this.jQueryElement instanceof jQuery){this.jQueryContainer.detach(),this.jQueryContainer.empty(),this.cssToApply instanceof Array&&this.cssToApply.forEach(e=>this.jQueryElement.css(...e)),this.jQueryElement.addClass("PennController-"+this.type.replace(/[\s_]/g,"")),this.jQueryElement.addClass("PennController-"+this.id.replace(/[\s_]/g,""));let e=this.jQueryContainer;if(e.css("display","inherit"),"string"==typeof this.jQueryAlignment&&(this.jQueryAlignment.match(/left/i)?e.css("align-self","start"):this.jQueryAlignment.match(/center/i)?e.css("align-self","center"):this.jQueryAlignment.match(/right/i)&&e.css("align-self","end")),e.addClass("PennController-elementContainer").addClass("PennController-"+this.type.replace(/[\s_]+/g,"")+"-container").addClass("PennController-"+this.id.replace(/[\s_]+/g,"")+"-container").append(this.jQueryElement),t instanceof jQuery)t.append(e);else if(t instanceof f&&t._element.jQueryElement instanceof jQuery)t._element.jQueryElement.append(e);else if(void 0!==n){const r=s.a.controllers.running;i.j.call(e,t,n,$("body"),()=>r!=s.a.controllers.running||this._lastPrint!=a)}else s.a.controllers.running.element.append(e);this.cssContainer instanceof Array&&this.cssContainer.forEach(t=>e.css(...t));let r=$("<div>").css("display","inline-block").addClass("PennController-before"),o=$("<div>").css("display","inline-block").addClass("PennController-after");this.jQueryElement.before(r),this.jQueryElement.after(o);for(let e in this.jQueryBefore)this.jQueryBefore[e]&&this.jQueryBefore[e]._element&&await new Promise(t=>p.actions.print.call(this.jQueryBefore[e]._element,t,r));for(let e in this.jQueryAfter)this.jQueryAfter[e]&&this.jQueryAfter[e]._element&&await new Promise(t=>p.actions.print.call(this.jQueryAfter[e]._element,t,o))}else s.a.debug.warning("No jQuery instance to print for element "+this.id);this.printTime=Date.now();for(let e=0;e<this._printCallback.length;e++)this._printCallback[e]instanceof Function&&await this._printCallback[e].call(this);e()},refresh:function(e){let t=this.jQueryElement.parent();if(!(t instanceof jQuery&&t.parent().length))return e();let n=$("<span>");t.before(n),r.b.Elements["get"+this.type](this.id).print(n)._runPromises().then(()=>{n.before(this.jQueryElement.parent()),n.remove(),e()})},remove:function(e){if(this.jQueryContainer instanceof jQuery&&this.jQueryContainer.detach(),this.jQueryElement instanceof jQuery?this.jQueryElement.detach():s.a.debug.error("No jQuery instance to remove for element "+this.id),this.jQueryBefore&&this.jQueryBefore.length)for(let e in this.jQueryBefore)this.jQueryBefore[e]._element&&this.jQueryBefore[e]._element.jQueryElement instanceof jQuery&&this.jQueryBefore[e]._element.jQueryElement.detach();if(this.jQueryAfter&&this.jQueryAfter.length)for(let e in this.jQueryAfter)this.jQueryAfter[e]._element&&this.jQueryAfter[e]._element.jQueryElement instanceof jQuery&&this.jQueryAfter[e]._element.jQueryElement.detach();e()},wait:function(e,t){if("first"==t&&this.hasValidated)e();else{let n=!1,i=this.validate;if(this.validate=()=>{if(i.apply(this),!n)if(t instanceof Object&&t._runPromises&&t.success){let i=this.disabled;this.jQueryElement.attr("disabled",!0),this.disabled="tmp",t._runPromises().then(t=>{"success"==t&&(n=!0,e()),"tmp"==this.disabled&&(this.disabled=i,this.jQueryElement.attr("disabled",i))})}else n=!0,e()},"number"==typeof t&&t>0){let e=Date.now(),t=()=>{Date.now()-e<=0?this.validate():window.requestAnimationFrame(t)};window.requestAnimationFrame(t)}}}},settings:{after:function(e,t){t._element&&t._element.jQueryElement instanceof jQuery?(t._element.jQueryAfter instanceof Array&&(t._element.jQueryAfter=t._element.jQueryAfter.filter(e=>e._element!=this)),this.jQueryElement instanceof jQuery&&this.jQueryElement.printed()&&(t=t.print(this.jQueryContainer.find(".PennController-after"))),t._runPromises().then(()=>{this.jQueryAfter.push(t),e()})):(s.a.debug.error("Tried to add an invalid element after element named "+this.id),e())},before:function(e,t){t._element&&t._element.jQueryElement instanceof jQuery?(t._element.jQueryBefore instanceof Array&&(t._element.jQueryBefore=t._element.jQueryBefore.filter(e=>e._element!=this)),this.jQueryElement instanceof jQuery&&this.jQueryElement.printed()&&t.print(this.jQueryContainer.find(".PennController-"+this.type+"-before")),t._runPromises().then(()=>{this.jQueryBefore.push(t),e()})):(s.a.debug.error("Tried to add an invalid element before element named "+this.id),e())},bold:function(e){this.jQueryElement instanceof jQuery?this.jQueryElement.css("font-weight","bold"):s.a.debug.error("Element named "+this.id+" has not jQuery element to render as bold"),e()},center:function(e){this.jQueryElement instanceof jQuery?(this.jQueryAlignment="center",this.jQueryElement.parent().length&&this.jQueryContainer.css("align-self","center")):s.a.debug.error("Element named "+this.id+" has not jQuery element to render as centered"),e()},color:function(e,t){this.jQueryElement&&"string"==typeof t?this.jQueryElement.css("color",t):s.a.debug.error("Element named "+this.id+" has not jQuery element to render as "+t),e()},cssContainer:function(e,...t){this.cssContainer||(this.cssContainer=[]),this.cssContainer.push(t),this.jQueryContainer.printed()&&this.jQueryContainer.css(...t),e()},css:function(e,...t){this.cssToApply||(this.cssToApply=[]),this.cssToApply.push(t),this.jQueryElement instanceof jQuery?this.jQueryElement.css(...t):s.a.debug.error("Element named "+this.id+" has not jQuery element on which to apply the CSS"),e()},disable:function(e){this.hasOwnProperty("jQueryElement")&&this.jQueryElement instanceof jQuery?this.jQueryElement.attr("disabled",!0).addClass("PennController-disabled"):s.a.debug.error("No jQuery instance to disable for element "+this.id),e()},enable:function(e){this.hasOwnProperty("jQueryElement")&&this.jQueryElement instanceof jQuery?this.jQueryElement.removeAttr("disabled").removeClass("PennController-disabled"):s.a.debug.error("No jQuery instance to enable for element "+this.id),e()},hidden:function(e){this.hasOwnProperty("jQueryElement")&&this.jQueryElement instanceof jQuery?this.jQueryElement.css({visibility:"hidden"}):s.a.debug.error("No jQuery instance to hide for element "+this.id),e()},italic:function(e){this.jQueryElement instanceof jQuery?this.jQueryElement.css("font-style","italic"):s.a.debug.error("Element named "+this.id+" has not jQuery element to render in italic"),e()},left:function(e){this.jQueryElement instanceof jQuery?(this.jQueryAlignment="left",this.jQueryElement.parent().length&&this.jQueryContainer.css("align-self","left")):s.a.debug.error("Element named "+this.id+" has not jQuery element to render as aligned to the left"),e()},log:function(e,t){this.log=void 0===t||t,e()},once:function(e){if(this.hasValidated)this.disabled=!0,this.jQueryElement.attr("disabled",!0);else{let e=this.validate;this.validate=()=>{e.apply(this),this.disabled=!0,this.jQueryElement.attr("disabled",!0)}}e()},right:function(e){this.jQueryElement instanceof jQuery?(this.jQueryAlignment="right",this.jQueryElement.parent().length&&this.jQueryContainer.css("align-self","right")):s.a.debug.error("Element named "+this.id+" has not jQuery element to render as aligned to the right"),e()},size:function(e,t,n){this.jQueryElement instanceof jQuery?(this.jQueryElement.width(t),this.jQueryElement.height(n),this.jQueryContainer instanceof jQuery&&("string"==typeof t&&t.match(/%$/)&&this.jQueryContainer.width("100%"),"string"==typeof n&&n.match(/%$/)&&this.jQueryContainer.height("100%"))):s.a.debug.error("Element named "+this.id+" has not jQuery element to render as aligned to the right"),e()},visible:function(e){this.hasOwnProperty("jQueryElement")&&this.jQueryElement instanceof jQuery?this.jQueryElement.css({visibility:"visible"}):s.a.debug.error("No jQuery instance to make visible for element "+this.id),e()}},test:{printed:function(){return!!(this.hasOwnProperty("jQueryElement")&&this.jQueryElement instanceof jQuery)&&this.jQueryElement.printed()}}};s.a.elements.standardCommands=p,r.b.Elements.jump=function(e){var t;"string"==typeof e&&(t=e,e=e=>e==t);let n=-1;const r=e=>s.a.runningOrder&&e()||setTimeout(()=>r(e),50);new Promise(e=>r(e)).then(()=>{console.log("ro",s.a.runningOrder);for(let t=0;t<s.a.runningOrder.original.length;t++){const i=s.a.runningOrder.original[t][0].type;if(e(i)){n=t;break}}n<0&&s.a.debug.error(`No trial has a label matching jump's predicate (${e})`)});const o=()=>new Promise(e=>{if(n<0)return e();s.a.runningOrder.active.splice(s.a.runningOrder.runningIndex+1,s.a.runningOrder.active.length,...s.a.runningOrder.original.slice(n,s.a.runningOrder.original.length)),e()});return{_promises:[o],_runPromises:()=>Object(i.d)([o])()}},r.b.Elements.fullscreen=function(){const e=()=>new Promise(e=>{if(document.documentElement.requestFullscreen)return document.documentElement.requestFullscreen().then(e).catch(e);document.documentElement.mozRequestFullScreen?document.documentElement.mozRequestFullScreen():document.documentElement.webkitRequestFullscreen?document.documentElement.webkitRequestFullscreen():document.documentElement.msRequestFullscreen&&document.documentElement.msRequestFullscreen(),e()});return{_promises:[e],_runPromises:()=>Object(i.d)([e])()}},r.b.Elements.exitFullscreen=function(){const e=()=>new Promise(e=>{if(document.exitFullscreen)return document.exitFullscreen().then(e).catch(e);document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitExitFullscreen?document.webkitExitFullscreen():document.msExitFullscreen&&document.msExitFullscreen(),e()});return{_promises:[e],_runPromises:()=>Object(i.d)([e])()}},r.b.Elements.clear=function(){const e=()=>new Promise(async e=>{let t=s.a.controllers.list[s.a.controllers.running.id];for(let e in t.elements)for(let n in t.elements[e]){let i=t.elements[e][n],s=r.b.Elements["get"+i.type](i.id);await s.remove()._runPromises()}e()});return{_promises:[e],_runPromises:()=>Object(i.d)([e])()}},r.b.Elements.end=function(){const e=()=>new Promise(async e=>{await s.a.controllers.running.endTrial(),e()});return{_promises:[e],_runPromises:()=>Object(i.d)([e])()}};let m={};r.b._AddElementType=function(e,t){m.hasOwnProperty(e)&&s.a.debug.error("Element type "+e+" defined more than once"),m[e]=function(t){let n=new t(s.a);n.hasOwnProperty("actions")||(n.actions={}),n.hasOwnProperty("settings")||(n.settings={}),n.hasOwnProperty("test")||(n.test={});for(let e in p.actions)n.actions.hasOwnProperty(e)||(n.actions[e]=p.actions[e]);for(let e in p.settings)n.settings.hasOwnProperty(e)||(n.settings[e]=p.settings[e]);for(let e in p.test)n.test.hasOwnProperty(e)||(n.test[e]=p.test[e]);for(let e in n.settings)n.actions.hasOwnProperty(e)||(n.actions[e]=n.settings[e]);let i=n.uponCreation;n.uponCreation=function(e){this.jQueryAfter=[],this.jQueryBefore=[],this.jQueryElement&&this.jQueryElement instanceof jQuery&&this.jQueryElement.removeAttr("style"),this.jQuerycontainer&&this.jQueryContainer instanceof jQuery&&(this.jQuerycontainer=$("<div>")),i instanceof Function?i.apply(this,[e]):e()};let r=n.end;return n.end=async function(){this.jQueryElement instanceof jQuery&&this.jQueryElement.remove();for(let e in this.jQueryBefore)this.jQueryBefore[e]._element&&this.jQueryBefore[e]._element.jQueryElement instanceof jQuery&&this.jQueryBefore[e]._element.jQueryElement.remove();for(let e in this.jQueryAfter)this.jQueryAfter[e]._element&&this.jQueryAfter[e]._element.jQueryElement instanceof jQuery&&this.jQueryAfter[e]._element.jQueryElement.remove();this.jQueryContainer instanceof jQuery&&this.jQueryContainer.remove(),r instanceof Function&&await r.apply(this)},n.name=e,n}(t),r.b.Elements["new"+e]=function(...t){let n=m[e],i=s.a.controllers.underConstruction;s.a.controllers.running&&(i=s.a.controllers.list[s.a.controllers.running.id]);let r="unnamed-"+e;t.length<1?t=[r]:"string"==typeof t[0]&&t[0].length>0&&(r=t[0]);let o=new c(r,e,n);l.call(o,t),n.hasOwnProperty("immediate")&&n.immediate instanceof Function&&n.immediate.apply(o,t);let a=o.id;for(let t=2;i.elements.hasOwnProperty(e)&&i.elements[e].hasOwnProperty(o.id);t++)o.id=a+String(t);a!=o.id&&(s.a.debug.warning("Found an existing "+o.type+" element named &ldquo;"+a+"&rdquo;--using name &ldquo;"+o.id+"&rdquo; instead for new element"),i.ambiguousElementNames.push(a)),i._addElement(o);let u=new f(o,n);if(u=u._proxy,u._promises.push(()=>new Promise(e=>{o.printTime=0,o.log=!1,e()})),u._promises.push(()=>new Promise(e=>n.uponCreation.apply(o,[e]))),i.defaultCommands.hasOwnProperty(e))for(let t in i.defaultCommands[e]){let n=i.defaultCommands[e][t];u._promises.push(()=>new Promise(e=>{"header"==n[2]&&0==s.a.controllers.running.options.runHeader?e():n[0].apply(o,[e,...n[1]])}))}return u},r.b.Elements["get"+e]=function(t){let n=s.a.controllers.underConstruction;s.a.controllers.running&&(n=s.a.controllers.list[s.a.controllers.running.id]);let i=m[e];return n.ambiguousElementNames.indexOf(t)>=0&&s.a.debug.error("Ambiguous use of get"+e+"(&ldquo;"+t+"&rdquo;):                                    more than one elements were created with that name--                                    get"+e+"(&ldquo;"+t+"&rdquo;) will refer to the first one"),new f(t,i)._proxy},Object.defineProperty(r.b.Elements,"default"+e,{get:function(){let t=m[e],n={},i=function(){s.a.controllers.underConstruction.hasOwnProperty("defaultCommands")||(s.a.controllers.underConstruction.defaultCommands={}),s.a.controllers.underConstruction.defaultCommands.hasOwnProperty(e)||(s.a.controllers.underConstruction.defaultCommands[e]=[])};for(let r in t.actions)n[r]=function(...o){return i(),s.a.controllers.underConstruction.defaultCommands[e].push([t.actions[r],o]),n};n.settings={};for(let r in t.settings)n.settings[r]=function(...o){return i(),s.a.controllers.underConstruction.defaultCommands[e].push([t.settings[r],o]),n};return n}})},r.b._AddStandardCommands=function(e){let t=new e(s.a);for(let e in t)if(e.match(/^(actions|settings|test)$/))for(let n in t[e]){let i=t[e][n];if(p[e].hasOwnProperty(n))s.a.debug.error("There already is a standard "+e+" command named "+n);else if(i instanceof Function){p[e][n]=i;for(let t in m)m[t][e].hasOwnProperty(n)||(m[t][e][n]=i),"settings"!=e||m[t].actions.hasOwnProperty(n)||(m[t].actions[n]=i)}else s.a.debug.error("Standard "+e+" command "+n+" should be a function")}else s.a.debug.error("Standard command type unknown",e)}},function(e,t,n){"use strict";var i=n(4),r=n(1),s=n(2),o=n(0),a=n(5),l=n(9);let u=[];o.a.utils.JSZip=l,o.a.utils.JSZip.getBinaryContent=i.getBinaryContent,o.a.utils.saveAs=a.saveAs,s.b.PreloadZip=function(){for(let e in arguments)u.push(arguments[e])},o.a.Prerun((function(){if(u.length){var e=function(e){function t(){let t=u.indexOf(e);t>=0&&u.splice(t,1)}var n=new l;Object(i.getBinaryContent)(e,(function(i,s){if(i)throw t(),o.a.debug.error("Error downloading "+e+":",i),i;n.loadAsync(s).then((function(){o.a.debug.log("Download of "+e+" complete");var i=0;n.forEach((function(e,s){s.async("arraybuffer").then((function(s){if(!e.match(/__MACOS.+\/\.[^\/]+$/)){let t=e.replace(/^.*?([^\/]+)$/,"$1"),n=Object(r.a)(Object(r.c)(s.slice(0,28)),t);if(n){let e=URL.createObjectURL(new Blob([s],{type:n}));console.log("Found a resource named",t,"of type",n,"with url",e);var a=!1;for(let n in o.a.resources.list){let i=o.a.resources.list[n];i.name==t&&"ready"!=i.status&&(console.log("Applying create to a copye of",t),i.create.apply($.extend({},i,{value:e,object:null,resolve:function(){console.log("Resolving",t,"current status",i.status),"ready"!=i.status&&(i.object=this.object,console.log("Set",t," object to",i.object,"calling resolve now"),i.resolve())}})),a=!0)}a||o.a.resources.list.push({name:t,value:e,controllers:[],object:null,status:"void",create:function(){this.status="pending"},resolve:function(){this.status="ready"}})}}++i>=Object.keys(n.files).length&&t()}))}))}))}))};for(let t in u){let n=u[t],i=n.match(/^https?:\/\/.+\.(zip)$/i);"string"==typeof n&&i?"zip"==i[1].toLowerCase()&&e(n):o.a.debug.warning("Preload: entry #"+t+" is not a valid URL, ignoring it")}}}))},function(e,t,n){(function(t,n,i){e.exports=function e(t,n,i){function r(o,a){if(!n[o]){if(!t[o]){if(s)return s(o,!0);var l=new Error("Cannot find module '"+o+"'");throw l.code="MODULE_NOT_FOUND",l}var u=n[o]={exports:{}};t[o][0].call(u.exports,(function(e){return r(t[o][1][e]||e)}),u,u.exports,e,t,n,i)}return n[o].exports}for(var s=!1,o=0;o<i.length;o++)r(i[o]);return r}({1:[function(e,r,s){(function(t){!function(e){"object"==typeof s&&void 0!==r?r.exports=e():("undefined"!=typeof window?window:void 0!==t?t:"undefined"!=typeof self?self:this).JSZip=e()}((function(){return function t(n,i,r){function s(a,l){if(!i[a]){if(!n[a]){var u="function"==typeof e&&e;if(!l&&u)return u(a,!0);if(o)return o(a,!0);var h=new Error("Cannot find module '"+a+"'");throw h.code="MODULE_NOT_FOUND",h}var c=i[a]={exports:{}};n[a][0].call(c.exports,(function(e){return s(n[a][1][e]||e)}),c,c.exports,t,n,i,r)}return i[a].exports}for(var o="function"==typeof e&&e,a=0;a<r.length;a++)s(r[a]);return s}({1:[function(e,r,s){(function(t){!function(e){"object"==typeof s&&void 0!==r?r.exports=e():("undefined"!=typeof window?window:void 0!==t?t:"undefined"!=typeof self?self:this).JSZip=e()}((function(){return function t(n,i,r){function s(a,l){if(!i[a]){if(!n[a]){var u="function"==typeof e&&e;if(!l&&u)return u(a,!0);if(o)return o(a,!0);var h=new Error("Cannot find module '"+a+"'");throw h.code="MODULE_NOT_FOUND",h}var c=i[a]={exports:{}};n[a][0].call(c.exports,(function(e){return s(n[a][1][e]||e)}),c,c.exports,t,n,i,r)}return i[a].exports}for(var o="function"==typeof e&&e,a=0;a<r.length;a++)s(r[a]);return s}({1:[function(e,r,s){(function(t){!function(e){"object"==typeof s&&void 0!==r?r.exports=e():("undefined"!=typeof window?window:void 0!==t?t:"undefined"!=typeof self?self:this).JSZip=e()}((function(){return function t(n,i,r){function s(a,l){if(!i[a]){if(!n[a]){var u="function"==typeof e&&e;if(!l&&u)return u(a,!0);if(o)return o(a,!0);var h=new Error("Cannot find module '"+a+"'");throw h.code="MODULE_NOT_FOUND",h}var c=i[a]={exports:{}};n[a][0].call(c.exports,(function(e){return s(n[a][1][e]||e)}),c,c.exports,t,n,i,r)}return i[a].exports}for(var o="function"==typeof e&&e,a=0;a<r.length;a++)s(r[a]);return s}({1:[function(e,r,s){(function(t){!function(e){"object"==typeof s&&void 0!==r?r.exports=e():("undefined"!=typeof window?window:void 0!==t?t:"undefined"!=typeof self?self:this).JSZip=e()}((function(){return function t(n,i,r){function s(a,l){if(!i[a]){if(!n[a]){var u="function"==typeof e&&e;if(!l&&u)return u(a,!0);if(o)return o(a,!0);var h=new Error("Cannot find module '"+a+"'");throw h.code="MODULE_NOT_FOUND",h}var c=i[a]={exports:{}};n[a][0].call(c.exports,(function(e){return s(n[a][1][e]||e)}),c,c.exports,t,n,i,r)}return i[a].exports}for(var o="function"==typeof e&&e,a=0;a<r.length;a++)s(r[a]);return s}({1:[function(e,r,s){(function(t){!function(e){"object"==typeof s&&void 0!==r?r.exports=e():("undefined"!=typeof window?window:void 0!==t?t:"undefined"!=typeof self?self:this).JSZip=e()}((function(){return function t(n,i,r){function s(a,l){if(!i[a]){if(!n[a]){var u="function"==typeof e&&e;if(!l&&u)return u(a,!0);if(o)return o(a,!0);var h=new Error("Cannot find module '"+a+"'");throw h.code="MODULE_NOT_FOUND",h}var c=i[a]={exports:{}};n[a][0].call(c.exports,(function(e){return s(n[a][1][e]||e)}),c,c.exports,t,n,i,r)}return i[a].exports}for(var o="function"==typeof e&&e,a=0;a<r.length;a++)s(r[a]);return s}({1:[function(e,t,n){"use strict";var i=e("./utils"),r=e("./support"),s="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";n.encode=function(e){for(var t,n,r,o,a,l,u,h=[],c=0,d=e.length,f=d,p="string"!==i.getTypeOf(e);c<e.length;)f=d-c,r=p?(t=e[c++],n=c<d?e[c++]:0,c<d?e[c++]:0):(t=e.charCodeAt(c++),n=c<d?e.charCodeAt(c++):0,c<d?e.charCodeAt(c++):0),o=t>>2,a=(3&t)<<4|n>>4,l=1<f?(15&n)<<2|r>>6:64,u=2<f?63&r:64,h.push(s.charAt(o)+s.charAt(a)+s.charAt(l)+s.charAt(u));return h.join("")},n.decode=function(e){var t,n,i,o,a,l,u=0,h=0;if("data:"===e.substr(0,"data:".length))throw new Error("Invalid base64 input, it looks like a data url.");var c,d=3*(e=e.replace(/[^A-Za-z0-9\+\/\=]/g,"")).length/4;if(e.charAt(e.length-1)===s.charAt(64)&&d--,e.charAt(e.length-2)===s.charAt(64)&&d--,d%1!=0)throw new Error("Invalid base64 input, bad content length.");for(c=r.uint8array?new Uint8Array(0|d):new Array(0|d);u<e.length;)t=s.indexOf(e.charAt(u++))<<2|(o=s.indexOf(e.charAt(u++)))>>4,n=(15&o)<<4|(a=s.indexOf(e.charAt(u++)))>>2,i=(3&a)<<6|(l=s.indexOf(e.charAt(u++))),c[h++]=t,64!==a&&(c[h++]=n),64!==l&&(c[h++]=i);return c}},{"./support":30,"./utils":32}],2:[function(e,t,n){"use strict";var i=e("./external"),r=e("./stream/DataWorker"),s=e("./stream/Crc32Probe"),o=e("./stream/DataLengthProbe");function a(e,t,n,i,r){this.compressedSize=e,this.uncompressedSize=t,this.crc32=n,this.compression=i,this.compressedContent=r}a.prototype={getContentWorker:function(){var e=new r(i.Promise.resolve(this.compressedContent)).pipe(this.compression.uncompressWorker()).pipe(new o("data_length")),t=this;return e.on("end",(function(){if(this.streamInfo.data_length!==t.uncompressedSize)throw new Error("Bug : uncompressed data size mismatch")})),e},getCompressedWorker:function(){return new r(i.Promise.resolve(this.compressedContent)).withStreamInfo("compressedSize",this.compressedSize).withStreamInfo("uncompressedSize",this.uncompressedSize).withStreamInfo("crc32",this.crc32).withStreamInfo("compression",this.compression)}},a.createWorkerFrom=function(e,t,n){return e.pipe(new s).pipe(new o("uncompressedSize")).pipe(t.compressWorker(n)).pipe(new o("compressedSize")).withStreamInfo("compression",t)},t.exports=a},{"./external":6,"./stream/Crc32Probe":25,"./stream/DataLengthProbe":26,"./stream/DataWorker":27}],3:[function(e,t,n){"use strict";var i=e("./stream/GenericWorker");n.STORE={magic:"\0\0",compressWorker:function(e){return new i("STORE compression")},uncompressWorker:function(){return new i("STORE decompression")}},n.DEFLATE=e("./flate")},{"./flate":7,"./stream/GenericWorker":28}],4:[function(e,t,n){"use strict";var i=e("./utils"),r=function(){for(var e,t=[],n=0;n<256;n++){e=n;for(var i=0;i<8;i++)e=1&e?3988292384^e>>>1:e>>>1;t[n]=e}return t}();t.exports=function(e,t){return void 0!==e&&e.length?"string"!==i.getTypeOf(e)?function(e,t,n){var i=r,s=0+n;e^=-1;for(var o=0;o<s;o++)e=e>>>8^i[255&(e^t[o])];return-1^e}(0|t,e,e.length):function(e,t,n){var i=r,s=0+n;e^=-1;for(var o=0;o<s;o++)e=e>>>8^i[255&(e^t.charCodeAt(o))];return-1^e}(0|t,e,e.length):0}},{"./utils":32}],5:[function(e,t,n){"use strict";n.base64=!1,n.binary=!1,n.dir=!1,n.createFolders=!0,n.date=null,n.compression=null,n.compressionOptions=null,n.comment=null,n.unixPermissions=null,n.dosPermissions=null},{}],6:[function(e,t,n){"use strict";var i;i="undefined"!=typeof Promise?Promise:e("lie"),t.exports={Promise:i}},{lie:37}],7:[function(e,t,n){"use strict";var i="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Uint32Array,r=e("pako"),s=e("./utils"),o=e("./stream/GenericWorker"),a=i?"uint8array":"array";function l(e,t){o.call(this,"FlateWorker/"+e),this._pako=null,this._pakoAction=e,this._pakoOptions=t,this.meta={}}n.magic="\b\0",s.inherits(l,o),l.prototype.processChunk=function(e){this.meta=e.meta,null===this._pako&&this._createPako(),this._pako.push(s.transformTo(a,e.data),!1)},l.prototype.flush=function(){o.prototype.flush.call(this),null===this._pako&&this._createPako(),this._pako.push([],!0)},l.prototype.cleanUp=function(){o.prototype.cleanUp.call(this),this._pako=null},l.prototype._createPako=function(){this._pako=new r[this._pakoAction]({raw:!0,level:this._pakoOptions.level||-1});var e=this;this._pako.onData=function(t){e.push({data:t,meta:e.meta})}},n.compressWorker=function(e){return new l("Deflate",e)},n.uncompressWorker=function(){return new l("Inflate",{})}},{"./stream/GenericWorker":28,"./utils":32,pako:38}],8:[function(e,t,n){"use strict";function i(e,t){var n,i="";for(n=0;n<t;n++)i+=String.fromCharCode(255&e),e>>>=8;return i}function r(e,t,n,r,o,h){var c,d,f=e.file,p=e.compression,m=h!==a.utf8encode,g=s.transformTo("string",h(f.name)),y=s.transformTo("string",a.utf8encode(f.name)),b=f.comment,w=s.transformTo("string",h(b)),v=s.transformTo("string",a.utf8encode(b)),_=y.length!==f.name.length,E=v.length!==b.length,k="",C="",A="",P=f.dir,x=f.date,j={crc32:0,compressedSize:0,uncompressedSize:0};t&&!n||(j.crc32=e.crc32,j.compressedSize=e.compressedSize,j.uncompressedSize=e.uncompressedSize);var T=0;t&&(T|=8),m||!_&&!E||(T|=2048);var S,O=0,Q=0;P&&(O|=16),"UNIX"===o?(Q=798,O|=((S=f.unixPermissions)||(S=P?16893:33204),(65535&S)<<16)):(Q=20,O|=63&(f.dosPermissions||0)),c=x.getUTCHours(),c<<=6,c|=x.getUTCMinutes(),c<<=5,c|=x.getUTCSeconds()/2,d=x.getUTCFullYear()-1980,d<<=4,d|=x.getUTCMonth()+1,d<<=5,d|=x.getUTCDate(),_&&(k+="up"+i((C=i(1,1)+i(l(g),4)+y).length,2)+C),E&&(k+="uc"+i((A=i(1,1)+i(l(w),4)+v).length,2)+A);var N="";return N+="\n\0",N+=i(T,2),N+=p.magic,N+=i(c,2),N+=i(d,2),N+=i(j.crc32,4),N+=i(j.compressedSize,4),N+=i(j.uncompressedSize,4),N+=i(g.length,2),N+=i(k.length,2),{fileRecord:u.LOCAL_FILE_HEADER+N+g+k,dirRecord:u.CENTRAL_FILE_HEADER+i(Q,2)+N+i(w.length,2)+"\0\0\0\0"+i(O,4)+i(r,4)+g+k+w}}var s=e("../utils"),o=e("../stream/GenericWorker"),a=e("../utf8"),l=e("../crc32"),u=e("../signature");function h(e,t,n,i){o.call(this,"ZipFileWorker"),this.bytesWritten=0,this.zipComment=t,this.zipPlatform=n,this.encodeFileName=i,this.streamFiles=e,this.accumulate=!1,this.contentBuffer=[],this.dirRecords=[],this.currentSourceOffset=0,this.entriesCount=0,this.currentFile=null,this._sources=[]}s.inherits(h,o),h.prototype.push=function(e){var t=e.meta.percent||0,n=this.entriesCount,i=this._sources.length;this.accumulate?this.contentBuffer.push(e):(this.bytesWritten+=e.data.length,o.prototype.push.call(this,{data:e.data,meta:{currentFile:this.currentFile,percent:n?(t+100*(n-i-1))/n:100}}))},h.prototype.openedSource=function(e){this.currentSourceOffset=this.bytesWritten,this.currentFile=e.file.name;var t=this.streamFiles&&!e.file.dir;if(t){var n=r(e,t,!1,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);this.push({data:n.fileRecord,meta:{percent:0}})}else this.accumulate=!0},h.prototype.closedSource=function(e){this.accumulate=!1;var t,n=this.streamFiles&&!e.file.dir,s=r(e,n,!0,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);if(this.dirRecords.push(s.dirRecord),n)this.push({data:(t=e,u.DATA_DESCRIPTOR+i(t.crc32,4)+i(t.compressedSize,4)+i(t.uncompressedSize,4)),meta:{percent:100}});else for(this.push({data:s.fileRecord,meta:{percent:0}});this.contentBuffer.length;)this.push(this.contentBuffer.shift());this.currentFile=null},h.prototype.flush=function(){for(var e=this.bytesWritten,t=0;t<this.dirRecords.length;t++)this.push({data:this.dirRecords[t],meta:{percent:100}});var n,r,o,a,l,h,c=this.bytesWritten-e,d=(n=this.dirRecords.length,r=c,o=e,a=this.zipComment,l=this.encodeFileName,h=s.transformTo("string",l(a)),u.CENTRAL_DIRECTORY_END+"\0\0\0\0"+i(n,2)+i(n,2)+i(r,4)+i(o,4)+i(h.length,2)+h);this.push({data:d,meta:{percent:100}})},h.prototype.prepareNextSource=function(){this.previous=this._sources.shift(),this.openedSource(this.previous.streamInfo),this.isPaused?this.previous.pause():this.previous.resume()},h.prototype.registerPrevious=function(e){this._sources.push(e);var t=this;return e.on("data",(function(e){t.processChunk(e)})),e.on("end",(function(){t.closedSource(t.previous.streamInfo),t._sources.length?t.prepareNextSource():t.end()})),e.on("error",(function(e){t.error(e)})),this},h.prototype.resume=function(){return!!o.prototype.resume.call(this)&&(!this.previous&&this._sources.length?(this.prepareNextSource(),!0):this.previous||this._sources.length||this.generatedError?void 0:(this.end(),!0))},h.prototype.error=function(e){var t=this._sources;if(!o.prototype.error.call(this,e))return!1;for(var n=0;n<t.length;n++)try{t[n].error(e)}catch(e){}return!0},h.prototype.lock=function(){o.prototype.lock.call(this);for(var e=this._sources,t=0;t<e.length;t++)e[t].lock()},t.exports=h},{"../crc32":4,"../signature":23,"../stream/GenericWorker":28,"../utf8":31,"../utils":32}],9:[function(e,t,n){"use strict";var i=e("../compressions"),r=e("./ZipFileWorker");n.generateWorker=function(e,t,n){var s=new r(t.streamFiles,n,t.platform,t.encodeFileName),o=0;try{e.forEach((function(e,n){o++;var r=function(e,t){var n=e||t,r=i[n];if(!r)throw new Error(n+" is not a valid compression method !");return r}(n.options.compression,t.compression),a=n.options.compressionOptions||t.compressionOptions||{},l=n.dir,u=n.date;n._compressWorker(r,a).withStreamInfo("file",{name:e,dir:l,date:u,comment:n.comment||"",unixPermissions:n.unixPermissions,dosPermissions:n.dosPermissions}).pipe(s)})),s.entriesCount=o}catch(e){s.error(e)}return s}},{"../compressions":3,"./ZipFileWorker":8}],10:[function(e,t,n){"use strict";function i(){if(!(this instanceof i))return new i;if(arguments.length)throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");this.files={},this.comment=null,this.root="",this.clone=function(){var e=new i;for(var t in this)"function"!=typeof this[t]&&(e[t]=this[t]);return e}}(i.prototype=e("./object")).loadAsync=e("./load"),i.support=e("./support"),i.defaults=e("./defaults"),i.version="3.5.0",i.loadAsync=function(e,t){return(new i).loadAsync(e,t)},i.external=e("./external"),t.exports=i},{"./defaults":5,"./external":6,"./load":11,"./object":15,"./support":30}],11:[function(e,t,n){"use strict";var i=e("./utils"),r=e("./external"),s=e("./utf8"),o=e("./zipEntries"),a=e("./stream/Crc32Probe"),l=e("./nodejsUtils");function u(e){return new r.Promise((function(t,n){var i=e.decompressed.getContentWorker().pipe(new a);i.on("error",(function(e){n(e)})).on("end",(function(){i.streamInfo.crc32!==e.decompressed.crc32?n(new Error("Corrupted zip : CRC32 mismatch")):t()})).resume()}))}t.exports=function(e,t){var n=this;return t=i.extend(t||{},{base64:!1,checkCRC32:!1,optimizedBinaryString:!1,createFolders:!1,decodeFileName:s.utf8decode}),l.isNode&&l.isStream(e)?r.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file.")):i.prepareContent("the loaded zip file",e,!0,t.optimizedBinaryString,t.base64).then((function(e){var n=new o(t);return n.load(e),n})).then((function(e){var n=[r.Promise.resolve(e)],i=e.files;if(t.checkCRC32)for(var s=0;s<i.length;s++)n.push(u(i[s]));return r.Promise.all(n)})).then((function(e){for(var i=e.shift(),r=i.files,s=0;s<r.length;s++){var o=r[s];n.file(o.fileNameStr,o.decompressed,{binary:!0,optimizedBinaryString:!0,date:o.date,dir:o.dir,comment:o.fileCommentStr.length?o.fileCommentStr:null,unixPermissions:o.unixPermissions,dosPermissions:o.dosPermissions,createFolders:t.createFolders})}return i.zipComment.length&&(n.comment=i.zipComment),n}))}},{"./external":6,"./nodejsUtils":14,"./stream/Crc32Probe":25,"./utf8":31,"./utils":32,"./zipEntries":33}],12:[function(e,t,n){"use strict";var i=e("../utils"),r=e("../stream/GenericWorker");function s(e,t){r.call(this,"Nodejs stream input adapter for "+e),this._upstreamEnded=!1,this._bindStream(t)}i.inherits(s,r),s.prototype._bindStream=function(e){var t=this;(this._stream=e).pause(),e.on("data",(function(e){t.push({data:e,meta:{percent:0}})})).on("error",(function(e){t.isPaused?this.generatedError=e:t.error(e)})).on("end",(function(){t.isPaused?t._upstreamEnded=!0:t.end()}))},s.prototype.pause=function(){return!!r.prototype.pause.call(this)&&(this._stream.pause(),!0)},s.prototype.resume=function(){return!!r.prototype.resume.call(this)&&(this._upstreamEnded?this.end():this._stream.resume(),!0)},t.exports=s},{"../stream/GenericWorker":28,"../utils":32}],13:[function(e,t,n){"use strict";var i=e("readable-stream").Readable;function r(e,t,n){i.call(this,t),this._helper=e;var r=this;e.on("data",(function(e,t){r.push(e)||r._helper.pause(),n&&n(t)})).on("error",(function(e){r.emit("error",e)})).on("end",(function(){r.push(null)}))}e("../utils").inherits(r,i),r.prototype._read=function(){this._helper.resume()},t.exports=r},{"../utils":32,"readable-stream":16}],14:[function(e,t,i){"use strict";t.exports={isNode:void 0!==n,newBufferFrom:function(e,t){if(n.from&&n.from!==Uint8Array.from)return n.from(e,t);if("number"==typeof e)throw new Error('The "data" argument must not be a number');return new n(e,t)},allocBuffer:function(e){if(n.alloc)return n.alloc(e);var t=new n(e);return t.fill(0),t},isBuffer:function(e){return n.isBuffer(e)},isStream:function(e){return e&&"function"==typeof e.on&&"function"==typeof e.pause&&"function"==typeof e.resume}}},{}],15:[function(e,t,n){"use strict";function i(e,t,n){var i,s=o.getTypeOf(t),l=o.extend(n||{},u);l.date=l.date||new Date,null!==l.compression&&(l.compression=l.compression.toUpperCase()),"string"==typeof l.unixPermissions&&(l.unixPermissions=parseInt(l.unixPermissions,8)),l.unixPermissions&&16384&l.unixPermissions&&(l.dir=!0),l.dosPermissions&&16&l.dosPermissions&&(l.dir=!0),l.dir&&(e=r(e)),l.createFolders&&(i=function(e){"/"===e.slice(-1)&&(e=e.substring(0,e.length-1));var t=e.lastIndexOf("/");return 0<t?e.substring(0,t):""}(e))&&m.call(this,i,!0);var d,g="string"===s&&!1===l.binary&&!1===l.base64;n&&void 0!==n.binary||(l.binary=!g),(t instanceof h&&0===t.uncompressedSize||l.dir||!t||0===t.length)&&(l.base64=!1,l.binary=!0,t="",l.compression="STORE",s="string"),d=t instanceof h||t instanceof a?t:f.isNode&&f.isStream(t)?new p(e,t):o.prepareContent(e,t,l.binary,l.optimizedBinaryString,l.base64);var y=new c(e,d,l);this.files[e]=y}function r(e){return"/"!==e.slice(-1)&&(e+="/"),e}var s=e("./utf8"),o=e("./utils"),a=e("./stream/GenericWorker"),l=e("./stream/StreamHelper"),u=e("./defaults"),h=e("./compressedObject"),c=e("./zipObject"),d=e("./generate"),f=e("./nodejsUtils"),p=e("./nodejs/NodejsStreamInputAdapter"),m=function(e,t){return t=void 0!==t?t:u.createFolders,e=r(e),this.files[e]||i.call(this,e,null,{dir:!0,createFolders:t}),this.files[e]};function g(e){return"[object RegExp]"===Object.prototype.toString.call(e)}var y={load:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},forEach:function(e){var t,n,i;for(t in this.files)this.files.hasOwnProperty(t)&&(i=this.files[t],(n=t.slice(this.root.length,t.length))&&t.slice(0,this.root.length)===this.root&&e(n,i))},filter:function(e){var t=[];return this.forEach((function(n,i){e(n,i)&&t.push(i)})),t},file:function(e,t,n){if(1!==arguments.length)return e=this.root+e,i.call(this,e,t,n),this;if(g(e)){var r=e;return this.filter((function(e,t){return!t.dir&&r.test(e)}))}var s=this.files[this.root+e];return s&&!s.dir?s:null},folder:function(e){if(!e)return this;if(g(e))return this.filter((function(t,n){return n.dir&&e.test(t)}));var t=this.root+e,n=m.call(this,t),i=this.clone();return i.root=n.name,i},remove:function(e){e=this.root+e;var t=this.files[e];if(t||("/"!==e.slice(-1)&&(e+="/"),t=this.files[e]),t&&!t.dir)delete this.files[e];else for(var n=this.filter((function(t,n){return n.name.slice(0,e.length)===e})),i=0;i<n.length;i++)delete this.files[n[i].name];return this},generate:function(e){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},generateInternalStream:function(e){var t,n={};try{if((n=o.extend(e||{},{streamFiles:!1,compression:"STORE",compressionOptions:null,type:"",platform:"DOS",comment:null,mimeType:"application/zip",encodeFileName:s.utf8encode})).type=n.type.toLowerCase(),n.compression=n.compression.toUpperCase(),"binarystring"===n.type&&(n.type="string"),!n.type)throw new Error("No output type specified.");o.checkSupport(n.type),"darwin"!==n.platform&&"freebsd"!==n.platform&&"linux"!==n.platform&&"sunos"!==n.platform||(n.platform="UNIX"),"win32"===n.platform&&(n.platform="DOS");var i=n.comment||this.comment||"";t=d.generateWorker(this,n,i)}catch(e){(t=new a("error")).error(e)}return new l(t,n.type||"string",n.mimeType)},generateAsync:function(e,t){return this.generateInternalStream(e).accumulate(t)},generateNodeStream:function(e,t){return(e=e||{}).type||(e.type="nodebuffer"),this.generateInternalStream(e).toNodejsStream(t)}};t.exports=y},{"./compressedObject":2,"./defaults":5,"./generate":9,"./nodejs/NodejsStreamInputAdapter":12,"./nodejsUtils":14,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31,"./utils":32,"./zipObject":35}],16:[function(e,t,n){t.exports=e("stream")},{stream:void 0}],17:[function(e,t,n){"use strict";var i=e("./DataReader");function r(e){i.call(this,e);for(var t=0;t<this.data.length;t++)e[t]=255&e[t]}e("../utils").inherits(r,i),r.prototype.byteAt=function(e){return this.data[this.zero+e]},r.prototype.lastIndexOfSignature=function(e){for(var t=e.charCodeAt(0),n=e.charCodeAt(1),i=e.charCodeAt(2),r=e.charCodeAt(3),s=this.length-4;0<=s;--s)if(this.data[s]===t&&this.data[s+1]===n&&this.data[s+2]===i&&this.data[s+3]===r)return s-this.zero;return-1},r.prototype.readAndCheckSignature=function(e){var t=e.charCodeAt(0),n=e.charCodeAt(1),i=e.charCodeAt(2),r=e.charCodeAt(3),s=this.readData(4);return t===s[0]&&n===s[1]&&i===s[2]&&r===s[3]},r.prototype.readData=function(e){if(this.checkOffset(e),0===e)return[];var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=r},{"../utils":32,"./DataReader":18}],18:[function(e,t,n){"use strict";var i=e("../utils");function r(e){this.data=e,this.length=e.length,this.index=0,this.zero=0}r.prototype={checkOffset:function(e){this.checkIndex(this.index+e)},checkIndex:function(e){if(this.length<this.zero+e||e<0)throw new Error("End of data reached (data length = "+this.length+", asked index = "+e+"). Corrupted zip ?")},setIndex:function(e){this.checkIndex(e),this.index=e},skip:function(e){this.setIndex(this.index+e)},byteAt:function(e){},readInt:function(e){var t,n=0;for(this.checkOffset(e),t=this.index+e-1;t>=this.index;t--)n=(n<<8)+this.byteAt(t);return this.index+=e,n},readString:function(e){return i.transformTo("string",this.readData(e))},readData:function(e){},lastIndexOfSignature:function(e){},readAndCheckSignature:function(e){},readDate:function(){var e=this.readInt(4);return new Date(Date.UTC(1980+(e>>25&127),(e>>21&15)-1,e>>16&31,e>>11&31,e>>5&63,(31&e)<<1))}},t.exports=r},{"../utils":32}],19:[function(e,t,n){"use strict";var i=e("./Uint8ArrayReader");function r(e){i.call(this,e)}e("../utils").inherits(r,i),r.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=r},{"../utils":32,"./Uint8ArrayReader":21}],20:[function(e,t,n){"use strict";var i=e("./DataReader");function r(e){i.call(this,e)}e("../utils").inherits(r,i),r.prototype.byteAt=function(e){return this.data.charCodeAt(this.zero+e)},r.prototype.lastIndexOfSignature=function(e){return this.data.lastIndexOf(e)-this.zero},r.prototype.readAndCheckSignature=function(e){return e===this.readData(4)},r.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=r},{"../utils":32,"./DataReader":18}],21:[function(e,t,n){"use strict";var i=e("./ArrayReader");function r(e){i.call(this,e)}e("../utils").inherits(r,i),r.prototype.readData=function(e){if(this.checkOffset(e),0===e)return new Uint8Array(0);var t=this.data.subarray(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=r},{"../utils":32,"./ArrayReader":17}],22:[function(e,t,n){"use strict";var i=e("../utils"),r=e("../support"),s=e("./ArrayReader"),o=e("./StringReader"),a=e("./NodeBufferReader"),l=e("./Uint8ArrayReader");t.exports=function(e){var t=i.getTypeOf(e);return i.checkSupport(t),"string"!==t||r.uint8array?"nodebuffer"===t?new a(e):r.uint8array?new l(i.transformTo("uint8array",e)):new s(i.transformTo("array",e)):new o(e)}},{"../support":30,"../utils":32,"./ArrayReader":17,"./NodeBufferReader":19,"./StringReader":20,"./Uint8ArrayReader":21}],23:[function(e,t,n){"use strict";n.LOCAL_FILE_HEADER="PK",n.CENTRAL_FILE_HEADER="PK",n.CENTRAL_DIRECTORY_END="PK",n.ZIP64_CENTRAL_DIRECTORY_LOCATOR="PK",n.ZIP64_CENTRAL_DIRECTORY_END="PK",n.DATA_DESCRIPTOR="PK\b"},{}],24:[function(e,t,n){"use strict";var i=e("./GenericWorker"),r=e("../utils");function s(e){i.call(this,"ConvertWorker to "+e),this.destType=e}r.inherits(s,i),s.prototype.processChunk=function(e){this.push({data:r.transformTo(this.destType,e.data),meta:e.meta})},t.exports=s},{"../utils":32,"./GenericWorker":28}],25:[function(e,t,n){"use strict";var i=e("./GenericWorker"),r=e("../crc32");function s(){i.call(this,"Crc32Probe"),this.withStreamInfo("crc32",0)}e("../utils").inherits(s,i),s.prototype.processChunk=function(e){this.streamInfo.crc32=r(e.data,this.streamInfo.crc32||0),this.push(e)},t.exports=s},{"../crc32":4,"../utils":32,"./GenericWorker":28}],26:[function(e,t,n){"use strict";var i=e("../utils"),r=e("./GenericWorker");function s(e){r.call(this,"DataLengthProbe for "+e),this.propName=e,this.withStreamInfo(e,0)}i.inherits(s,r),s.prototype.processChunk=function(e){if(e){var t=this.streamInfo[this.propName]||0;this.streamInfo[this.propName]=t+e.data.length}r.prototype.processChunk.call(this,e)},t.exports=s},{"../utils":32,"./GenericWorker":28}],27:[function(e,t,n){"use strict";var i=e("../utils"),r=e("./GenericWorker");function s(e){r.call(this,"DataWorker");var t=this;this.dataIsReady=!1,this.index=0,this.max=0,this.data=null,this.type="",this._tickScheduled=!1,e.then((function(e){t.dataIsReady=!0,t.data=e,t.max=e&&e.length||0,t.type=i.getTypeOf(e),t.isPaused||t._tickAndRepeat()}),(function(e){t.error(e)}))}i.inherits(s,r),s.prototype.cleanUp=function(){r.prototype.cleanUp.call(this),this.data=null},s.prototype.resume=function(){return!!r.prototype.resume.call(this)&&(!this._tickScheduled&&this.dataIsReady&&(this._tickScheduled=!0,i.delay(this._tickAndRepeat,[],this)),!0)},s.prototype._tickAndRepeat=function(){this._tickScheduled=!1,this.isPaused||this.isFinished||(this._tick(),this.isFinished||(i.delay(this._tickAndRepeat,[],this),this._tickScheduled=!0))},s.prototype._tick=function(){if(this.isPaused||this.isFinished)return!1;var e=null,t=Math.min(this.max,this.index+16384);if(this.index>=this.max)return this.end();switch(this.type){case"string":e=this.data.substring(this.index,t);break;case"uint8array":e=this.data.subarray(this.index,t);break;case"array":case"nodebuffer":e=this.data.slice(this.index,t)}return this.index=t,this.push({data:e,meta:{percent:this.max?this.index/this.max*100:0}})},t.exports=s},{"../utils":32,"./GenericWorker":28}],28:[function(e,t,n){"use strict";function i(e){this.name=e||"default",this.streamInfo={},this.generatedError=null,this.extraStreamInfo={},this.isPaused=!0,this.isFinished=!1,this.isLocked=!1,this._listeners={data:[],end:[],error:[]},this.previous=null}i.prototype={push:function(e){this.emit("data",e)},end:function(){if(this.isFinished)return!1;this.flush();try{this.emit("end"),this.cleanUp(),this.isFinished=!0}catch(e){this.emit("error",e)}return!0},error:function(e){return!this.isFinished&&(this.isPaused?this.generatedError=e:(this.isFinished=!0,this.emit("error",e),this.previous&&this.previous.error(e),this.cleanUp()),!0)},on:function(e,t){return this._listeners[e].push(t),this},cleanUp:function(){this.streamInfo=this.generatedError=this.extraStreamInfo=null,this._listeners=[]},emit:function(e,t){if(this._listeners[e])for(var n=0;n<this._listeners[e].length;n++)this._listeners[e][n].call(this,t)},pipe:function(e){return e.registerPrevious(this)},registerPrevious:function(e){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.streamInfo=e.streamInfo,this.mergeStreamInfo(),this.previous=e;var t=this;return e.on("data",(function(e){t.processChunk(e)})),e.on("end",(function(){t.end()})),e.on("error",(function(e){t.error(e)})),this},pause:function(){return!this.isPaused&&!this.isFinished&&(this.isPaused=!0,this.previous&&this.previous.pause(),!0)},resume:function(){if(!this.isPaused||this.isFinished)return!1;var e=this.isPaused=!1;return this.generatedError&&(this.error(this.generatedError),e=!0),this.previous&&this.previous.resume(),!e},flush:function(){},processChunk:function(e){this.push(e)},withStreamInfo:function(e,t){return this.extraStreamInfo[e]=t,this.mergeStreamInfo(),this},mergeStreamInfo:function(){for(var e in this.extraStreamInfo)this.extraStreamInfo.hasOwnProperty(e)&&(this.streamInfo[e]=this.extraStreamInfo[e])},lock:function(){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.isLocked=!0,this.previous&&this.previous.lock()},toString:function(){var e="Worker "+this.name;return this.previous?this.previous+" -> "+e:e}},t.exports=i},{}],29:[function(e,t,i){"use strict";var r=e("../utils"),s=e("./ConvertWorker"),o=e("./GenericWorker"),a=e("../base64"),l=e("../support"),u=e("../external"),h=null;if(l.nodestream)try{h=e("../nodejs/NodejsStreamOutputAdapter")}catch(e){}function c(e,t,n){var i=t;switch(t){case"blob":case"arraybuffer":i="uint8array";break;case"base64":i="string"}try{this._internalType=i,this._outputType=t,this._mimeType=n,r.checkSupport(i),this._worker=e.pipe(new s(i)),e.lock()}catch(e){this._worker=new o("error"),this._worker.error(e)}}c.prototype={accumulate:function(e){return t=this,i=e,new u.Promise((function(e,s){var o=[],l=t._internalType,u=t._outputType,h=t._mimeType;t.on("data",(function(e,t){o.push(e),i&&i(t)})).on("error",(function(e){o=[],s(e)})).on("end",(function(){try{var t=function(e,t,n){switch(e){case"blob":return r.newBlob(r.transformTo("arraybuffer",t),n);case"base64":return a.encode(t);default:return r.transformTo(e,t)}}(u,function(e,t){var i,r=0,s=null,o=0;for(i=0;i<t.length;i++)o+=t[i].length;switch(e){case"string":return t.join("");case"array":return Array.prototype.concat.apply([],t);case"uint8array":for(s=new Uint8Array(o),i=0;i<t.length;i++)s.set(t[i],r),r+=t[i].length;return s;case"nodebuffer":return n.concat(t);default:throw new Error("concat : unsupported type '"+e+"'")}}(l,o),h);e(t)}catch(t){s(t)}o=[]})).resume()}));var t,i},on:function(e,t){var n=this;return"data"===e?this._worker.on(e,(function(e){t.call(n,e.data,e.meta)})):this._worker.on(e,(function(){r.delay(t,arguments,n)})),this},resume:function(){return r.delay(this._worker.resume,[],this._worker),this},pause:function(){return this._worker.pause(),this},toNodejsStream:function(e){if(r.checkSupport("nodestream"),"nodebuffer"!==this._outputType)throw new Error(this._outputType+" is not supported by this method");return new h(this,{objectMode:"nodebuffer"!==this._outputType},e)}},t.exports=c},{"../base64":1,"../external":6,"../nodejs/NodejsStreamOutputAdapter":13,"../support":30,"../utils":32,"./ConvertWorker":24,"./GenericWorker":28}],30:[function(e,t,i){"use strict";if(i.base64=!0,i.array=!0,i.string=!0,i.arraybuffer="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array,i.nodebuffer=void 0!==n,i.uint8array="undefined"!=typeof Uint8Array,"undefined"==typeof ArrayBuffer)i.blob=!1;else{var r=new ArrayBuffer(0);try{i.blob=0===new Blob([r],{type:"application/zip"}).size}catch(e){try{var s=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);s.append(r),i.blob=0===s.getBlob("application/zip").size}catch(e){i.blob=!1}}}try{i.nodestream=!!e("readable-stream").Readable}catch(e){i.nodestream=!1}},{"readable-stream":16}],31:[function(e,t,n){"use strict";for(var i=e("./utils"),r=e("./support"),s=e("./nodejsUtils"),o=e("./stream/GenericWorker"),a=new Array(256),l=0;l<256;l++)a[l]=252<=l?6:248<=l?5:240<=l?4:224<=l?3:192<=l?2:1;function u(){o.call(this,"utf-8 decode"),this.leftOver=null}function h(){o.call(this,"utf-8 encode")}a[254]=a[254]=1,n.utf8encode=function(e){return r.nodebuffer?s.newBufferFrom(e,"utf-8"):function(e){var t,n,i,s,o,a=e.length,l=0;for(s=0;s<a;s++)55296==(64512&(n=e.charCodeAt(s)))&&s+1<a&&56320==(64512&(i=e.charCodeAt(s+1)))&&(n=65536+(n-55296<<10)+(i-56320),s++),l+=n<128?1:n<2048?2:n<65536?3:4;for(t=r.uint8array?new Uint8Array(l):new Array(l),s=o=0;o<l;s++)55296==(64512&(n=e.charCodeAt(s)))&&s+1<a&&56320==(64512&(i=e.charCodeAt(s+1)))&&(n=65536+(n-55296<<10)+(i-56320),s++),n<128?t[o++]=n:(n<2048?t[o++]=192|n>>>6:(n<65536?t[o++]=224|n>>>12:(t[o++]=240|n>>>18,t[o++]=128|n>>>12&63),t[o++]=128|n>>>6&63),t[o++]=128|63&n);return t}(e)},n.utf8decode=function(e){return r.nodebuffer?i.transformTo("nodebuffer",e).toString("utf-8"):function(e){var t,n,r,s,o=e.length,l=new Array(2*o);for(t=n=0;t<o;)if((r=e[t++])<128)l[n++]=r;else if(4<(s=a[r]))l[n++]=65533,t+=s-1;else{for(r&=2===s?31:3===s?15:7;1<s&&t<o;)r=r<<6|63&e[t++],s--;1<s?l[n++]=65533:r<65536?l[n++]=r:(r-=65536,l[n++]=55296|r>>10&1023,l[n++]=56320|1023&r)}return l.length!==n&&(l.subarray?l=l.subarray(0,n):l.length=n),i.applyFromCharCode(l)}(e=i.transformTo(r.uint8array?"uint8array":"array",e))},i.inherits(u,o),u.prototype.processChunk=function(e){var t=i.transformTo(r.uint8array?"uint8array":"array",e.data);if(this.leftOver&&this.leftOver.length){if(r.uint8array){var s=t;(t=new Uint8Array(s.length+this.leftOver.length)).set(this.leftOver,0),t.set(s,this.leftOver.length)}else t=this.leftOver.concat(t);this.leftOver=null}var o=function(e,t){var n;for((t=t||e.length)>e.length&&(t=e.length),n=t-1;0<=n&&128==(192&e[n]);)n--;return n<0||0===n?t:n+a[e[n]]>t?n:t}(t),l=t;o!==t.length&&(r.uint8array?(l=t.subarray(0,o),this.leftOver=t.subarray(o,t.length)):(l=t.slice(0,o),this.leftOver=t.slice(o,t.length))),this.push({data:n.utf8decode(l),meta:e.meta})},u.prototype.flush=function(){this.leftOver&&this.leftOver.length&&(this.push({data:n.utf8decode(this.leftOver),meta:{}}),this.leftOver=null)},n.Utf8DecodeWorker=u,i.inherits(h,o),h.prototype.processChunk=function(e){this.push({data:n.utf8encode(e.data),meta:e.meta})},n.Utf8EncodeWorker=h},{"./nodejsUtils":14,"./stream/GenericWorker":28,"./support":30,"./utils":32}],32:[function(e,t,n){"use strict";var i=e("./support"),r=e("./base64"),s=e("./nodejsUtils"),o=e("set-immediate-shim"),a=e("./external");function l(e){return e}function u(e,t){for(var n=0;n<e.length;++n)t[n]=255&e.charCodeAt(n);return t}n.newBlob=function(e,t){n.checkSupport("blob");try{return new Blob([e],{type:t})}catch(n){try{var i=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);return i.append(e),i.getBlob(t)}catch(e){throw new Error("Bug : can't construct the Blob.")}}};var h={stringifyByChunk:function(e,t,n){var i=[],r=0,s=e.length;if(s<=n)return String.fromCharCode.apply(null,e);for(;r<s;)"array"===t||"nodebuffer"===t?i.push(String.fromCharCode.apply(null,e.slice(r,Math.min(r+n,s)))):i.push(String.fromCharCode.apply(null,e.subarray(r,Math.min(r+n,s)))),r+=n;return i.join("")},stringifyByChar:function(e){for(var t="",n=0;n<e.length;n++)t+=String.fromCharCode(e[n]);return t},applyCanBeUsed:{uint8array:function(){try{return i.uint8array&&1===String.fromCharCode.apply(null,new Uint8Array(1)).length}catch(e){return!1}}(),nodebuffer:function(){try{return i.nodebuffer&&1===String.fromCharCode.apply(null,s.allocBuffer(1)).length}catch(e){return!1}}()}};function c(e){var t=65536,i=n.getTypeOf(e),r=!0;if("uint8array"===i?r=h.applyCanBeUsed.uint8array:"nodebuffer"===i&&(r=h.applyCanBeUsed.nodebuffer),r)for(;1<t;)try{return h.stringifyByChunk(e,i,t)}catch(e){t=Math.floor(t/2)}return h.stringifyByChar(e)}function d(e,t){for(var n=0;n<e.length;n++)t[n]=e[n];return t}n.applyFromCharCode=c;var f={};f.string={string:l,array:function(e){return u(e,new Array(e.length))},arraybuffer:function(e){return f.string.uint8array(e).buffer},uint8array:function(e){return u(e,new Uint8Array(e.length))},nodebuffer:function(e){return u(e,s.allocBuffer(e.length))}},f.array={string:c,array:l,arraybuffer:function(e){return new Uint8Array(e).buffer},uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return s.newBufferFrom(e)}},f.arraybuffer={string:function(e){return c(new Uint8Array(e))},array:function(e){return d(new Uint8Array(e),new Array(e.byteLength))},arraybuffer:l,uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return s.newBufferFrom(new Uint8Array(e))}},f.uint8array={string:c,array:function(e){return d(e,new Array(e.length))},arraybuffer:function(e){return e.buffer},uint8array:l,nodebuffer:function(e){return s.newBufferFrom(e)}},f.nodebuffer={string:c,array:function(e){return d(e,new Array(e.length))},arraybuffer:function(e){return f.nodebuffer.uint8array(e).buffer},uint8array:function(e){return d(e,new Uint8Array(e.length))},nodebuffer:l},n.transformTo=function(e,t){if(t=t||"",!e)return t;n.checkSupport(e);var i=n.getTypeOf(t);return f[i][e](t)},n.getTypeOf=function(e){return"string"==typeof e?"string":"[object Array]"===Object.prototype.toString.call(e)?"array":i.nodebuffer&&s.isBuffer(e)?"nodebuffer":i.uint8array&&e instanceof Uint8Array?"uint8array":i.arraybuffer&&e instanceof ArrayBuffer?"arraybuffer":void 0},n.checkSupport=function(e){if(!i[e.toLowerCase()])throw new Error(e+" is not supported by this platform")},n.MAX_VALUE_16BITS=65535,n.MAX_VALUE_32BITS=-1,n.pretty=function(e){var t,n,i="";for(n=0;n<(e||"").length;n++)i+="\\x"+((t=e.charCodeAt(n))<16?"0":"")+t.toString(16).toUpperCase();return i},n.delay=function(e,t,n){o((function(){e.apply(n||null,t||[])}))},n.inherits=function(e,t){function n(){}n.prototype=t.prototype,e.prototype=new n},n.extend=function(){var e,t,n={};for(e=0;e<arguments.length;e++)for(t in arguments[e])arguments[e].hasOwnProperty(t)&&void 0===n[t]&&(n[t]=arguments[e][t]);return n},n.prepareContent=function(e,t,s,o,l){return a.Promise.resolve(t).then((function(e){return i.blob&&(e instanceof Blob||-1!==["[object File]","[object Blob]"].indexOf(Object.prototype.toString.call(e)))&&"undefined"!=typeof FileReader?new a.Promise((function(t,n){var i=new FileReader;i.onload=function(e){t(e.target.result)},i.onerror=function(e){n(e.target.error)},i.readAsArrayBuffer(e)})):e})).then((function(t){var h,c=n.getTypeOf(t);return c?("arraybuffer"===c?t=n.transformTo("uint8array",t):"string"===c&&(l?t=r.decode(t):s&&!0!==o&&(t=u(h=t,i.uint8array?new Uint8Array(h.length):new Array(h.length)))),t):a.Promise.reject(new Error("Can't read the data of '"+e+"'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"))}))}},{"./base64":1,"./external":6,"./nodejsUtils":14,"./support":30,"set-immediate-shim":54}],33:[function(e,t,n){"use strict";var i=e("./reader/readerFor"),r=e("./utils"),s=e("./signature"),o=e("./zipEntry"),a=(e("./utf8"),e("./support"));function l(e){this.files=[],this.loadOptions=e}l.prototype={checkSignature:function(e){if(!this.reader.readAndCheckSignature(e)){this.reader.index-=4;var t=this.reader.readString(4);throw new Error("Corrupted zip or bug: unexpected signature ("+r.pretty(t)+", expected "+r.pretty(e)+")")}},isSignature:function(e,t){var n=this.reader.index;this.reader.setIndex(e);var i=this.reader.readString(4)===t;return this.reader.setIndex(n),i},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2),this.diskWithCentralDirStart=this.reader.readInt(2),this.centralDirRecordsOnThisDisk=this.reader.readInt(2),this.centralDirRecords=this.reader.readInt(2),this.centralDirSize=this.reader.readInt(4),this.centralDirOffset=this.reader.readInt(4),this.zipCommentLength=this.reader.readInt(2);var e=this.reader.readData(this.zipCommentLength),t=a.uint8array?"uint8array":"array",n=r.transformTo(t,e);this.zipComment=this.loadOptions.decodeFileName(n)},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8),this.reader.skip(4),this.diskNumber=this.reader.readInt(4),this.diskWithCentralDirStart=this.reader.readInt(4),this.centralDirRecordsOnThisDisk=this.reader.readInt(8),this.centralDirRecords=this.reader.readInt(8),this.centralDirSize=this.reader.readInt(8),this.centralDirOffset=this.reader.readInt(8),this.zip64ExtensibleData={};for(var e,t,n,i=this.zip64EndOfCentralSize-44;0<i;)e=this.reader.readInt(2),t=this.reader.readInt(4),n=this.reader.readData(t),this.zip64ExtensibleData[e]={id:e,length:t,value:n}},readBlockZip64EndOfCentralLocator:function(){if(this.diskWithZip64CentralDirStart=this.reader.readInt(4),this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8),this.disksCount=this.reader.readInt(4),1<this.disksCount)throw new Error("Multi-volumes zip are not supported")},readLocalFiles:function(){var e,t;for(e=0;e<this.files.length;e++)t=this.files[e],this.reader.setIndex(t.localHeaderOffset),this.checkSignature(s.LOCAL_FILE_HEADER),t.readLocalPart(this.reader),t.handleUTF8(),t.processAttributes()},readCentralDir:function(){var e;for(this.reader.setIndex(this.centralDirOffset);this.reader.readAndCheckSignature(s.CENTRAL_FILE_HEADER);)(e=new o({zip64:this.zip64},this.loadOptions)).readCentralPart(this.reader),this.files.push(e);if(this.centralDirRecords!==this.files.length&&0!==this.centralDirRecords&&0===this.files.length)throw new Error("Corrupted zip or bug: expected "+this.centralDirRecords+" records in central dir, got "+this.files.length)},readEndOfCentral:function(){var e=this.reader.lastIndexOfSignature(s.CENTRAL_DIRECTORY_END);if(e<0)throw this.isSignature(0,s.LOCAL_FILE_HEADER)?new Error("Corrupted zip: can't find end of central directory"):new Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html");this.reader.setIndex(e);var t=e;if(this.checkSignature(s.CENTRAL_DIRECTORY_END),this.readBlockEndOfCentral(),this.diskNumber===r.MAX_VALUE_16BITS||this.diskWithCentralDirStart===r.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===r.MAX_VALUE_16BITS||this.centralDirRecords===r.MAX_VALUE_16BITS||this.centralDirSize===r.MAX_VALUE_32BITS||this.centralDirOffset===r.MAX_VALUE_32BITS){if(this.zip64=!0,(e=this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR))<0)throw new Error("Corrupted zip: can't find the ZIP64 end of central directory locator");if(this.reader.setIndex(e),this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR),this.readBlockZip64EndOfCentralLocator(),!this.isSignature(this.relativeOffsetEndOfZip64CentralDir,s.ZIP64_CENTRAL_DIRECTORY_END)&&(this.relativeOffsetEndOfZip64CentralDir=this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_END),this.relativeOffsetEndOfZip64CentralDir<0))throw new Error("Corrupted zip: can't find the ZIP64 end of central directory");this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir),this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_END),this.readBlockZip64EndOfCentral()}var n=this.centralDirOffset+this.centralDirSize;this.zip64&&(n+=20,n+=12+this.zip64EndOfCentralSize);var i=t-n;if(0<i)this.isSignature(t,s.CENTRAL_FILE_HEADER)||(this.reader.zero=i);else if(i<0)throw new Error("Corrupted zip: missing "+Math.abs(i)+" bytes.")},prepareReader:function(e){this.reader=i(e)},load:function(e){this.prepareReader(e),this.readEndOfCentral(),this.readCentralDir(),this.readLocalFiles()}},t.exports=l},{"./reader/readerFor":22,"./signature":23,"./support":30,"./utf8":31,"./utils":32,"./zipEntry":34}],34:[function(e,t,n){"use strict";var i=e("./reader/readerFor"),r=e("./utils"),s=e("./compressedObject"),o=e("./crc32"),a=e("./utf8"),l=e("./compressions"),u=e("./support");function h(e,t){this.options=e,this.loadOptions=t}h.prototype={isEncrypted:function(){return 1==(1&this.bitFlag)},useUTF8:function(){return 2048==(2048&this.bitFlag)},readLocalPart:function(e){var t,n;if(e.skip(22),this.fileNameLength=e.readInt(2),n=e.readInt(2),this.fileName=e.readData(this.fileNameLength),e.skip(n),-1===this.compressedSize||-1===this.uncompressedSize)throw new Error("Bug or corrupted zip : didn't get enough information from the central directory (compressedSize === -1 || uncompressedSize === -1)");if(null===(t=function(e){for(var t in l)if(l.hasOwnProperty(t)&&l[t].magic===e)return l[t];return null}(this.compressionMethod)))throw new Error("Corrupted zip : compression "+r.pretty(this.compressionMethod)+" unknown (inner file : "+r.transformTo("string",this.fileName)+")");this.decompressed=new s(this.compressedSize,this.uncompressedSize,this.crc32,t,e.readData(this.compressedSize))},readCentralPart:function(e){this.versionMadeBy=e.readInt(2),e.skip(2),this.bitFlag=e.readInt(2),this.compressionMethod=e.readString(2),this.date=e.readDate(),this.crc32=e.readInt(4),this.compressedSize=e.readInt(4),this.uncompressedSize=e.readInt(4);var t=e.readInt(2);if(this.extraFieldsLength=e.readInt(2),this.fileCommentLength=e.readInt(2),this.diskNumberStart=e.readInt(2),this.internalFileAttributes=e.readInt(2),this.externalFileAttributes=e.readInt(4),this.localHeaderOffset=e.readInt(4),this.isEncrypted())throw new Error("Encrypted zip are not supported");e.skip(t),this.readExtraFields(e),this.parseZIP64ExtraField(e),this.fileComment=e.readData(this.fileCommentLength)},processAttributes:function(){this.unixPermissions=null,this.dosPermissions=null;var e=this.versionMadeBy>>8;this.dir=!!(16&this.externalFileAttributes),0==e&&(this.dosPermissions=63&this.externalFileAttributes),3==e&&(this.unixPermissions=this.externalFileAttributes>>16&65535),this.dir||"/"!==this.fileNameStr.slice(-1)||(this.dir=!0)},parseZIP64ExtraField:function(e){if(this.extraFields[1]){var t=i(this.extraFields[1].value);this.uncompressedSize===r.MAX_VALUE_32BITS&&(this.uncompressedSize=t.readInt(8)),this.compressedSize===r.MAX_VALUE_32BITS&&(this.compressedSize=t.readInt(8)),this.localHeaderOffset===r.MAX_VALUE_32BITS&&(this.localHeaderOffset=t.readInt(8)),this.diskNumberStart===r.MAX_VALUE_32BITS&&(this.diskNumberStart=t.readInt(4))}},readExtraFields:function(e){var t,n,i,r=e.index+this.extraFieldsLength;for(this.extraFields||(this.extraFields={});e.index+4<r;)t=e.readInt(2),n=e.readInt(2),i=e.readData(n),this.extraFields[t]={id:t,length:n,value:i};e.setIndex(r)},handleUTF8:function(){var e=u.uint8array?"uint8array":"array";if(this.useUTF8())this.fileNameStr=a.utf8decode(this.fileName),this.fileCommentStr=a.utf8decode(this.fileComment);else{var t=this.findExtraFieldUnicodePath();if(null!==t)this.fileNameStr=t;else{var n=r.transformTo(e,this.fileName);this.fileNameStr=this.loadOptions.decodeFileName(n)}var i=this.findExtraFieldUnicodeComment();if(null!==i)this.fileCommentStr=i;else{var s=r.transformTo(e,this.fileComment);this.fileCommentStr=this.loadOptions.decodeFileName(s)}}},findExtraFieldUnicodePath:function(){var e=this.extraFields[28789];if(e){var t=i(e.value);return 1!==t.readInt(1)||o(this.fileName)!==t.readInt(4)?null:a.utf8decode(t.readData(e.length-5))}return null},findExtraFieldUnicodeComment:function(){var e=this.extraFields[25461];if(e){var t=i(e.value);return 1!==t.readInt(1)||o(this.fileComment)!==t.readInt(4)?null:a.utf8decode(t.readData(e.length-5))}return null}},t.exports=h},{"./compressedObject":2,"./compressions":3,"./crc32":4,"./reader/readerFor":22,"./support":30,"./utf8":31,"./utils":32}],35:[function(e,t,n){"use strict";function i(e,t,n){this.name=e,this.dir=n.dir,this.date=n.date,this.comment=n.comment,this.unixPermissions=n.unixPermissions,this.dosPermissions=n.dosPermissions,this._data=t,this._dataBinary=n.binary,this.options={compression:n.compression,compressionOptions:n.compressionOptions}}var r=e("./stream/StreamHelper"),s=e("./stream/DataWorker"),o=e("./utf8"),a=e("./compressedObject"),l=e("./stream/GenericWorker");i.prototype={internalStream:function(e){var t=null,n="string";try{if(!e)throw new Error("No output type specified.");var i="string"===(n=e.toLowerCase())||"text"===n;"binarystring"!==n&&"text"!==n||(n="string"),t=this._decompressWorker();var s=!this._dataBinary;s&&!i&&(t=t.pipe(new o.Utf8EncodeWorker)),!s&&i&&(t=t.pipe(new o.Utf8DecodeWorker))}catch(e){(t=new l("error")).error(e)}return new r(t,n,"")},async:function(e,t){return this.internalStream(e).accumulate(t)},nodeStream:function(e,t){return this.internalStream(e||"nodebuffer").toNodejsStream(t)},_compressWorker:function(e,t){if(this._data instanceof a&&this._data.compression.magic===e.magic)return this._data.getCompressedWorker();var n=this._decompressWorker();return this._dataBinary||(n=n.pipe(new o.Utf8EncodeWorker)),a.createWorkerFrom(n,e,t)},_decompressWorker:function(){return this._data instanceof a?this._data.getContentWorker():this._data instanceof l?this._data:new s(this._data)}};for(var u=["asText","asBinary","asNodeBuffer","asUint8Array","asArrayBuffer"],h=function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},c=0;c<u.length;c++)i.prototype[u[c]]=h;t.exports=i},{"./compressedObject":2,"./stream/DataWorker":27,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31}],36:[function(e,n,i){(function(e){"use strict";var t,i,r=e.MutationObserver||e.WebKitMutationObserver;if(r){var s=0,o=new r(h),a=e.document.createTextNode("");o.observe(a,{characterData:!0}),t=function(){a.data=s=++s%2}}else if(e.setImmediate||void 0===e.MessageChannel)t="document"in e&&"onreadystatechange"in e.document.createElement("script")?function(){var t=e.document.createElement("script");t.onreadystatechange=function(){h(),t.onreadystatechange=null,t.parentNode.removeChild(t),t=null},e.document.documentElement.appendChild(t)}:function(){setTimeout(h,0)};else{var l=new e.MessageChannel;l.port1.onmessage=h,t=function(){l.port2.postMessage(0)}}var u=[];function h(){var e,t;i=!0;for(var n=u.length;n;){for(t=u,u=[],e=-1;++e<n;)t[e]();n=u.length}i=!1}n.exports=function(e){1!==u.push(e)||i||t()}}).call(this,void 0!==t?t:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}],37:[function(e,t,n){"use strict";var i=e("immediate");function r(){}var s={},o=["REJECTED"],a=["FULFILLED"],l=["PENDING"];function u(e){if("function"!=typeof e)throw new TypeError("resolver must be a function");this.state=l,this.queue=[],this.outcome=void 0,e!==r&&f(this,e)}function h(e,t,n){this.promise=e,"function"==typeof t&&(this.onFulfilled=t,this.callFulfilled=this.otherCallFulfilled),"function"==typeof n&&(this.onRejected=n,this.callRejected=this.otherCallRejected)}function c(e,t,n){i((function(){var i;try{i=t(n)}catch(i){return s.reject(e,i)}i===e?s.reject(e,new TypeError("Cannot resolve promise with itself")):s.resolve(e,i)}))}function d(e){var t=e&&e.then;if(e&&("object"==typeof e||"function"==typeof e)&&"function"==typeof t)return function(){t.apply(e,arguments)}}function f(e,t){var n=!1;function i(t){n||(n=!0,s.reject(e,t))}function r(t){n||(n=!0,s.resolve(e,t))}var o=p((function(){t(r,i)}));"error"===o.status&&i(o.value)}function p(e,t){var n={};try{n.value=e(t),n.status="success"}catch(e){n.status="error",n.value=e}return n}(t.exports=u).prototype.finally=function(e){if("function"!=typeof e)return this;var t=this.constructor;return this.then((function(n){return t.resolve(e()).then((function(){return n}))}),(function(n){return t.resolve(e()).then((function(){throw n}))}))},u.prototype.catch=function(e){return this.then(null,e)},u.prototype.then=function(e,t){if("function"!=typeof e&&this.state===a||"function"!=typeof t&&this.state===o)return this;var n=new this.constructor(r);return this.state!==l?c(n,this.state===a?e:t,this.outcome):this.queue.push(new h(n,e,t)),n},h.prototype.callFulfilled=function(e){s.resolve(this.promise,e)},h.prototype.otherCallFulfilled=function(e){c(this.promise,this.onFulfilled,e)},h.prototype.callRejected=function(e){s.reject(this.promise,e)},h.prototype.otherCallRejected=function(e){c(this.promise,this.onRejected,e)},s.resolve=function(e,t){var n=p(d,t);if("error"===n.status)return s.reject(e,n.value);var i=n.value;if(i)f(e,i);else{e.state=a,e.outcome=t;for(var r=-1,o=e.queue.length;++r<o;)e.queue[r].callFulfilled(t)}return e},s.reject=function(e,t){e.state=o,e.outcome=t;for(var n=-1,i=e.queue.length;++n<i;)e.queue[n].callRejected(t);return e},u.resolve=function(e){return e instanceof this?e:s.resolve(new this(r),e)},u.reject=function(e){var t=new this(r);return s.reject(t,e)},u.all=function(e){var t=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var n=e.length,i=!1;if(!n)return this.resolve([]);for(var o=new Array(n),a=0,l=-1,u=new this(r);++l<n;)h(e[l],l);return u;function h(e,r){t.resolve(e).then((function(e){o[r]=e,++a!==n||i||(i=!0,s.resolve(u,o))}),(function(e){i||(i=!0,s.reject(u,e))}))}},u.race=function(e){if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var t=e.length,n=!1;if(!t)return this.resolve([]);for(var i,o=-1,a=new this(r);++o<t;)i=e[o],this.resolve(i).then((function(e){n||(n=!0,s.resolve(a,e))}),(function(e){n||(n=!0,s.reject(a,e))}));return a}},{immediate:36}],38:[function(e,t,n){"use strict";var i={};(0,e("./lib/utils/common").assign)(i,e("./lib/deflate"),e("./lib/inflate"),e("./lib/zlib/constants")),t.exports=i},{"./lib/deflate":39,"./lib/inflate":40,"./lib/utils/common":41,"./lib/zlib/constants":44}],39:[function(e,t,n){"use strict";var i=e("./zlib/deflate"),r=e("./utils/common"),s=e("./utils/strings"),o=e("./zlib/messages"),a=e("./zlib/zstream"),l=Object.prototype.toString;function u(e){if(!(this instanceof u))return new u(e);this.options=r.assign({level:-1,method:8,chunkSize:16384,windowBits:15,memLevel:8,strategy:0,to:""},e||{});var t=this.options;t.raw&&0<t.windowBits?t.windowBits=-t.windowBits:t.gzip&&0<t.windowBits&&t.windowBits<16&&(t.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new a,this.strm.avail_out=0;var n=i.deflateInit2(this.strm,t.level,t.method,t.windowBits,t.memLevel,t.strategy);if(0!==n)throw new Error(o[n]);if(t.header&&i.deflateSetHeader(this.strm,t.header),t.dictionary){var h;if(h="string"==typeof t.dictionary?s.string2buf(t.dictionary):"[object ArrayBuffer]"===l.call(t.dictionary)?new Uint8Array(t.dictionary):t.dictionary,0!==(n=i.deflateSetDictionary(this.strm,h)))throw new Error(o[n]);this._dict_set=!0}}function h(e,t){var n=new u(t);if(n.push(e,!0),n.err)throw n.msg||o[n.err];return n.result}u.prototype.push=function(e,t){var n,o,a=this.strm,u=this.options.chunkSize;if(this.ended)return!1;o=t===~~t?t:!0===t?4:0,"string"==typeof e?a.input=s.string2buf(e):"[object ArrayBuffer]"===l.call(e)?a.input=new Uint8Array(e):a.input=e,a.next_in=0,a.avail_in=a.input.length;do{if(0===a.avail_out&&(a.output=new r.Buf8(u),a.next_out=0,a.avail_out=u),1!==(n=i.deflate(a,o))&&0!==n)return this.onEnd(n),!(this.ended=!0);0!==a.avail_out&&(0!==a.avail_in||4!==o&&2!==o)||("string"===this.options.to?this.onData(s.buf2binstring(r.shrinkBuf(a.output,a.next_out))):this.onData(r.shrinkBuf(a.output,a.next_out)))}while((0<a.avail_in||0===a.avail_out)&&1!==n);return 4===o?(n=i.deflateEnd(this.strm),this.onEnd(n),this.ended=!0,0===n):2!==o||(this.onEnd(0),!(a.avail_out=0))},u.prototype.onData=function(e){this.chunks.push(e)},u.prototype.onEnd=function(e){0===e&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=r.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg},n.Deflate=u,n.deflate=h,n.deflateRaw=function(e,t){return(t=t||{}).raw=!0,h(e,t)},n.gzip=function(e,t){return(t=t||{}).gzip=!0,h(e,t)}},{"./utils/common":41,"./utils/strings":42,"./zlib/deflate":46,"./zlib/messages":51,"./zlib/zstream":53}],40:[function(e,t,n){"use strict";var i=e("./zlib/inflate"),r=e("./utils/common"),s=e("./utils/strings"),o=e("./zlib/constants"),a=e("./zlib/messages"),l=e("./zlib/zstream"),u=e("./zlib/gzheader"),h=Object.prototype.toString;function c(e){if(!(this instanceof c))return new c(e);this.options=r.assign({chunkSize:16384,windowBits:0,to:""},e||{});var t=this.options;t.raw&&0<=t.windowBits&&t.windowBits<16&&(t.windowBits=-t.windowBits,0===t.windowBits&&(t.windowBits=-15)),!(0<=t.windowBits&&t.windowBits<16)||e&&e.windowBits||(t.windowBits+=32),15<t.windowBits&&t.windowBits<48&&0==(15&t.windowBits)&&(t.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new l,this.strm.avail_out=0;var n=i.inflateInit2(this.strm,t.windowBits);if(n!==o.Z_OK)throw new Error(a[n]);this.header=new u,i.inflateGetHeader(this.strm,this.header)}function d(e,t){var n=new c(t);if(n.push(e,!0),n.err)throw n.msg||a[n.err];return n.result}c.prototype.push=function(e,t){var n,a,l,u,c,d,f=this.strm,p=this.options.chunkSize,m=this.options.dictionary,g=!1;if(this.ended)return!1;a=t===~~t?t:!0===t?o.Z_FINISH:o.Z_NO_FLUSH,"string"==typeof e?f.input=s.binstring2buf(e):"[object ArrayBuffer]"===h.call(e)?f.input=new Uint8Array(e):f.input=e,f.next_in=0,f.avail_in=f.input.length;do{if(0===f.avail_out&&(f.output=new r.Buf8(p),f.next_out=0,f.avail_out=p),(n=i.inflate(f,o.Z_NO_FLUSH))===o.Z_NEED_DICT&&m&&(d="string"==typeof m?s.string2buf(m):"[object ArrayBuffer]"===h.call(m)?new Uint8Array(m):m,n=i.inflateSetDictionary(this.strm,d)),n===o.Z_BUF_ERROR&&!0===g&&(n=o.Z_OK,g=!1),n!==o.Z_STREAM_END&&n!==o.Z_OK)return this.onEnd(n),!(this.ended=!0);f.next_out&&(0!==f.avail_out&&n!==o.Z_STREAM_END&&(0!==f.avail_in||a!==o.Z_FINISH&&a!==o.Z_SYNC_FLUSH)||("string"===this.options.to?(l=s.utf8border(f.output,f.next_out),u=f.next_out-l,c=s.buf2string(f.output,l),f.next_out=u,f.avail_out=p-u,u&&r.arraySet(f.output,f.output,l,u,0),this.onData(c)):this.onData(r.shrinkBuf(f.output,f.next_out)))),0===f.avail_in&&0===f.avail_out&&(g=!0)}while((0<f.avail_in||0===f.avail_out)&&n!==o.Z_STREAM_END);return n===o.Z_STREAM_END&&(a=o.Z_FINISH),a===o.Z_FINISH?(n=i.inflateEnd(this.strm),this.onEnd(n),this.ended=!0,n===o.Z_OK):a!==o.Z_SYNC_FLUSH||(this.onEnd(o.Z_OK),!(f.avail_out=0))},c.prototype.onData=function(e){this.chunks.push(e)},c.prototype.onEnd=function(e){e===o.Z_OK&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=r.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg},n.Inflate=c,n.inflate=d,n.inflateRaw=function(e,t){return(t=t||{}).raw=!0,d(e,t)},n.ungzip=d},{"./utils/common":41,"./utils/strings":42,"./zlib/constants":44,"./zlib/gzheader":47,"./zlib/inflate":49,"./zlib/messages":51,"./zlib/zstream":53}],41:[function(e,t,n){"use strict";var i="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Int32Array;n.assign=function(e){for(var t=Array.prototype.slice.call(arguments,1);t.length;){var n=t.shift();if(n){if("object"!=typeof n)throw new TypeError(n+"must be non-object");for(var i in n)n.hasOwnProperty(i)&&(e[i]=n[i])}}return e},n.shrinkBuf=function(e,t){return e.length===t?e:e.subarray?e.subarray(0,t):(e.length=t,e)};var r={arraySet:function(e,t,n,i,r){if(t.subarray&&e.subarray)e.set(t.subarray(n,n+i),r);else for(var s=0;s<i;s++)e[r+s]=t[n+s]},flattenChunks:function(e){var t,n,i,r,s,o;for(t=i=0,n=e.length;t<n;t++)i+=e[t].length;for(o=new Uint8Array(i),t=r=0,n=e.length;t<n;t++)s=e[t],o.set(s,r),r+=s.length;return o}},s={arraySet:function(e,t,n,i,r){for(var s=0;s<i;s++)e[r+s]=t[n+s]},flattenChunks:function(e){return[].concat.apply([],e)}};n.setTyped=function(e){e?(n.Buf8=Uint8Array,n.Buf16=Uint16Array,n.Buf32=Int32Array,n.assign(n,r)):(n.Buf8=Array,n.Buf16=Array,n.Buf32=Array,n.assign(n,s))},n.setTyped(i)},{}],42:[function(e,t,n){"use strict";var i=e("./common"),r=!0,s=!0;try{String.fromCharCode.apply(null,[0])}catch(e){r=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(e){s=!1}for(var o=new i.Buf8(256),a=0;a<256;a++)o[a]=252<=a?6:248<=a?5:240<=a?4:224<=a?3:192<=a?2:1;function l(e,t){if(t<65537&&(e.subarray&&s||!e.subarray&&r))return String.fromCharCode.apply(null,i.shrinkBuf(e,t));for(var n="",o=0;o<t;o++)n+=String.fromCharCode(e[o]);return n}o[254]=o[254]=1,n.string2buf=function(e){var t,n,r,s,o,a=e.length,l=0;for(s=0;s<a;s++)55296==(64512&(n=e.charCodeAt(s)))&&s+1<a&&56320==(64512&(r=e.charCodeAt(s+1)))&&(n=65536+(n-55296<<10)+(r-56320),s++),l+=n<128?1:n<2048?2:n<65536?3:4;for(t=new i.Buf8(l),s=o=0;o<l;s++)55296==(64512&(n=e.charCodeAt(s)))&&s+1<a&&56320==(64512&(r=e.charCodeAt(s+1)))&&(n=65536+(n-55296<<10)+(r-56320),s++),n<128?t[o++]=n:(n<2048?t[o++]=192|n>>>6:(n<65536?t[o++]=224|n>>>12:(t[o++]=240|n>>>18,t[o++]=128|n>>>12&63),t[o++]=128|n>>>6&63),t[o++]=128|63&n);return t},n.buf2binstring=function(e){return l(e,e.length)},n.binstring2buf=function(e){for(var t=new i.Buf8(e.length),n=0,r=t.length;n<r;n++)t[n]=e.charCodeAt(n);return t},n.buf2string=function(e,t){var n,i,r,s,a=t||e.length,u=new Array(2*a);for(n=i=0;n<a;)if((r=e[n++])<128)u[i++]=r;else if(4<(s=o[r]))u[i++]=65533,n+=s-1;else{for(r&=2===s?31:3===s?15:7;1<s&&n<a;)r=r<<6|63&e[n++],s--;1<s?u[i++]=65533:r<65536?u[i++]=r:(r-=65536,u[i++]=55296|r>>10&1023,u[i++]=56320|1023&r)}return l(u,i)},n.utf8border=function(e,t){var n;for((t=t||e.length)>e.length&&(t=e.length),n=t-1;0<=n&&128==(192&e[n]);)n--;return n<0||0===n?t:n+o[e[n]]>t?n:t}},{"./common":41}],43:[function(e,t,n){"use strict";t.exports=function(e,t,n,i){for(var r=65535&e|0,s=e>>>16&65535|0,o=0;0!==n;){for(n-=o=2e3<n?2e3:n;s=s+(r=r+t[i++]|0)|0,--o;);r%=65521,s%=65521}return r|s<<16|0}},{}],44:[function(e,t,n){"use strict";t.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8}},{}],45:[function(e,t,n){"use strict";var i=function(){for(var e,t=[],n=0;n<256;n++){e=n;for(var i=0;i<8;i++)e=1&e?3988292384^e>>>1:e>>>1;t[n]=e}return t}();t.exports=function(e,t,n,r){var s=i,o=r+n;e^=-1;for(var a=r;a<o;a++)e=e>>>8^s[255&(e^t[a])];return-1^e}},{}],46:[function(e,t,n){"use strict";var i,r=e("../utils/common"),s=e("./trees"),o=e("./adler32"),a=e("./crc32"),l=e("./messages"),u=-2,h=258,c=262,d=113;function f(e,t){return e.msg=l[t],t}function p(e){return(e<<1)-(4<e?9:0)}function m(e){for(var t=e.length;0<=--t;)e[t]=0}function g(e){var t=e.state,n=t.pending;n>e.avail_out&&(n=e.avail_out),0!==n&&(r.arraySet(e.output,t.pending_buf,t.pending_out,n,e.next_out),e.next_out+=n,t.pending_out+=n,e.total_out+=n,e.avail_out-=n,t.pending-=n,0===t.pending&&(t.pending_out=0))}function y(e,t){s._tr_flush_block(e,0<=e.block_start?e.block_start:-1,e.strstart-e.block_start,t),e.block_start=e.strstart,g(e.strm)}function b(e,t){e.pending_buf[e.pending++]=t}function w(e,t){e.pending_buf[e.pending++]=t>>>8&255,e.pending_buf[e.pending++]=255&t}function v(e,t){var n,i,r=e.max_chain_length,s=e.strstart,o=e.prev_length,a=e.nice_match,l=e.strstart>e.w_size-c?e.strstart-(e.w_size-c):0,u=e.window,d=e.w_mask,f=e.prev,p=e.strstart+h,m=u[s+o-1],g=u[s+o];e.prev_length>=e.good_match&&(r>>=2),a>e.lookahead&&(a=e.lookahead);do{if(u[(n=t)+o]===g&&u[n+o-1]===m&&u[n]===u[s]&&u[++n]===u[s+1]){s+=2,n++;do{}while(u[++s]===u[++n]&&u[++s]===u[++n]&&u[++s]===u[++n]&&u[++s]===u[++n]&&u[++s]===u[++n]&&u[++s]===u[++n]&&u[++s]===u[++n]&&u[++s]===u[++n]&&s<p);if(i=h-(p-s),s=p-h,o<i){if(e.match_start=t,a<=(o=i))break;m=u[s+o-1],g=u[s+o]}}}while((t=f[t&d])>l&&0!=--r);return o<=e.lookahead?o:e.lookahead}function _(e){var t,n,i,s,l,u,h,d,f,p,m=e.w_size;do{if(s=e.window_size-e.lookahead-e.strstart,e.strstart>=m+(m-c)){for(r.arraySet(e.window,e.window,m,m,0),e.match_start-=m,e.strstart-=m,e.block_start-=m,t=n=e.hash_size;i=e.head[--t],e.head[t]=m<=i?i-m:0,--n;);for(t=n=m;i=e.prev[--t],e.prev[t]=m<=i?i-m:0,--n;);s+=m}if(0===e.strm.avail_in)break;if(u=e.strm,h=e.window,d=e.strstart+e.lookahead,p=void 0,(f=s)<(p=u.avail_in)&&(p=f),n=0===p?0:(u.avail_in-=p,r.arraySet(h,u.input,u.next_in,p,d),1===u.state.wrap?u.adler=o(u.adler,h,p,d):2===u.state.wrap&&(u.adler=a(u.adler,h,p,d)),u.next_in+=p,u.total_in+=p,p),e.lookahead+=n,e.lookahead+e.insert>=3)for(l=e.strstart-e.insert,e.ins_h=e.window[l],e.ins_h=(e.ins_h<<e.hash_shift^e.window[l+1])&e.hash_mask;e.insert&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[l+3-1])&e.hash_mask,e.prev[l&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=l,l++,e.insert--,!(e.lookahead+e.insert<3)););}while(e.lookahead<c&&0!==e.strm.avail_in)}function E(e,t){for(var n,i;;){if(e.lookahead<c){if(_(e),e.lookahead<c&&0===t)return 1;if(0===e.lookahead)break}if(n=0,e.lookahead>=3&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+3-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),0!==n&&e.strstart-n<=e.w_size-c&&(e.match_length=v(e,n)),e.match_length>=3)if(i=s._tr_tally(e,e.strstart-e.match_start,e.match_length-3),e.lookahead-=e.match_length,e.match_length<=e.max_lazy_match&&e.lookahead>=3){for(e.match_length--;e.strstart++,e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+3-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart,0!=--e.match_length;);e.strstart++}else e.strstart+=e.match_length,e.match_length=0,e.ins_h=e.window[e.strstart],e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+1])&e.hash_mask;else i=s._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++;if(i&&(y(e,!1),0===e.strm.avail_out))return 1}return e.insert=e.strstart<2?e.strstart:2,4===t?(y(e,!0),0===e.strm.avail_out?3:4):e.last_lit&&(y(e,!1),0===e.strm.avail_out)?1:2}function k(e,t){for(var n,i,r;;){if(e.lookahead<c){if(_(e),e.lookahead<c&&0===t)return 1;if(0===e.lookahead)break}if(n=0,e.lookahead>=3&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+3-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),e.prev_length=e.match_length,e.prev_match=e.match_start,e.match_length=2,0!==n&&e.prev_length<e.max_lazy_match&&e.strstart-n<=e.w_size-c&&(e.match_length=v(e,n),e.match_length<=5&&(1===e.strategy||3===e.match_length&&4096<e.strstart-e.match_start)&&(e.match_length=2)),e.prev_length>=3&&e.match_length<=e.prev_length){for(r=e.strstart+e.lookahead-3,i=s._tr_tally(e,e.strstart-1-e.prev_match,e.prev_length-3),e.lookahead-=e.prev_length-1,e.prev_length-=2;++e.strstart<=r&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+3-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),0!=--e.prev_length;);if(e.match_available=0,e.match_length=2,e.strstart++,i&&(y(e,!1),0===e.strm.avail_out))return 1}else if(e.match_available){if((i=s._tr_tally(e,0,e.window[e.strstart-1]))&&y(e,!1),e.strstart++,e.lookahead--,0===e.strm.avail_out)return 1}else e.match_available=1,e.strstart++,e.lookahead--}return e.match_available&&(i=s._tr_tally(e,0,e.window[e.strstart-1]),e.match_available=0),e.insert=e.strstart<2?e.strstart:2,4===t?(y(e,!0),0===e.strm.avail_out?3:4):e.last_lit&&(y(e,!1),0===e.strm.avail_out)?1:2}function C(e,t,n,i,r){this.good_length=e,this.max_lazy=t,this.nice_length=n,this.max_chain=i,this.func=r}function A(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=8,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new r.Buf16(1146),this.dyn_dtree=new r.Buf16(122),this.bl_tree=new r.Buf16(78),m(this.dyn_ltree),m(this.dyn_dtree),m(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new r.Buf16(16),this.heap=new r.Buf16(573),m(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new r.Buf16(573),m(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0}function P(e){var t;return e&&e.state?(e.total_in=e.total_out=0,e.data_type=2,(t=e.state).pending=0,t.pending_out=0,t.wrap<0&&(t.wrap=-t.wrap),t.status=t.wrap?42:d,e.adler=2===t.wrap?0:1,t.last_flush=0,s._tr_init(t),0):f(e,u)}function x(e){var t,n=P(e);return 0===n&&((t=e.state).window_size=2*t.w_size,m(t.head),t.max_lazy_match=i[t.level].max_lazy,t.good_match=i[t.level].good_length,t.nice_match=i[t.level].nice_length,t.max_chain_length=i[t.level].max_chain,t.strstart=0,t.block_start=0,t.lookahead=0,t.insert=0,t.match_length=t.prev_length=2,t.match_available=0,t.ins_h=0),n}function j(e,t,n,i,s,o){if(!e)return u;var a=1;if(-1===t&&(t=6),i<0?(a=0,i=-i):15<i&&(a=2,i-=16),s<1||9<s||8!==n||i<8||15<i||t<0||9<t||o<0||4<o)return f(e,u);8===i&&(i=9);var l=new A;return(e.state=l).strm=e,l.wrap=a,l.gzhead=null,l.w_bits=i,l.w_size=1<<l.w_bits,l.w_mask=l.w_size-1,l.hash_bits=s+7,l.hash_size=1<<l.hash_bits,l.hash_mask=l.hash_size-1,l.hash_shift=~~((l.hash_bits+3-1)/3),l.window=new r.Buf8(2*l.w_size),l.head=new r.Buf16(l.hash_size),l.prev=new r.Buf16(l.w_size),l.lit_bufsize=1<<s+6,l.pending_buf_size=4*l.lit_bufsize,l.pending_buf=new r.Buf8(l.pending_buf_size),l.d_buf=1*l.lit_bufsize,l.l_buf=3*l.lit_bufsize,l.level=t,l.strategy=o,l.method=n,x(e)}i=[new C(0,0,0,0,(function(e,t){var n=65535;for(n>e.pending_buf_size-5&&(n=e.pending_buf_size-5);;){if(e.lookahead<=1){if(_(e),0===e.lookahead&&0===t)return 1;if(0===e.lookahead)break}e.strstart+=e.lookahead,e.lookahead=0;var i=e.block_start+n;if((0===e.strstart||e.strstart>=i)&&(e.lookahead=e.strstart-i,e.strstart=i,y(e,!1),0===e.strm.avail_out))return 1;if(e.strstart-e.block_start>=e.w_size-c&&(y(e,!1),0===e.strm.avail_out))return 1}return e.insert=0,4===t?(y(e,!0),0===e.strm.avail_out?3:4):(e.strstart>e.block_start&&(y(e,!1),e.strm.avail_out),1)})),new C(4,4,8,4,E),new C(4,5,16,8,E),new C(4,6,32,32,E),new C(4,4,16,16,k),new C(8,16,32,32,k),new C(8,16,128,128,k),new C(8,32,128,256,k),new C(32,128,258,1024,k),new C(32,258,258,4096,k)],n.deflateInit=function(e,t){return j(e,t,8,15,8,0)},n.deflateInit2=j,n.deflateReset=x,n.deflateResetKeep=P,n.deflateSetHeader=function(e,t){return e&&e.state?2!==e.state.wrap?u:(e.state.gzhead=t,0):u},n.deflate=function(e,t){var n,r,o,l;if(!e||!e.state||5<t||t<0)return e?f(e,u):u;if(r=e.state,!e.output||!e.input&&0!==e.avail_in||666===r.status&&4!==t)return f(e,0===e.avail_out?-5:u);if(r.strm=e,n=r.last_flush,r.last_flush=t,42===r.status)if(2===r.wrap)e.adler=0,b(r,31),b(r,139),b(r,8),r.gzhead?(b(r,(r.gzhead.text?1:0)+(r.gzhead.hcrc?2:0)+(r.gzhead.extra?4:0)+(r.gzhead.name?8:0)+(r.gzhead.comment?16:0)),b(r,255&r.gzhead.time),b(r,r.gzhead.time>>8&255),b(r,r.gzhead.time>>16&255),b(r,r.gzhead.time>>24&255),b(r,9===r.level?2:2<=r.strategy||r.level<2?4:0),b(r,255&r.gzhead.os),r.gzhead.extra&&r.gzhead.extra.length&&(b(r,255&r.gzhead.extra.length),b(r,r.gzhead.extra.length>>8&255)),r.gzhead.hcrc&&(e.adler=a(e.adler,r.pending_buf,r.pending,0)),r.gzindex=0,r.status=69):(b(r,0),b(r,0),b(r,0),b(r,0),b(r,0),b(r,9===r.level?2:2<=r.strategy||r.level<2?4:0),b(r,3),r.status=d);else{var c=8+(r.w_bits-8<<4)<<8;c|=(2<=r.strategy||r.level<2?0:r.level<6?1:6===r.level?2:3)<<6,0!==r.strstart&&(c|=32),c+=31-c%31,r.status=d,w(r,c),0!==r.strstart&&(w(r,e.adler>>>16),w(r,65535&e.adler)),e.adler=1}if(69===r.status)if(r.gzhead.extra){for(o=r.pending;r.gzindex<(65535&r.gzhead.extra.length)&&(r.pending!==r.pending_buf_size||(r.gzhead.hcrc&&r.pending>o&&(e.adler=a(e.adler,r.pending_buf,r.pending-o,o)),g(e),o=r.pending,r.pending!==r.pending_buf_size));)b(r,255&r.gzhead.extra[r.gzindex]),r.gzindex++;r.gzhead.hcrc&&r.pending>o&&(e.adler=a(e.adler,r.pending_buf,r.pending-o,o)),r.gzindex===r.gzhead.extra.length&&(r.gzindex=0,r.status=73)}else r.status=73;if(73===r.status)if(r.gzhead.name){o=r.pending;do{if(r.pending===r.pending_buf_size&&(r.gzhead.hcrc&&r.pending>o&&(e.adler=a(e.adler,r.pending_buf,r.pending-o,o)),g(e),o=r.pending,r.pending===r.pending_buf_size)){l=1;break}l=r.gzindex<r.gzhead.name.length?255&r.gzhead.name.charCodeAt(r.gzindex++):0,b(r,l)}while(0!==l);r.gzhead.hcrc&&r.pending>o&&(e.adler=a(e.adler,r.pending_buf,r.pending-o,o)),0===l&&(r.gzindex=0,r.status=91)}else r.status=91;if(91===r.status)if(r.gzhead.comment){o=r.pending;do{if(r.pending===r.pending_buf_size&&(r.gzhead.hcrc&&r.pending>o&&(e.adler=a(e.adler,r.pending_buf,r.pending-o,o)),g(e),o=r.pending,r.pending===r.pending_buf_size)){l=1;break}l=r.gzindex<r.gzhead.comment.length?255&r.gzhead.comment.charCodeAt(r.gzindex++):0,b(r,l)}while(0!==l);r.gzhead.hcrc&&r.pending>o&&(e.adler=a(e.adler,r.pending_buf,r.pending-o,o)),0===l&&(r.status=103)}else r.status=103;if(103===r.status&&(r.gzhead.hcrc?(r.pending+2>r.pending_buf_size&&g(e),r.pending+2<=r.pending_buf_size&&(b(r,255&e.adler),b(r,e.adler>>8&255),e.adler=0,r.status=d)):r.status=d),0!==r.pending){if(g(e),0===e.avail_out)return r.last_flush=-1,0}else if(0===e.avail_in&&p(t)<=p(n)&&4!==t)return f(e,-5);if(666===r.status&&0!==e.avail_in)return f(e,-5);if(0!==e.avail_in||0!==r.lookahead||0!==t&&666!==r.status){var v=2===r.strategy?function(e,t){for(var n;;){if(0===e.lookahead&&(_(e),0===e.lookahead)){if(0===t)return 1;break}if(e.match_length=0,n=s._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++,n&&(y(e,!1),0===e.strm.avail_out))return 1}return e.insert=0,4===t?(y(e,!0),0===e.strm.avail_out?3:4):e.last_lit&&(y(e,!1),0===e.strm.avail_out)?1:2}(r,t):3===r.strategy?function(e,t){for(var n,i,r,o,a=e.window;;){if(e.lookahead<=h){if(_(e),e.lookahead<=h&&0===t)return 1;if(0===e.lookahead)break}if(e.match_length=0,e.lookahead>=3&&0<e.strstart&&(i=a[r=e.strstart-1])===a[++r]&&i===a[++r]&&i===a[++r]){o=e.strstart+h;do{}while(i===a[++r]&&i===a[++r]&&i===a[++r]&&i===a[++r]&&i===a[++r]&&i===a[++r]&&i===a[++r]&&i===a[++r]&&r<o);e.match_length=h-(o-r),e.match_length>e.lookahead&&(e.match_length=e.lookahead)}if(e.match_length>=3?(n=s._tr_tally(e,1,e.match_length-3),e.lookahead-=e.match_length,e.strstart+=e.match_length,e.match_length=0):(n=s._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++),n&&(y(e,!1),0===e.strm.avail_out))return 1}return e.insert=0,4===t?(y(e,!0),0===e.strm.avail_out?3:4):e.last_lit&&(y(e,!1),0===e.strm.avail_out)?1:2}(r,t):i[r.level].func(r,t);if(3!==v&&4!==v||(r.status=666),1===v||3===v)return 0===e.avail_out&&(r.last_flush=-1),0;if(2===v&&(1===t?s._tr_align(r):5!==t&&(s._tr_stored_block(r,0,0,!1),3===t&&(m(r.head),0===r.lookahead&&(r.strstart=0,r.block_start=0,r.insert=0))),g(e),0===e.avail_out))return r.last_flush=-1,0}return 4!==t?0:r.wrap<=0?1:(2===r.wrap?(b(r,255&e.adler),b(r,e.adler>>8&255),b(r,e.adler>>16&255),b(r,e.adler>>24&255),b(r,255&e.total_in),b(r,e.total_in>>8&255),b(r,e.total_in>>16&255),b(r,e.total_in>>24&255)):(w(r,e.adler>>>16),w(r,65535&e.adler)),g(e),0<r.wrap&&(r.wrap=-r.wrap),0!==r.pending?0:1)},n.deflateEnd=function(e){var t;return e&&e.state?42!==(t=e.state.status)&&69!==t&&73!==t&&91!==t&&103!==t&&t!==d&&666!==t?f(e,u):(e.state=null,t===d?f(e,-3):0):u},n.deflateSetDictionary=function(e,t){var n,i,s,a,l,h,c,d,f=t.length;if(!e||!e.state)return u;if(2===(a=(n=e.state).wrap)||1===a&&42!==n.status||n.lookahead)return u;for(1===a&&(e.adler=o(e.adler,t,f,0)),n.wrap=0,f>=n.w_size&&(0===a&&(m(n.head),n.strstart=0,n.block_start=0,n.insert=0),d=new r.Buf8(n.w_size),r.arraySet(d,t,f-n.w_size,n.w_size,0),t=d,f=n.w_size),l=e.avail_in,h=e.next_in,c=e.input,e.avail_in=f,e.next_in=0,e.input=t,_(n);n.lookahead>=3;){for(i=n.strstart,s=n.lookahead-2;n.ins_h=(n.ins_h<<n.hash_shift^n.window[i+3-1])&n.hash_mask,n.prev[i&n.w_mask]=n.head[n.ins_h],n.head[n.ins_h]=i,i++,--s;);n.strstart=i,n.lookahead=2,_(n)}return n.strstart+=n.lookahead,n.block_start=n.strstart,n.insert=n.lookahead,n.lookahead=0,n.match_length=n.prev_length=2,n.match_available=0,e.next_in=h,e.input=c,e.avail_in=l,n.wrap=a,0},n.deflateInfo="pako deflate (from Nodeca project)"},{"../utils/common":41,"./adler32":43,"./crc32":45,"./messages":51,"./trees":52}],47:[function(e,t,n){"use strict";t.exports=function(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1}},{}],48:[function(e,t,n){"use strict";t.exports=function(e,t){var n,i,r,s,o,a,l,u,h,c,d,f,p,m,g,y,b,w,v,_,E,k,C,A,P;n=e.state,i=e.next_in,A=e.input,r=i+(e.avail_in-5),s=e.next_out,P=e.output,o=s-(t-e.avail_out),a=s+(e.avail_out-257),l=n.dmax,u=n.wsize,h=n.whave,c=n.wnext,d=n.window,f=n.hold,p=n.bits,m=n.lencode,g=n.distcode,y=(1<<n.lenbits)-1,b=(1<<n.distbits)-1;e:do{p<15&&(f+=A[i++]<<p,p+=8,f+=A[i++]<<p,p+=8),w=m[f&y];t:for(;;){if(f>>>=v=w>>>24,p-=v,0==(v=w>>>16&255))P[s++]=65535&w;else{if(!(16&v)){if(0==(64&v)){w=m[(65535&w)+(f&(1<<v)-1)];continue t}if(32&v){n.mode=12;break e}e.msg="invalid literal/length code",n.mode=30;break e}_=65535&w,(v&=15)&&(p<v&&(f+=A[i++]<<p,p+=8),_+=f&(1<<v)-1,f>>>=v,p-=v),p<15&&(f+=A[i++]<<p,p+=8,f+=A[i++]<<p,p+=8),w=g[f&b];n:for(;;){if(f>>>=v=w>>>24,p-=v,!(16&(v=w>>>16&255))){if(0==(64&v)){w=g[(65535&w)+(f&(1<<v)-1)];continue n}e.msg="invalid distance code",n.mode=30;break e}if(E=65535&w,p<(v&=15)&&(f+=A[i++]<<p,(p+=8)<v&&(f+=A[i++]<<p,p+=8)),l<(E+=f&(1<<v)-1)){e.msg="invalid distance too far back",n.mode=30;break e}if(f>>>=v,p-=v,(v=s-o)<E){if(h<(v=E-v)&&n.sane){e.msg="invalid distance too far back",n.mode=30;break e}if(C=d,(k=0)===c){if(k+=u-v,v<_){for(_-=v;P[s++]=d[k++],--v;);k=s-E,C=P}}else if(c<v){if(k+=u+c-v,(v-=c)<_){for(_-=v;P[s++]=d[k++],--v;);if(k=0,c<_){for(_-=v=c;P[s++]=d[k++],--v;);k=s-E,C=P}}}else if(k+=c-v,v<_){for(_-=v;P[s++]=d[k++],--v;);k=s-E,C=P}for(;2<_;)P[s++]=C[k++],P[s++]=C[k++],P[s++]=C[k++],_-=3;_&&(P[s++]=C[k++],1<_&&(P[s++]=C[k++]))}else{for(k=s-E;P[s++]=P[k++],P[s++]=P[k++],P[s++]=P[k++],2<(_-=3););_&&(P[s++]=P[k++],1<_&&(P[s++]=P[k++]))}break}}break}}while(i<r&&s<a);i-=_=p>>3,f&=(1<<(p-=_<<3))-1,e.next_in=i,e.next_out=s,e.avail_in=i<r?r-i+5:5-(i-r),e.avail_out=s<a?a-s+257:257-(s-a),n.hold=f,n.bits=p}},{}],49:[function(e,t,n){"use strict";var i=e("../utils/common"),r=e("./adler32"),s=e("./crc32"),o=e("./inffast"),a=e("./inftrees"),l=-2;function u(e){return(e>>>24&255)+(e>>>8&65280)+((65280&e)<<8)+((255&e)<<24)}function h(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new i.Buf16(320),this.work=new i.Buf16(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}function c(e){var t;return e&&e.state?(t=e.state,e.total_in=e.total_out=t.total=0,e.msg="",t.wrap&&(e.adler=1&t.wrap),t.mode=1,t.last=0,t.havedict=0,t.dmax=32768,t.head=null,t.hold=0,t.bits=0,t.lencode=t.lendyn=new i.Buf32(852),t.distcode=t.distdyn=new i.Buf32(592),t.sane=1,t.back=-1,0):l}function d(e){var t;return e&&e.state?((t=e.state).wsize=0,t.whave=0,t.wnext=0,c(e)):l}function f(e,t){var n,i;return e&&e.state?(i=e.state,t<0?(n=0,t=-t):(n=1+(t>>4),t<48&&(t&=15)),t&&(t<8||15<t)?l:(null!==i.window&&i.wbits!==t&&(i.window=null),i.wrap=n,i.wbits=t,d(e))):l}function p(e,t){var n,i;return e?(i=new h,(e.state=i).window=null,0!==(n=f(e,t))&&(e.state=null),n):l}var m,g,y=!0;function b(e){if(y){var t;for(m=new i.Buf32(512),g=new i.Buf32(32),t=0;t<144;)e.lens[t++]=8;for(;t<256;)e.lens[t++]=9;for(;t<280;)e.lens[t++]=7;for(;t<288;)e.lens[t++]=8;for(a(1,e.lens,0,288,m,0,e.work,{bits:9}),t=0;t<32;)e.lens[t++]=5;a(2,e.lens,0,32,g,0,e.work,{bits:5}),y=!1}e.lencode=m,e.lenbits=9,e.distcode=g,e.distbits=5}function w(e,t,n,r){var s,o=e.state;return null===o.window&&(o.wsize=1<<o.wbits,o.wnext=0,o.whave=0,o.window=new i.Buf8(o.wsize)),r>=o.wsize?(i.arraySet(o.window,t,n-o.wsize,o.wsize,0),o.wnext=0,o.whave=o.wsize):(r<(s=o.wsize-o.wnext)&&(s=r),i.arraySet(o.window,t,n-r,s,o.wnext),(r-=s)?(i.arraySet(o.window,t,n-r,r,0),o.wnext=r,o.whave=o.wsize):(o.wnext+=s,o.wnext===o.wsize&&(o.wnext=0),o.whave<o.wsize&&(o.whave+=s))),0}n.inflateReset=d,n.inflateReset2=f,n.inflateResetKeep=c,n.inflateInit=function(e){return p(e,15)},n.inflateInit2=p,n.inflate=function(e,t){var n,h,c,d,f,p,m,g,y,v,_,E,k,C,A,P,x,j,T,S,O,Q,N,D,R=0,I=new i.Buf8(4),L=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!e||!e.state||!e.output||!e.input&&0!==e.avail_in)return l;12===(n=e.state).mode&&(n.mode=13),f=e.next_out,c=e.output,m=e.avail_out,d=e.next_in,h=e.input,p=e.avail_in,g=n.hold,y=n.bits,v=p,_=m,Q=0;e:for(;;)switch(n.mode){case 1:if(0===n.wrap){n.mode=13;break}for(;y<16;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}if(2&n.wrap&&35615===g){I[n.check=0]=255&g,I[1]=g>>>8&255,n.check=s(n.check,I,2,0),y=g=0,n.mode=2;break}if(n.flags=0,n.head&&(n.head.done=!1),!(1&n.wrap)||(((255&g)<<8)+(g>>8))%31){e.msg="incorrect header check",n.mode=30;break}if(8!=(15&g)){e.msg="unknown compression method",n.mode=30;break}if(y-=4,O=8+(15&(g>>>=4)),0===n.wbits)n.wbits=O;else if(O>n.wbits){e.msg="invalid window size",n.mode=30;break}n.dmax=1<<O,e.adler=n.check=1,n.mode=512&g?10:12,y=g=0;break;case 2:for(;y<16;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}if(n.flags=g,8!=(255&n.flags)){e.msg="unknown compression method",n.mode=30;break}if(57344&n.flags){e.msg="unknown header flags set",n.mode=30;break}n.head&&(n.head.text=g>>8&1),512&n.flags&&(I[0]=255&g,I[1]=g>>>8&255,n.check=s(n.check,I,2,0)),y=g=0,n.mode=3;case 3:for(;y<32;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}n.head&&(n.head.time=g),512&n.flags&&(I[0]=255&g,I[1]=g>>>8&255,I[2]=g>>>16&255,I[3]=g>>>24&255,n.check=s(n.check,I,4,0)),y=g=0,n.mode=4;case 4:for(;y<16;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}n.head&&(n.head.xflags=255&g,n.head.os=g>>8),512&n.flags&&(I[0]=255&g,I[1]=g>>>8&255,n.check=s(n.check,I,2,0)),y=g=0,n.mode=5;case 5:if(1024&n.flags){for(;y<16;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}n.length=g,n.head&&(n.head.extra_len=g),512&n.flags&&(I[0]=255&g,I[1]=g>>>8&255,n.check=s(n.check,I,2,0)),y=g=0}else n.head&&(n.head.extra=null);n.mode=6;case 6:if(1024&n.flags&&(p<(E=n.length)&&(E=p),E&&(n.head&&(O=n.head.extra_len-n.length,n.head.extra||(n.head.extra=new Array(n.head.extra_len)),i.arraySet(n.head.extra,h,d,E,O)),512&n.flags&&(n.check=s(n.check,h,E,d)),p-=E,d+=E,n.length-=E),n.length))break e;n.length=0,n.mode=7;case 7:if(2048&n.flags){if(0===p)break e;for(E=0;O=h[d+E++],n.head&&O&&n.length<65536&&(n.head.name+=String.fromCharCode(O)),O&&E<p;);if(512&n.flags&&(n.check=s(n.check,h,E,d)),p-=E,d+=E,O)break e}else n.head&&(n.head.name=null);n.length=0,n.mode=8;case 8:if(4096&n.flags){if(0===p)break e;for(E=0;O=h[d+E++],n.head&&O&&n.length<65536&&(n.head.comment+=String.fromCharCode(O)),O&&E<p;);if(512&n.flags&&(n.check=s(n.check,h,E,d)),p-=E,d+=E,O)break e}else n.head&&(n.head.comment=null);n.mode=9;case 9:if(512&n.flags){for(;y<16;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}if(g!==(65535&n.check)){e.msg="header crc mismatch",n.mode=30;break}y=g=0}n.head&&(n.head.hcrc=n.flags>>9&1,n.head.done=!0),e.adler=n.check=0,n.mode=12;break;case 10:for(;y<32;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}e.adler=n.check=u(g),y=g=0,n.mode=11;case 11:if(0===n.havedict)return e.next_out=f,e.avail_out=m,e.next_in=d,e.avail_in=p,n.hold=g,n.bits=y,2;e.adler=n.check=1,n.mode=12;case 12:if(5===t||6===t)break e;case 13:if(n.last){g>>>=7&y,y-=7&y,n.mode=27;break}for(;y<3;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}switch(n.last=1&g,y-=1,3&(g>>>=1)){case 0:n.mode=14;break;case 1:if(b(n),n.mode=20,6!==t)break;g>>>=2,y-=2;break e;case 2:n.mode=17;break;case 3:e.msg="invalid block type",n.mode=30}g>>>=2,y-=2;break;case 14:for(g>>>=7&y,y-=7&y;y<32;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}if((65535&g)!=(g>>>16^65535)){e.msg="invalid stored block lengths",n.mode=30;break}if(n.length=65535&g,y=g=0,n.mode=15,6===t)break e;case 15:n.mode=16;case 16:if(E=n.length){if(p<E&&(E=p),m<E&&(E=m),0===E)break e;i.arraySet(c,h,d,E,f),p-=E,d+=E,m-=E,f+=E,n.length-=E;break}n.mode=12;break;case 17:for(;y<14;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}if(n.nlen=257+(31&g),g>>>=5,y-=5,n.ndist=1+(31&g),g>>>=5,y-=5,n.ncode=4+(15&g),g>>>=4,y-=4,286<n.nlen||30<n.ndist){e.msg="too many length or distance symbols",n.mode=30;break}n.have=0,n.mode=18;case 18:for(;n.have<n.ncode;){for(;y<3;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}n.lens[L[n.have++]]=7&g,g>>>=3,y-=3}for(;n.have<19;)n.lens[L[n.have++]]=0;if(n.lencode=n.lendyn,n.lenbits=7,N={bits:n.lenbits},Q=a(0,n.lens,0,19,n.lencode,0,n.work,N),n.lenbits=N.bits,Q){e.msg="invalid code lengths set",n.mode=30;break}n.have=0,n.mode=19;case 19:for(;n.have<n.nlen+n.ndist;){for(;P=(R=n.lencode[g&(1<<n.lenbits)-1])>>>16&255,x=65535&R,!((A=R>>>24)<=y);){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}if(x<16)g>>>=A,y-=A,n.lens[n.have++]=x;else{if(16===x){for(D=A+2;y<D;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}if(g>>>=A,y-=A,0===n.have){e.msg="invalid bit length repeat",n.mode=30;break}O=n.lens[n.have-1],E=3+(3&g),g>>>=2,y-=2}else if(17===x){for(D=A+3;y<D;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}y-=A,O=0,E=3+(7&(g>>>=A)),g>>>=3,y-=3}else{for(D=A+7;y<D;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}y-=A,O=0,E=11+(127&(g>>>=A)),g>>>=7,y-=7}if(n.have+E>n.nlen+n.ndist){e.msg="invalid bit length repeat",n.mode=30;break}for(;E--;)n.lens[n.have++]=O}}if(30===n.mode)break;if(0===n.lens[256]){e.msg="invalid code -- missing end-of-block",n.mode=30;break}if(n.lenbits=9,N={bits:n.lenbits},Q=a(1,n.lens,0,n.nlen,n.lencode,0,n.work,N),n.lenbits=N.bits,Q){e.msg="invalid literal/lengths set",n.mode=30;break}if(n.distbits=6,n.distcode=n.distdyn,N={bits:n.distbits},Q=a(2,n.lens,n.nlen,n.ndist,n.distcode,0,n.work,N),n.distbits=N.bits,Q){e.msg="invalid distances set",n.mode=30;break}if(n.mode=20,6===t)break e;case 20:n.mode=21;case 21:if(6<=p&&258<=m){e.next_out=f,e.avail_out=m,e.next_in=d,e.avail_in=p,n.hold=g,n.bits=y,o(e,_),f=e.next_out,c=e.output,m=e.avail_out,d=e.next_in,h=e.input,p=e.avail_in,g=n.hold,y=n.bits,12===n.mode&&(n.back=-1);break}for(n.back=0;P=(R=n.lencode[g&(1<<n.lenbits)-1])>>>16&255,x=65535&R,!((A=R>>>24)<=y);){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}if(P&&0==(240&P)){for(j=A,T=P,S=x;P=(R=n.lencode[S+((g&(1<<j+T)-1)>>j)])>>>16&255,x=65535&R,!(j+(A=R>>>24)<=y);){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}g>>>=j,y-=j,n.back+=j}if(g>>>=A,y-=A,n.back+=A,n.length=x,0===P){n.mode=26;break}if(32&P){n.back=-1,n.mode=12;break}if(64&P){e.msg="invalid literal/length code",n.mode=30;break}n.extra=15&P,n.mode=22;case 22:if(n.extra){for(D=n.extra;y<D;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}n.length+=g&(1<<n.extra)-1,g>>>=n.extra,y-=n.extra,n.back+=n.extra}n.was=n.length,n.mode=23;case 23:for(;P=(R=n.distcode[g&(1<<n.distbits)-1])>>>16&255,x=65535&R,!((A=R>>>24)<=y);){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}if(0==(240&P)){for(j=A,T=P,S=x;P=(R=n.distcode[S+((g&(1<<j+T)-1)>>j)])>>>16&255,x=65535&R,!(j+(A=R>>>24)<=y);){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}g>>>=j,y-=j,n.back+=j}if(g>>>=A,y-=A,n.back+=A,64&P){e.msg="invalid distance code",n.mode=30;break}n.offset=x,n.extra=15&P,n.mode=24;case 24:if(n.extra){for(D=n.extra;y<D;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}n.offset+=g&(1<<n.extra)-1,g>>>=n.extra,y-=n.extra,n.back+=n.extra}if(n.offset>n.dmax){e.msg="invalid distance too far back",n.mode=30;break}n.mode=25;case 25:if(0===m)break e;if(E=_-m,n.offset>E){if((E=n.offset-E)>n.whave&&n.sane){e.msg="invalid distance too far back",n.mode=30;break}k=E>n.wnext?(E-=n.wnext,n.wsize-E):n.wnext-E,E>n.length&&(E=n.length),C=n.window}else C=c,k=f-n.offset,E=n.length;for(m<E&&(E=m),m-=E,n.length-=E;c[f++]=C[k++],--E;);0===n.length&&(n.mode=21);break;case 26:if(0===m)break e;c[f++]=n.length,m--,n.mode=21;break;case 27:if(n.wrap){for(;y<32;){if(0===p)break e;p--,g|=h[d++]<<y,y+=8}if(_-=m,e.total_out+=_,n.total+=_,_&&(e.adler=n.check=n.flags?s(n.check,c,_,f-_):r(n.check,c,_,f-_)),_=m,(n.flags?g:u(g))!==n.check){e.msg="incorrect data check",n.mode=30;break}y=g=0}n.mode=28;case 28:if(n.wrap&&n.flags){for(;y<32;){if(0===p)break e;p--,g+=h[d++]<<y,y+=8}if(g!==(4294967295&n.total)){e.msg="incorrect length check",n.mode=30;break}y=g=0}n.mode=29;case 29:Q=1;break e;case 30:Q=-3;break e;case 31:return-4;case 32:default:return l}return e.next_out=f,e.avail_out=m,e.next_in=d,e.avail_in=p,n.hold=g,n.bits=y,(n.wsize||_!==e.avail_out&&n.mode<30&&(n.mode<27||4!==t))&&w(e,e.output,e.next_out,_-e.avail_out)?(n.mode=31,-4):(v-=e.avail_in,_-=e.avail_out,e.total_in+=v,e.total_out+=_,n.total+=_,n.wrap&&_&&(e.adler=n.check=n.flags?s(n.check,c,_,e.next_out-_):r(n.check,c,_,e.next_out-_)),e.data_type=n.bits+(n.last?64:0)+(12===n.mode?128:0)+(20===n.mode||15===n.mode?256:0),(0==v&&0===_||4===t)&&0===Q&&(Q=-5),Q)},n.inflateEnd=function(e){if(!e||!e.state)return l;var t=e.state;return t.window&&(t.window=null),e.state=null,0},n.inflateGetHeader=function(e,t){var n;return e&&e.state?0==(2&(n=e.state).wrap)?l:((n.head=t).done=!1,0):l},n.inflateSetDictionary=function(e,t){var n,i=t.length;return e&&e.state?0!==(n=e.state).wrap&&11!==n.mode?l:11===n.mode&&r(1,t,i,0)!==n.check?-3:w(e,t,i,i)?(n.mode=31,-4):(n.havedict=1,0):l},n.inflateInfo="pako inflate (from Nodeca project)"},{"../utils/common":41,"./adler32":43,"./crc32":45,"./inffast":48,"./inftrees":50}],50:[function(e,t,n){"use strict";var i=e("../utils/common"),r=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],s=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],o=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],a=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64];t.exports=function(e,t,n,l,u,h,c,d){var f,p,m,g,y,b,w,v,_,E=d.bits,k=0,C=0,A=0,P=0,x=0,j=0,T=0,S=0,O=0,Q=0,N=null,D=0,R=new i.Buf16(16),I=new i.Buf16(16),L=null,F=0;for(k=0;k<=15;k++)R[k]=0;for(C=0;C<l;C++)R[t[n+C]]++;for(x=E,P=15;1<=P&&0===R[P];P--);if(P<x&&(x=P),0===P)return u[h++]=20971520,u[h++]=20971520,d.bits=1,0;for(A=1;A<P&&0===R[A];A++);for(x<A&&(x=A),k=S=1;k<=15;k++)if(S<<=1,(S-=R[k])<0)return-1;if(0<S&&(0===e||1!==P))return-1;for(I[1]=0,k=1;k<15;k++)I[k+1]=I[k]+R[k];for(C=0;C<l;C++)0!==t[n+C]&&(c[I[t[n+C]]++]=C);if(b=0===e?(N=L=c,19):1===e?(N=r,D-=257,L=s,F-=257,256):(N=o,L=a,-1),k=A,y=h,T=C=Q=0,m=-1,g=(O=1<<(j=x))-1,1===e&&852<O||2===e&&592<O)return 1;for(;;){for(w=k-T,_=c[C]<b?(v=0,c[C]):c[C]>b?(v=L[F+c[C]],N[D+c[C]]):(v=96,0),f=1<<k-T,A=p=1<<j;u[y+(Q>>T)+(p-=f)]=w<<24|v<<16|_|0,0!==p;);for(f=1<<k-1;Q&f;)f>>=1;if(0!==f?(Q&=f-1,Q+=f):Q=0,C++,0==--R[k]){if(k===P)break;k=t[n+c[C]]}if(x<k&&(Q&g)!==m){for(0===T&&(T=x),y+=A,S=1<<(j=k-T);j+T<P&&!((S-=R[j+T])<=0);)j++,S<<=1;if(O+=1<<j,1===e&&852<O||2===e&&592<O)return 1;u[m=Q&g]=x<<24|j<<16|y-h|0}}return 0!==Q&&(u[y+Q]=k-T<<24|64<<16|0),d.bits=x,0}},{"../utils/common":41}],51:[function(e,t,n){"use strict";t.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}},{}],52:[function(e,t,n){"use strict";var i=e("../utils/common");function r(e){for(var t=e.length;0<=--t;)e[t]=0}var s=15,o=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],a=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],l=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],u=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],h=new Array(576);r(h);var c=new Array(60);r(c);var d=new Array(512);r(d);var f=new Array(256);r(f);var p=new Array(29);r(p);var m,g,y,b=new Array(30);function w(e,t,n,i,r){this.static_tree=e,this.extra_bits=t,this.extra_base=n,this.elems=i,this.max_length=r,this.has_stree=e&&e.length}function v(e,t){this.dyn_tree=e,this.max_code=0,this.stat_desc=t}function _(e){return e<256?d[e]:d[256+(e>>>7)]}function E(e,t){e.pending_buf[e.pending++]=255&t,e.pending_buf[e.pending++]=t>>>8&255}function k(e,t,n){e.bi_valid>16-n?(e.bi_buf|=t<<e.bi_valid&65535,E(e,e.bi_buf),e.bi_buf=t>>16-e.bi_valid,e.bi_valid+=n-16):(e.bi_buf|=t<<e.bi_valid&65535,e.bi_valid+=n)}function C(e,t,n){k(e,n[2*t],n[2*t+1])}function A(e,t){for(var n=0;n|=1&e,e>>>=1,n<<=1,0<--t;);return n>>>1}function P(e,t,n){var i,r,o=new Array(16),a=0;for(i=1;i<=s;i++)o[i]=a=a+n[i-1]<<1;for(r=0;r<=t;r++){var l=e[2*r+1];0!==l&&(e[2*r]=A(o[l]++,l))}}function x(e){var t;for(t=0;t<286;t++)e.dyn_ltree[2*t]=0;for(t=0;t<30;t++)e.dyn_dtree[2*t]=0;for(t=0;t<19;t++)e.bl_tree[2*t]=0;e.dyn_ltree[512]=1,e.opt_len=e.static_len=0,e.last_lit=e.matches=0}function j(e){8<e.bi_valid?E(e,e.bi_buf):0<e.bi_valid&&(e.pending_buf[e.pending++]=e.bi_buf),e.bi_buf=0,e.bi_valid=0}function T(e,t,n,i){var r=2*t,s=2*n;return e[r]<e[s]||e[r]===e[s]&&i[t]<=i[n]}function S(e,t,n){for(var i=e.heap[n],r=n<<1;r<=e.heap_len&&(r<e.heap_len&&T(t,e.heap[r+1],e.heap[r],e.depth)&&r++,!T(t,i,e.heap[r],e.depth));)e.heap[n]=e.heap[r],n=r,r<<=1;e.heap[n]=i}function O(e,t,n){var i,r,s,l,u=0;if(0!==e.last_lit)for(;i=e.pending_buf[e.d_buf+2*u]<<8|e.pending_buf[e.d_buf+2*u+1],r=e.pending_buf[e.l_buf+u],u++,0===i?C(e,r,t):(C(e,(s=f[r])+256+1,t),0!==(l=o[s])&&k(e,r-=p[s],l),C(e,s=_(--i),n),0!==(l=a[s])&&k(e,i-=b[s],l)),u<e.last_lit;);C(e,256,t)}function Q(e,t){var n,i,r,o=t.dyn_tree,a=t.stat_desc.static_tree,l=t.stat_desc.has_stree,u=t.stat_desc.elems,h=-1;for(e.heap_len=0,e.heap_max=573,n=0;n<u;n++)0!==o[2*n]?(e.heap[++e.heap_len]=h=n,e.depth[n]=0):o[2*n+1]=0;for(;e.heap_len<2;)o[2*(r=e.heap[++e.heap_len]=h<2?++h:0)]=1,e.depth[r]=0,e.opt_len--,l&&(e.static_len-=a[2*r+1]);for(t.max_code=h,n=e.heap_len>>1;1<=n;n--)S(e,o,n);for(r=u;n=e.heap[1],e.heap[1]=e.heap[e.heap_len--],S(e,o,1),i=e.heap[1],e.heap[--e.heap_max]=n,e.heap[--e.heap_max]=i,o[2*r]=o[2*n]+o[2*i],e.depth[r]=(e.depth[n]>=e.depth[i]?e.depth[n]:e.depth[i])+1,o[2*n+1]=o[2*i+1]=r,e.heap[1]=r++,S(e,o,1),2<=e.heap_len;);e.heap[--e.heap_max]=e.heap[1],function(e,t){var n,i,r,o,a,l,u=t.dyn_tree,h=t.max_code,c=t.stat_desc.static_tree,d=t.stat_desc.has_stree,f=t.stat_desc.extra_bits,p=t.stat_desc.extra_base,m=t.stat_desc.max_length,g=0;for(o=0;o<=s;o++)e.bl_count[o]=0;for(u[2*e.heap[e.heap_max]+1]=0,n=e.heap_max+1;n<573;n++)m<(o=u[2*u[2*(i=e.heap[n])+1]+1]+1)&&(o=m,g++),u[2*i+1]=o,h<i||(e.bl_count[o]++,a=0,p<=i&&(a=f[i-p]),l=u[2*i],e.opt_len+=l*(o+a),d&&(e.static_len+=l*(c[2*i+1]+a)));if(0!==g){do{for(o=m-1;0===e.bl_count[o];)o--;e.bl_count[o]--,e.bl_count[o+1]+=2,e.bl_count[m]--,g-=2}while(0<g);for(o=m;0!==o;o--)for(i=e.bl_count[o];0!==i;)h<(r=e.heap[--n])||(u[2*r+1]!==o&&(e.opt_len+=(o-u[2*r+1])*u[2*r],u[2*r+1]=o),i--)}}(e,t),P(o,h,e.bl_count)}function N(e,t,n){var i,r,s=-1,o=t[1],a=0,l=7,u=4;for(0===o&&(l=138,u=3),t[2*(n+1)+1]=65535,i=0;i<=n;i++)r=o,o=t[2*(i+1)+1],++a<l&&r===o||(a<u?e.bl_tree[2*r]+=a:0!==r?(r!==s&&e.bl_tree[2*r]++,e.bl_tree[32]++):a<=10?e.bl_tree[34]++:e.bl_tree[36]++,s=r,u=(a=0)===o?(l=138,3):r===o?(l=6,3):(l=7,4))}function D(e,t,n){var i,r,s=-1,o=t[1],a=0,l=7,u=4;for(0===o&&(l=138,u=3),i=0;i<=n;i++)if(r=o,o=t[2*(i+1)+1],!(++a<l&&r===o)){if(a<u)for(;C(e,r,e.bl_tree),0!=--a;);else 0!==r?(r!==s&&(C(e,r,e.bl_tree),a--),C(e,16,e.bl_tree),k(e,a-3,2)):a<=10?(C(e,17,e.bl_tree),k(e,a-3,3)):(C(e,18,e.bl_tree),k(e,a-11,7));s=r,u=(a=0)===o?(l=138,3):r===o?(l=6,3):(l=7,4)}}r(b);var R=!1;function I(e,t,n,r){var s,o,a;k(e,0+(r?1:0),3),o=t,a=n,j(s=e),E(s,a),E(s,~a),i.arraySet(s.pending_buf,s.window,o,a,s.pending),s.pending+=a}n._tr_init=function(e){R||(function(){var e,t,n,i,r,u=new Array(16);for(i=n=0;i<28;i++)for(p[i]=n,e=0;e<1<<o[i];e++)f[n++]=i;for(f[n-1]=i,i=r=0;i<16;i++)for(b[i]=r,e=0;e<1<<a[i];e++)d[r++]=i;for(r>>=7;i<30;i++)for(b[i]=r<<7,e=0;e<1<<a[i]-7;e++)d[256+r++]=i;for(t=0;t<=s;t++)u[t]=0;for(e=0;e<=143;)h[2*e+1]=8,e++,u[8]++;for(;e<=255;)h[2*e+1]=9,e++,u[9]++;for(;e<=279;)h[2*e+1]=7,e++,u[7]++;for(;e<=287;)h[2*e+1]=8,e++,u[8]++;for(P(h,287,u),e=0;e<30;e++)c[2*e+1]=5,c[2*e]=A(e,5);m=new w(h,o,257,286,s),g=new w(c,a,0,30,s),y=new w(new Array(0),l,0,19,7)}(),R=!0),e.l_desc=new v(e.dyn_ltree,m),e.d_desc=new v(e.dyn_dtree,g),e.bl_desc=new v(e.bl_tree,y),e.bi_buf=0,e.bi_valid=0,x(e)},n._tr_stored_block=I,n._tr_flush_block=function(e,t,n,i){var r,s,o=0;0<e.level?(2===e.strm.data_type&&(e.strm.data_type=function(e){var t,n=4093624447;for(t=0;t<=31;t++,n>>>=1)if(1&n&&0!==e.dyn_ltree[2*t])return 0;if(0!==e.dyn_ltree[18]||0!==e.dyn_ltree[20]||0!==e.dyn_ltree[26])return 1;for(t=32;t<256;t++)if(0!==e.dyn_ltree[2*t])return 1;return 0}(e)),Q(e,e.l_desc),Q(e,e.d_desc),o=function(e){var t;for(N(e,e.dyn_ltree,e.l_desc.max_code),N(e,e.dyn_dtree,e.d_desc.max_code),Q(e,e.bl_desc),t=18;3<=t&&0===e.bl_tree[2*u[t]+1];t--);return e.opt_len+=3*(t+1)+5+5+4,t}(e),r=e.opt_len+3+7>>>3,(s=e.static_len+3+7>>>3)<=r&&(r=s)):r=s=n+5,n+4<=r&&-1!==t?I(e,t,n,i):4===e.strategy||s===r?(k(e,2+(i?1:0),3),O(e,h,c)):(k(e,4+(i?1:0),3),function(e,t,n,i){var r;for(k(e,t-257,5),k(e,n-1,5),k(e,i-4,4),r=0;r<i;r++)k(e,e.bl_tree[2*u[r]+1],3);D(e,e.dyn_ltree,t-1),D(e,e.dyn_dtree,n-1)}(e,e.l_desc.max_code+1,e.d_desc.max_code+1,o+1),O(e,e.dyn_ltree,e.dyn_dtree)),x(e),i&&j(e)},n._tr_tally=function(e,t,n){return e.pending_buf[e.d_buf+2*e.last_lit]=t>>>8&255,e.pending_buf[e.d_buf+2*e.last_lit+1]=255&t,e.pending_buf[e.l_buf+e.last_lit]=255&n,e.last_lit++,0===t?e.dyn_ltree[2*n]++:(e.matches++,t--,e.dyn_ltree[2*(f[n]+256+1)]++,e.dyn_dtree[2*_(t)]++),e.last_lit===e.lit_bufsize-1},n._tr_align=function(e){var t;k(e,2,3),C(e,256,h),16===(t=e).bi_valid?(E(t,t.bi_buf),t.bi_buf=0,t.bi_valid=0):8<=t.bi_valid&&(t.pending_buf[t.pending++]=255&t.bi_buf,t.bi_buf>>=8,t.bi_valid-=8)}},{"../utils/common":41}],53:[function(e,t,n){"use strict";t.exports=function(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}},{}],54:[function(e,t,n){"use strict";t.exports="function"==typeof i?i:function(){var e=[].slice.apply(arguments);e.splice(1,0,0),setTimeout.apply(null,e)}},{}]},{},[10])(10)}))}).call(this,void 0!==t?t:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}]},{},[1])(1)}))}).call(this,void 0!==t?t:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}]},{},[1])(1)}))}).call(this,void 0!==t?t:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}]},{},[1])(1)}))}).call(this,void 0!==t?t:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}]},{},[1])(1)}))}).call(this,void 0!==t?t:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}]},{},[1])(1)}).call(this,n(3),n(10).Buffer,n(14).setImmediate)},function(e,t,n){"use strict";(function(e){
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <http://feross.org>
 * @license  MIT
 */
var i=n(11),r=n(12),s=n(13);function o(){return l.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function a(e,t){if(o()<t)throw new RangeError("Invalid typed array length");return l.TYPED_ARRAY_SUPPORT?(e=new Uint8Array(t)).__proto__=l.prototype:(null===e&&(e=new l(t)),e.length=t),e}function l(e,t,n){if(!(l.TYPED_ARRAY_SUPPORT||this instanceof l))return new l(e,t,n);if("number"==typeof e){if("string"==typeof t)throw new Error("If encoding is specified then the first argument must be a string");return c(this,e)}return u(this,e,t,n)}function u(e,t,n,i){if("number"==typeof t)throw new TypeError('"value" argument must not be a number');return"undefined"!=typeof ArrayBuffer&&t instanceof ArrayBuffer?function(e,t,n,i){if(t.byteLength,n<0||t.byteLength<n)throw new RangeError("'offset' is out of bounds");if(t.byteLength<n+(i||0))throw new RangeError("'length' is out of bounds");t=void 0===n&&void 0===i?new Uint8Array(t):void 0===i?new Uint8Array(t,n):new Uint8Array(t,n,i);l.TYPED_ARRAY_SUPPORT?(e=t).__proto__=l.prototype:e=d(e,t);return e}(e,t,n,i):"string"==typeof t?function(e,t,n){"string"==typeof n&&""!==n||(n="utf8");if(!l.isEncoding(n))throw new TypeError('"encoding" must be a valid string encoding');var i=0|p(t,n),r=(e=a(e,i)).write(t,n);r!==i&&(e=e.slice(0,r));return e}(e,t,n):function(e,t){if(l.isBuffer(t)){var n=0|f(t.length);return 0===(e=a(e,n)).length||t.copy(e,0,0,n),e}if(t){if("undefined"!=typeof ArrayBuffer&&t.buffer instanceof ArrayBuffer||"length"in t)return"number"!=typeof t.length||(i=t.length)!=i?a(e,0):d(e,t);if("Buffer"===t.type&&s(t.data))return d(e,t.data)}var i;throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}(e,t)}function h(e){if("number"!=typeof e)throw new TypeError('"size" argument must be a number');if(e<0)throw new RangeError('"size" argument must not be negative')}function c(e,t){if(h(t),e=a(e,t<0?0:0|f(t)),!l.TYPED_ARRAY_SUPPORT)for(var n=0;n<t;++n)e[n]=0;return e}function d(e,t){var n=t.length<0?0:0|f(t.length);e=a(e,n);for(var i=0;i<n;i+=1)e[i]=255&t[i];return e}function f(e){if(e>=o())throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+o().toString(16)+" bytes");return 0|e}function p(e,t){if(l.isBuffer(e))return e.length;if("undefined"!=typeof ArrayBuffer&&"function"==typeof ArrayBuffer.isView&&(ArrayBuffer.isView(e)||e instanceof ArrayBuffer))return e.byteLength;"string"!=typeof e&&(e=""+e);var n=e.length;if(0===n)return 0;for(var i=!1;;)switch(t){case"ascii":case"latin1":case"binary":return n;case"utf8":case"utf-8":case void 0:return U(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return 2*n;case"hex":return n>>>1;case"base64":return z(e).length;default:if(i)return U(e).length;t=(""+t).toLowerCase(),i=!0}}function m(e,t,n){var i=!1;if((void 0===t||t<0)&&(t=0),t>this.length)return"";if((void 0===n||n>this.length)&&(n=this.length),n<=0)return"";if((n>>>=0)<=(t>>>=0))return"";for(e||(e="utf8");;)switch(e){case"hex":return T(this,t,n);case"utf8":case"utf-8":return P(this,t,n);case"ascii":return x(this,t,n);case"latin1":case"binary":return j(this,t,n);case"base64":return A(this,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return S(this,t,n);default:if(i)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),i=!0}}function g(e,t,n){var i=e[t];e[t]=e[n],e[n]=i}function y(e,t,n,i,r){if(0===e.length)return-1;if("string"==typeof n?(i=n,n=0):n>2147483647?n=2147483647:n<-2147483648&&(n=-2147483648),n=+n,isNaN(n)&&(n=r?0:e.length-1),n<0&&(n=e.length+n),n>=e.length){if(r)return-1;n=e.length-1}else if(n<0){if(!r)return-1;n=0}if("string"==typeof t&&(t=l.from(t,i)),l.isBuffer(t))return 0===t.length?-1:b(e,t,n,i,r);if("number"==typeof t)return t&=255,l.TYPED_ARRAY_SUPPORT&&"function"==typeof Uint8Array.prototype.indexOf?r?Uint8Array.prototype.indexOf.call(e,t,n):Uint8Array.prototype.lastIndexOf.call(e,t,n):b(e,[t],n,i,r);throw new TypeError("val must be string, number or Buffer")}function b(e,t,n,i,r){var s,o=1,a=e.length,l=t.length;if(void 0!==i&&("ucs2"===(i=String(i).toLowerCase())||"ucs-2"===i||"utf16le"===i||"utf-16le"===i)){if(e.length<2||t.length<2)return-1;o=2,a/=2,l/=2,n/=2}function u(e,t){return 1===o?e[t]:e.readUInt16BE(t*o)}if(r){var h=-1;for(s=n;s<a;s++)if(u(e,s)===u(t,-1===h?0:s-h)){if(-1===h&&(h=s),s-h+1===l)return h*o}else-1!==h&&(s-=s-h),h=-1}else for(n+l>a&&(n=a-l),s=n;s>=0;s--){for(var c=!0,d=0;d<l;d++)if(u(e,s+d)!==u(t,d)){c=!1;break}if(c)return s}return-1}function w(e,t,n,i){n=Number(n)||0;var r=e.length-n;i?(i=Number(i))>r&&(i=r):i=r;var s=t.length;if(s%2!=0)throw new TypeError("Invalid hex string");i>s/2&&(i=s/2);for(var o=0;o<i;++o){var a=parseInt(t.substr(2*o,2),16);if(isNaN(a))return o;e[n+o]=a}return o}function v(e,t,n,i){return M(U(t,e.length-n),e,n,i)}function _(e,t,n,i){return M(function(e){for(var t=[],n=0;n<e.length;++n)t.push(255&e.charCodeAt(n));return t}(t),e,n,i)}function E(e,t,n,i){return _(e,t,n,i)}function k(e,t,n,i){return M(z(t),e,n,i)}function C(e,t,n,i){return M(function(e,t){for(var n,i,r,s=[],o=0;o<e.length&&!((t-=2)<0);++o)n=e.charCodeAt(o),i=n>>8,r=n%256,s.push(r),s.push(i);return s}(t,e.length-n),e,n,i)}function A(e,t,n){return 0===t&&n===e.length?i.fromByteArray(e):i.fromByteArray(e.slice(t,n))}function P(e,t,n){n=Math.min(e.length,n);for(var i=[],r=t;r<n;){var s,o,a,l,u=e[r],h=null,c=u>239?4:u>223?3:u>191?2:1;if(r+c<=n)switch(c){case 1:u<128&&(h=u);break;case 2:128==(192&(s=e[r+1]))&&(l=(31&u)<<6|63&s)>127&&(h=l);break;case 3:s=e[r+1],o=e[r+2],128==(192&s)&&128==(192&o)&&(l=(15&u)<<12|(63&s)<<6|63&o)>2047&&(l<55296||l>57343)&&(h=l);break;case 4:s=e[r+1],o=e[r+2],a=e[r+3],128==(192&s)&&128==(192&o)&&128==(192&a)&&(l=(15&u)<<18|(63&s)<<12|(63&o)<<6|63&a)>65535&&l<1114112&&(h=l)}null===h?(h=65533,c=1):h>65535&&(h-=65536,i.push(h>>>10&1023|55296),h=56320|1023&h),i.push(h),r+=c}return function(e){var t=e.length;if(t<=4096)return String.fromCharCode.apply(String,e);var n="",i=0;for(;i<t;)n+=String.fromCharCode.apply(String,e.slice(i,i+=4096));return n}(i)}t.Buffer=l,t.SlowBuffer=function(e){+e!=e&&(e=0);return l.alloc(+e)},t.INSPECT_MAX_BYTES=50,l.TYPED_ARRAY_SUPPORT=void 0!==e.TYPED_ARRAY_SUPPORT?e.TYPED_ARRAY_SUPPORT:function(){try{var e=new Uint8Array(1);return e.__proto__={__proto__:Uint8Array.prototype,foo:function(){return 42}},42===e.foo()&&"function"==typeof e.subarray&&0===e.subarray(1,1).byteLength}catch(e){return!1}}(),t.kMaxLength=o(),l.poolSize=8192,l._augment=function(e){return e.__proto__=l.prototype,e},l.from=function(e,t,n){return u(null,e,t,n)},l.TYPED_ARRAY_SUPPORT&&(l.prototype.__proto__=Uint8Array.prototype,l.__proto__=Uint8Array,"undefined"!=typeof Symbol&&Symbol.species&&l[Symbol.species]===l&&Object.defineProperty(l,Symbol.species,{value:null,configurable:!0})),l.alloc=function(e,t,n){return function(e,t,n,i){return h(t),t<=0?a(e,t):void 0!==n?"string"==typeof i?a(e,t).fill(n,i):a(e,t).fill(n):a(e,t)}(null,e,t,n)},l.allocUnsafe=function(e){return c(null,e)},l.allocUnsafeSlow=function(e){return c(null,e)},l.isBuffer=function(e){return!(null==e||!e._isBuffer)},l.compare=function(e,t){if(!l.isBuffer(e)||!l.isBuffer(t))throw new TypeError("Arguments must be Buffers");if(e===t)return 0;for(var n=e.length,i=t.length,r=0,s=Math.min(n,i);r<s;++r)if(e[r]!==t[r]){n=e[r],i=t[r];break}return n<i?-1:i<n?1:0},l.isEncoding=function(e){switch(String(e).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},l.concat=function(e,t){if(!s(e))throw new TypeError('"list" argument must be an Array of Buffers');if(0===e.length)return l.alloc(0);var n;if(void 0===t)for(t=0,n=0;n<e.length;++n)t+=e[n].length;var i=l.allocUnsafe(t),r=0;for(n=0;n<e.length;++n){var o=e[n];if(!l.isBuffer(o))throw new TypeError('"list" argument must be an Array of Buffers');o.copy(i,r),r+=o.length}return i},l.byteLength=p,l.prototype._isBuffer=!0,l.prototype.swap16=function(){var e=this.length;if(e%2!=0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var t=0;t<e;t+=2)g(this,t,t+1);return this},l.prototype.swap32=function(){var e=this.length;if(e%4!=0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var t=0;t<e;t+=4)g(this,t,t+3),g(this,t+1,t+2);return this},l.prototype.swap64=function(){var e=this.length;if(e%8!=0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var t=0;t<e;t+=8)g(this,t,t+7),g(this,t+1,t+6),g(this,t+2,t+5),g(this,t+3,t+4);return this},l.prototype.toString=function(){var e=0|this.length;return 0===e?"":0===arguments.length?P(this,0,e):m.apply(this,arguments)},l.prototype.equals=function(e){if(!l.isBuffer(e))throw new TypeError("Argument must be a Buffer");return this===e||0===l.compare(this,e)},l.prototype.inspect=function(){var e="",n=t.INSPECT_MAX_BYTES;return this.length>0&&(e=this.toString("hex",0,n).match(/.{2}/g).join(" "),this.length>n&&(e+=" ... ")),"<Buffer "+e+">"},l.prototype.compare=function(e,t,n,i,r){if(!l.isBuffer(e))throw new TypeError("Argument must be a Buffer");if(void 0===t&&(t=0),void 0===n&&(n=e?e.length:0),void 0===i&&(i=0),void 0===r&&(r=this.length),t<0||n>e.length||i<0||r>this.length)throw new RangeError("out of range index");if(i>=r&&t>=n)return 0;if(i>=r)return-1;if(t>=n)return 1;if(this===e)return 0;for(var s=(r>>>=0)-(i>>>=0),o=(n>>>=0)-(t>>>=0),a=Math.min(s,o),u=this.slice(i,r),h=e.slice(t,n),c=0;c<a;++c)if(u[c]!==h[c]){s=u[c],o=h[c];break}return s<o?-1:o<s?1:0},l.prototype.includes=function(e,t,n){return-1!==this.indexOf(e,t,n)},l.prototype.indexOf=function(e,t,n){return y(this,e,t,n,!0)},l.prototype.lastIndexOf=function(e,t,n){return y(this,e,t,n,!1)},l.prototype.write=function(e,t,n,i){if(void 0===t)i="utf8",n=this.length,t=0;else if(void 0===n&&"string"==typeof t)i=t,n=this.length,t=0;else{if(!isFinite(t))throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");t|=0,isFinite(n)?(n|=0,void 0===i&&(i="utf8")):(i=n,n=void 0)}var r=this.length-t;if((void 0===n||n>r)&&(n=r),e.length>0&&(n<0||t<0)||t>this.length)throw new RangeError("Attempt to write outside buffer bounds");i||(i="utf8");for(var s=!1;;)switch(i){case"hex":return w(this,e,t,n);case"utf8":case"utf-8":return v(this,e,t,n);case"ascii":return _(this,e,t,n);case"latin1":case"binary":return E(this,e,t,n);case"base64":return k(this,e,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return C(this,e,t,n);default:if(s)throw new TypeError("Unknown encoding: "+i);i=(""+i).toLowerCase(),s=!0}},l.prototype.toJSON=function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}};function x(e,t,n){var i="";n=Math.min(e.length,n);for(var r=t;r<n;++r)i+=String.fromCharCode(127&e[r]);return i}function j(e,t,n){var i="";n=Math.min(e.length,n);for(var r=t;r<n;++r)i+=String.fromCharCode(e[r]);return i}function T(e,t,n){var i=e.length;(!t||t<0)&&(t=0),(!n||n<0||n>i)&&(n=i);for(var r="",s=t;s<n;++s)r+=B(e[s]);return r}function S(e,t,n){for(var i=e.slice(t,n),r="",s=0;s<i.length;s+=2)r+=String.fromCharCode(i[s]+256*i[s+1]);return r}function O(e,t,n){if(e%1!=0||e<0)throw new RangeError("offset is not uint");if(e+t>n)throw new RangeError("Trying to access beyond buffer length")}function Q(e,t,n,i,r,s){if(!l.isBuffer(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>r||t<s)throw new RangeError('"value" argument is out of bounds');if(n+i>e.length)throw new RangeError("Index out of range")}function N(e,t,n,i){t<0&&(t=65535+t+1);for(var r=0,s=Math.min(e.length-n,2);r<s;++r)e[n+r]=(t&255<<8*(i?r:1-r))>>>8*(i?r:1-r)}function D(e,t,n,i){t<0&&(t=4294967295+t+1);for(var r=0,s=Math.min(e.length-n,4);r<s;++r)e[n+r]=t>>>8*(i?r:3-r)&255}function R(e,t,n,i,r,s){if(n+i>e.length)throw new RangeError("Index out of range");if(n<0)throw new RangeError("Index out of range")}function I(e,t,n,i,s){return s||R(e,0,n,4),r.write(e,t,n,i,23,4),n+4}function L(e,t,n,i,s){return s||R(e,0,n,8),r.write(e,t,n,i,52,8),n+8}l.prototype.slice=function(e,t){var n,i=this.length;if((e=~~e)<0?(e+=i)<0&&(e=0):e>i&&(e=i),(t=void 0===t?i:~~t)<0?(t+=i)<0&&(t=0):t>i&&(t=i),t<e&&(t=e),l.TYPED_ARRAY_SUPPORT)(n=this.subarray(e,t)).__proto__=l.prototype;else{var r=t-e;n=new l(r,void 0);for(var s=0;s<r;++s)n[s]=this[s+e]}return n},l.prototype.readUIntLE=function(e,t,n){e|=0,t|=0,n||O(e,t,this.length);for(var i=this[e],r=1,s=0;++s<t&&(r*=256);)i+=this[e+s]*r;return i},l.prototype.readUIntBE=function(e,t,n){e|=0,t|=0,n||O(e,t,this.length);for(var i=this[e+--t],r=1;t>0&&(r*=256);)i+=this[e+--t]*r;return i},l.prototype.readUInt8=function(e,t){return t||O(e,1,this.length),this[e]},l.prototype.readUInt16LE=function(e,t){return t||O(e,2,this.length),this[e]|this[e+1]<<8},l.prototype.readUInt16BE=function(e,t){return t||O(e,2,this.length),this[e]<<8|this[e+1]},l.prototype.readUInt32LE=function(e,t){return t||O(e,4,this.length),(this[e]|this[e+1]<<8|this[e+2]<<16)+16777216*this[e+3]},l.prototype.readUInt32BE=function(e,t){return t||O(e,4,this.length),16777216*this[e]+(this[e+1]<<16|this[e+2]<<8|this[e+3])},l.prototype.readIntLE=function(e,t,n){e|=0,t|=0,n||O(e,t,this.length);for(var i=this[e],r=1,s=0;++s<t&&(r*=256);)i+=this[e+s]*r;return i>=(r*=128)&&(i-=Math.pow(2,8*t)),i},l.prototype.readIntBE=function(e,t,n){e|=0,t|=0,n||O(e,t,this.length);for(var i=t,r=1,s=this[e+--i];i>0&&(r*=256);)s+=this[e+--i]*r;return s>=(r*=128)&&(s-=Math.pow(2,8*t)),s},l.prototype.readInt8=function(e,t){return t||O(e,1,this.length),128&this[e]?-1*(255-this[e]+1):this[e]},l.prototype.readInt16LE=function(e,t){t||O(e,2,this.length);var n=this[e]|this[e+1]<<8;return 32768&n?4294901760|n:n},l.prototype.readInt16BE=function(e,t){t||O(e,2,this.length);var n=this[e+1]|this[e]<<8;return 32768&n?4294901760|n:n},l.prototype.readInt32LE=function(e,t){return t||O(e,4,this.length),this[e]|this[e+1]<<8|this[e+2]<<16|this[e+3]<<24},l.prototype.readInt32BE=function(e,t){return t||O(e,4,this.length),this[e]<<24|this[e+1]<<16|this[e+2]<<8|this[e+3]},l.prototype.readFloatLE=function(e,t){return t||O(e,4,this.length),r.read(this,e,!0,23,4)},l.prototype.readFloatBE=function(e,t){return t||O(e,4,this.length),r.read(this,e,!1,23,4)},l.prototype.readDoubleLE=function(e,t){return t||O(e,8,this.length),r.read(this,e,!0,52,8)},l.prototype.readDoubleBE=function(e,t){return t||O(e,8,this.length),r.read(this,e,!1,52,8)},l.prototype.writeUIntLE=function(e,t,n,i){(e=+e,t|=0,n|=0,i)||Q(this,e,t,n,Math.pow(2,8*n)-1,0);var r=1,s=0;for(this[t]=255&e;++s<n&&(r*=256);)this[t+s]=e/r&255;return t+n},l.prototype.writeUIntBE=function(e,t,n,i){(e=+e,t|=0,n|=0,i)||Q(this,e,t,n,Math.pow(2,8*n)-1,0);var r=n-1,s=1;for(this[t+r]=255&e;--r>=0&&(s*=256);)this[t+r]=e/s&255;return t+n},l.prototype.writeUInt8=function(e,t,n){return e=+e,t|=0,n||Q(this,e,t,1,255,0),l.TYPED_ARRAY_SUPPORT||(e=Math.floor(e)),this[t]=255&e,t+1},l.prototype.writeUInt16LE=function(e,t,n){return e=+e,t|=0,n||Q(this,e,t,2,65535,0),l.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8):N(this,e,t,!0),t+2},l.prototype.writeUInt16BE=function(e,t,n){return e=+e,t|=0,n||Q(this,e,t,2,65535,0),l.TYPED_ARRAY_SUPPORT?(this[t]=e>>>8,this[t+1]=255&e):N(this,e,t,!1),t+2},l.prototype.writeUInt32LE=function(e,t,n){return e=+e,t|=0,n||Q(this,e,t,4,4294967295,0),l.TYPED_ARRAY_SUPPORT?(this[t+3]=e>>>24,this[t+2]=e>>>16,this[t+1]=e>>>8,this[t]=255&e):D(this,e,t,!0),t+4},l.prototype.writeUInt32BE=function(e,t,n){return e=+e,t|=0,n||Q(this,e,t,4,4294967295,0),l.TYPED_ARRAY_SUPPORT?(this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e):D(this,e,t,!1),t+4},l.prototype.writeIntLE=function(e,t,n,i){if(e=+e,t|=0,!i){var r=Math.pow(2,8*n-1);Q(this,e,t,n,r-1,-r)}var s=0,o=1,a=0;for(this[t]=255&e;++s<n&&(o*=256);)e<0&&0===a&&0!==this[t+s-1]&&(a=1),this[t+s]=(e/o>>0)-a&255;return t+n},l.prototype.writeIntBE=function(e,t,n,i){if(e=+e,t|=0,!i){var r=Math.pow(2,8*n-1);Q(this,e,t,n,r-1,-r)}var s=n-1,o=1,a=0;for(this[t+s]=255&e;--s>=0&&(o*=256);)e<0&&0===a&&0!==this[t+s+1]&&(a=1),this[t+s]=(e/o>>0)-a&255;return t+n},l.prototype.writeInt8=function(e,t,n){return e=+e,t|=0,n||Q(this,e,t,1,127,-128),l.TYPED_ARRAY_SUPPORT||(e=Math.floor(e)),e<0&&(e=255+e+1),this[t]=255&e,t+1},l.prototype.writeInt16LE=function(e,t,n){return e=+e,t|=0,n||Q(this,e,t,2,32767,-32768),l.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8):N(this,e,t,!0),t+2},l.prototype.writeInt16BE=function(e,t,n){return e=+e,t|=0,n||Q(this,e,t,2,32767,-32768),l.TYPED_ARRAY_SUPPORT?(this[t]=e>>>8,this[t+1]=255&e):N(this,e,t,!1),t+2},l.prototype.writeInt32LE=function(e,t,n){return e=+e,t|=0,n||Q(this,e,t,4,2147483647,-2147483648),l.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8,this[t+2]=e>>>16,this[t+3]=e>>>24):D(this,e,t,!0),t+4},l.prototype.writeInt32BE=function(e,t,n){return e=+e,t|=0,n||Q(this,e,t,4,2147483647,-2147483648),e<0&&(e=4294967295+e+1),l.TYPED_ARRAY_SUPPORT?(this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e):D(this,e,t,!1),t+4},l.prototype.writeFloatLE=function(e,t,n){return I(this,e,t,!0,n)},l.prototype.writeFloatBE=function(e,t,n){return I(this,e,t,!1,n)},l.prototype.writeDoubleLE=function(e,t,n){return L(this,e,t,!0,n)},l.prototype.writeDoubleBE=function(e,t,n){return L(this,e,t,!1,n)},l.prototype.copy=function(e,t,n,i){if(n||(n=0),i||0===i||(i=this.length),t>=e.length&&(t=e.length),t||(t=0),i>0&&i<n&&(i=n),i===n)return 0;if(0===e.length||0===this.length)return 0;if(t<0)throw new RangeError("targetStart out of bounds");if(n<0||n>=this.length)throw new RangeError("sourceStart out of bounds");if(i<0)throw new RangeError("sourceEnd out of bounds");i>this.length&&(i=this.length),e.length-t<i-n&&(i=e.length-t+n);var r,s=i-n;if(this===e&&n<t&&t<i)for(r=s-1;r>=0;--r)e[r+t]=this[r+n];else if(s<1e3||!l.TYPED_ARRAY_SUPPORT)for(r=0;r<s;++r)e[r+t]=this[r+n];else Uint8Array.prototype.set.call(e,this.subarray(n,n+s),t);return s},l.prototype.fill=function(e,t,n,i){if("string"==typeof e){if("string"==typeof t?(i=t,t=0,n=this.length):"string"==typeof n&&(i=n,n=this.length),1===e.length){var r=e.charCodeAt(0);r<256&&(e=r)}if(void 0!==i&&"string"!=typeof i)throw new TypeError("encoding must be a string");if("string"==typeof i&&!l.isEncoding(i))throw new TypeError("Unknown encoding: "+i)}else"number"==typeof e&&(e&=255);if(t<0||this.length<t||this.length<n)throw new RangeError("Out of range index");if(n<=t)return this;var s;if(t>>>=0,n=void 0===n?this.length:n>>>0,e||(e=0),"number"==typeof e)for(s=t;s<n;++s)this[s]=e;else{var o=l.isBuffer(e)?e:U(new l(e,i).toString()),a=o.length;for(s=0;s<n-t;++s)this[s+t]=o[s%a]}return this};var F=/[^+\/0-9A-Za-z-_]/g;function B(e){return e<16?"0"+e.toString(16):e.toString(16)}function U(e,t){var n;t=t||1/0;for(var i=e.length,r=null,s=[],o=0;o<i;++o){if((n=e.charCodeAt(o))>55295&&n<57344){if(!r){if(n>56319){(t-=3)>-1&&s.push(239,191,189);continue}if(o+1===i){(t-=3)>-1&&s.push(239,191,189);continue}r=n;continue}if(n<56320){(t-=3)>-1&&s.push(239,191,189),r=n;continue}n=65536+(r-55296<<10|n-56320)}else r&&(t-=3)>-1&&s.push(239,191,189);if(r=null,n<128){if((t-=1)<0)break;s.push(n)}else if(n<2048){if((t-=2)<0)break;s.push(n>>6|192,63&n|128)}else if(n<65536){if((t-=3)<0)break;s.push(n>>12|224,n>>6&63|128,63&n|128)}else{if(!(n<1114112))throw new Error("Invalid code point");if((t-=4)<0)break;s.push(n>>18|240,n>>12&63|128,n>>6&63|128,63&n|128)}}return s}function z(e){return i.toByteArray(function(e){if((e=function(e){return e.trim?e.trim():e.replace(/^\s+|\s+$/g,"")}(e).replace(F,"")).length<2)return"";for(;e.length%4!=0;)e+="=";return e}(e))}function M(e,t,n,i){for(var r=0;r<i&&!(r+n>=t.length||r>=e.length);++r)t[r+n]=e[r];return r}}).call(this,n(3))},function(e,t,n){"use strict";t.byteLength=function(e){var t=u(e),n=t[0],i=t[1];return 3*(n+i)/4-i},t.toByteArray=function(e){var t,n,i=u(e),o=i[0],a=i[1],l=new s(function(e,t,n){return 3*(t+n)/4-n}(0,o,a)),h=0,c=a>0?o-4:o;for(n=0;n<c;n+=4)t=r[e.charCodeAt(n)]<<18|r[e.charCodeAt(n+1)]<<12|r[e.charCodeAt(n+2)]<<6|r[e.charCodeAt(n+3)],l[h++]=t>>16&255,l[h++]=t>>8&255,l[h++]=255&t;2===a&&(t=r[e.charCodeAt(n)]<<2|r[e.charCodeAt(n+1)]>>4,l[h++]=255&t);1===a&&(t=r[e.charCodeAt(n)]<<10|r[e.charCodeAt(n+1)]<<4|r[e.charCodeAt(n+2)]>>2,l[h++]=t>>8&255,l[h++]=255&t);return l},t.fromByteArray=function(e){for(var t,n=e.length,r=n%3,s=[],o=0,a=n-r;o<a;o+=16383)s.push(h(e,o,o+16383>a?a:o+16383));1===r?(t=e[n-1],s.push(i[t>>2]+i[t<<4&63]+"==")):2===r&&(t=(e[n-2]<<8)+e[n-1],s.push(i[t>>10]+i[t>>4&63]+i[t<<2&63]+"="));return s.join("")};for(var i=[],r=[],s="undefined"!=typeof Uint8Array?Uint8Array:Array,o="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",a=0,l=o.length;a<l;++a)i[a]=o[a],r[o.charCodeAt(a)]=a;function u(e){var t=e.length;if(t%4>0)throw new Error("Invalid string. Length must be a multiple of 4");var n=e.indexOf("=");return-1===n&&(n=t),[n,n===t?0:4-n%4]}function h(e,t,n){for(var r,s,o=[],a=t;a<n;a+=3)r=(e[a]<<16&16711680)+(e[a+1]<<8&65280)+(255&e[a+2]),o.push(i[(s=r)>>18&63]+i[s>>12&63]+i[s>>6&63]+i[63&s]);return o.join("")}r["-".charCodeAt(0)]=62,r["_".charCodeAt(0)]=63},function(e,t){t.read=function(e,t,n,i,r){var s,o,a=8*r-i-1,l=(1<<a)-1,u=l>>1,h=-7,c=n?r-1:0,d=n?-1:1,f=e[t+c];for(c+=d,s=f&(1<<-h)-1,f>>=-h,h+=a;h>0;s=256*s+e[t+c],c+=d,h-=8);for(o=s&(1<<-h)-1,s>>=-h,h+=i;h>0;o=256*o+e[t+c],c+=d,h-=8);if(0===s)s=1-u;else{if(s===l)return o?NaN:1/0*(f?-1:1);o+=Math.pow(2,i),s-=u}return(f?-1:1)*o*Math.pow(2,s-i)},t.write=function(e,t,n,i,r,s){var o,a,l,u=8*s-r-1,h=(1<<u)-1,c=h>>1,d=23===r?Math.pow(2,-24)-Math.pow(2,-77):0,f=i?0:s-1,p=i?1:-1,m=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(a=isNaN(t)?1:0,o=h):(o=Math.floor(Math.log(t)/Math.LN2),t*(l=Math.pow(2,-o))<1&&(o--,l*=2),(t+=o+c>=1?d/l:d*Math.pow(2,1-c))*l>=2&&(o++,l/=2),o+c>=h?(a=0,o=h):o+c>=1?(a=(t*l-1)*Math.pow(2,r),o+=c):(a=t*Math.pow(2,c-1)*Math.pow(2,r),o=0));r>=8;e[n+f]=255&a,f+=p,a/=256,r-=8);for(o=o<<r|a,u+=r;u>0;e[n+f]=255&o,f+=p,o/=256,u-=8);e[n+f-p]|=128*m}},function(e,t){var n={}.toString;e.exports=Array.isArray||function(e){return"[object Array]"==n.call(e)}},function(e,t,n){(function(e){var i=void 0!==e&&e||"undefined"!=typeof self&&self||window,r=Function.prototype.apply;function s(e,t){this._id=e,this._clearFn=t}t.setTimeout=function(){return new s(r.call(setTimeout,i,arguments),clearTimeout)},t.setInterval=function(){return new s(r.call(setInterval,i,arguments),clearInterval)},t.clearTimeout=t.clearInterval=function(e){e&&e.close()},s.prototype.unref=s.prototype.ref=function(){},s.prototype.close=function(){this._clearFn.call(i,this._id)},t.enroll=function(e,t){clearTimeout(e._idleTimeoutId),e._idleTimeout=t},t.unenroll=function(e){clearTimeout(e._idleTimeoutId),e._idleTimeout=-1},t._unrefActive=t.active=function(e){clearTimeout(e._idleTimeoutId);var t=e._idleTimeout;t>=0&&(e._idleTimeoutId=setTimeout((function(){e._onTimeout&&e._onTimeout()}),t))},n(15),t.setImmediate="undefined"!=typeof self&&self.setImmediate||void 0!==e&&e.setImmediate||this&&this.setImmediate,t.clearImmediate="undefined"!=typeof self&&self.clearImmediate||void 0!==e&&e.clearImmediate||this&&this.clearImmediate}).call(this,n(3))},function(e,t,n){(function(e,t){!function(e,n){"use strict";if(!e.setImmediate){var i,r,s,o,a,l=1,u={},h=!1,c=e.document,d=Object.getPrototypeOf&&Object.getPrototypeOf(e);d=d&&d.setTimeout?d:e,"[object process]"==={}.toString.call(e.process)?i=function(e){t.nextTick((function(){p(e)}))}:!function(){if(e.postMessage&&!e.importScripts){var t=!0,n=e.onmessage;return e.onmessage=function(){t=!1},e.postMessage("","*"),e.onmessage=n,t}}()?e.MessageChannel?((s=new MessageChannel).port1.onmessage=function(e){p(e.data)},i=function(e){s.port2.postMessage(e)}):c&&"onreadystatechange"in c.createElement("script")?(r=c.documentElement,i=function(e){var t=c.createElement("script");t.onreadystatechange=function(){p(e),t.onreadystatechange=null,r.removeChild(t),t=null},r.appendChild(t)}):i=function(e){setTimeout(p,0,e)}:(o="setImmediate$"+Math.random()+"$",a=function(t){t.source===e&&"string"==typeof t.data&&0===t.data.indexOf(o)&&p(+t.data.slice(o.length))},e.addEventListener?e.addEventListener("message",a,!1):e.attachEvent("onmessage",a),i=function(t){e.postMessage(o+t,"*")}),d.setImmediate=function(e){"function"!=typeof e&&(e=new Function(""+e));for(var t=new Array(arguments.length-1),n=0;n<t.length;n++)t[n]=arguments[n+1];var r={callback:e,args:t};return u[l]=r,i(l),l++},d.clearImmediate=f}function f(e){delete u[e]}function p(e){if(h)setTimeout(p,0,e);else{var t=u[e];if(t){h=!0;try{!function(e){var t=e.callback,n=e.args;switch(n.length){case 0:t();break;case 1:t(n[0]);break;case 2:t(n[0],n[1]);break;case 3:t(n[0],n[1],n[2]);break;default:t.apply(void 0,n)}}(t)}finally{f(e),h=!1}}}}}("undefined"==typeof self?void 0===e?this:e:self)}).call(this,n(3),n(16))},function(e,t){var n,i,r=e.exports={};function s(){throw new Error("setTimeout has not been defined")}function o(){throw new Error("clearTimeout has not been defined")}function a(e){if(n===setTimeout)return setTimeout(e,0);if((n===s||!n)&&setTimeout)return n=setTimeout,setTimeout(e,0);try{return n(e,0)}catch(t){try{return n.call(null,e,0)}catch(t){return n.call(this,e,0)}}}!function(){try{n="function"==typeof setTimeout?setTimeout:s}catch(e){n=s}try{i="function"==typeof clearTimeout?clearTimeout:o}catch(e){i=o}}();var l,u=[],h=!1,c=-1;function d(){h&&l&&(h=!1,l.length?u=l.concat(u):c=-1,u.length&&f())}function f(){if(!h){var e=a(d);h=!0;for(var t=u.length;t;){for(l=u,u=[];++c<t;)l&&l[c].run();c=-1,t=u.length}l=null,h=!1,function(e){if(i===clearTimeout)return clearTimeout(e);if((i===o||!i)&&clearTimeout)return i=clearTimeout,clearTimeout(e);try{i(e)}catch(t){try{return i.call(null,e)}catch(t){return i.call(this,e)}}}(e)}}function p(e,t){this.fun=e,this.array=t}function m(){}r.nextTick=function(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];u.push(new p(e,t)),1!==u.length||h||a(f)},p.prototype.run=function(){this.fun.apply(null,this.array)},r.title="browser",r.browser=!0,r.env={},r.argv=[],r.version="",r.versions={},r.on=m,r.addListener=m,r.once=m,r.off=m,r.removeListener=m,r.removeAllListeners=m,r.emit=m,r.prependListener=m,r.prependOnceListener=m,r.listeners=function(e){return[]},r.binding=function(e){throw new Error("process.binding is not supported")},r.cwd=function(){return"/"},r.chdir=function(e){throw new Error("process.chdir is not supported")},r.umask=function(){return 0}},function(e,t,n){"use strict";n(18);var i=n(2),r=n(0),s=n(1);r.a.tables={};var o={};let a=[];class l{constructor(e,t){if(!(e instanceof Array)||e.length<1||!Object.keys(e[0]).length)return r.a.debug.error("Invalid format for table when creating new table");this.id=t||"unnamed",this.table=e;for(let t in e[0])t.match(/^item$/i)&&(this.item=t),t.match(/^(group|list)$/i)&&(this.group=t),t.match(/^label$/i)&&(this.label=t)}setItem(e){return this.table[0].hasOwnProperty(e)?this.item=e:r.a.debug.warning("Error when setting table's item column: no column found with the name "+e),this}setGroup(e){return this.table[0].hasOwnProperty(e)?this.group=e:r.a.debug.warning("Error when setting table's group column: no column found with the name "+e),this}setLabel(e){return this.table[0].hasOwnProperty(e)?this.label=e:r.a.debug.warning("Error when setting table's label column: no column found with the name "+e),this}filter(...e){if(2==e.length&&"string"==typeof e[0]&&("string"==typeof e[1]||e[1]instanceof RegExp)){if(this.table[0].hasOwnProperty(e[0])){let t=e[1];"string"==typeof t&&(t=new RegExp("^"+t+"$"));let n=[];for(let i=0;i<this.table.length;i++)this.table[i][e[0]].match(t)&&n.push(this.table[i]);return n.length||r.a.debug.error("Empty table with filter:",e[0],e[1]),n=new l(n,this.id),this.group&&n.setGroup(this.group),this.label&&n.setLabel(this.label),n}return r.a.debug.error("No column named ‘"+e[0]+"’ found in the table for filtering")}if(e.length&&e[0]instanceof Function){let t=[];for(let n=0;n<this.table.length;n++)e[0].call(this,this.table[n])&&t.push(this.table[n]);return t.length||r.a.debug.error("Empty table after filter:",e[0]),new l(t,this.id).setGroup(this.group).setLabel(this.label)}}}class u{constructor(e){this.name=e,this.actions=[]}setItem(e){return this.actions.push(["setItem",e]),this}setGroup(e){return this.actions.push(["setGroup",e]),this}setLabel(e){return this.actions.push(["setLabel",e]),this}filter(...e){let t=new u(this.name);for(let e=0;e<this.actions.length;e++)t.actions.push(this.actions[e]);return t.actions.push(["filter",e]),t}setItemColumn(e){return this.setItem(e)}setGroupColumn(e){return this.setGroup(e)}setLabelColumn(e){return this.setLabel(e)}}function h(e){65279===e.charCodeAt(0)&&(e=e.slice(1)),e.match(/[\n\r]$/)||(e+="\n");let t=[],n=[];try{let n=$.csv.toArrays(e,{separator:","}),i=n[0];for(let e=1;e<n.length;e++){let r={};i.map((t,i)=>r[t]=n[e][i]),t.push(r)}}catch(e){t.push({})}try{let t=$.csv.toArrays(e,{separator:"\t"}),i=t[0];for(let e=1;e<t.length;e++){let r={};i.map((n,i)=>r[n]=t[e][i]),n.push(r)}}catch(e){n.push({})}return Object.keys(t[0]).length>Object.keys(n[0]).length?t:Object.keys(n[0]).length?n:r.a.debug.error("Format of table is invalid")}let c=[],d=window.$.ajax;window.$.ajax=function(...e){if(e[0]&&e[0].url&&e[0].url.match(/allchunks=1$/)){let t=e[0].success;e[0].success=e=>{if(0==c.length)return t(e);let n,r=[];for(let s=c.length-1;s>=0;s--)n=s==c.length-1?n=>{i.b.AddTable(c[s].name,n),t(e)}:e=>{i.b.AddTable(c[s].name,e),r[0]()},r.push(()=>$.ajax({url:c[s].table,cache:!1,dataType:"text",success:n}));r[0]()}}return d(...e)},i.b.AddTable=function(e,t){if("string"!=typeof e||"string"!=typeof t)return r.a.debug.error("Table "+e+" not added: tables and table names should be strings");if(r.a.tables.hasOwnProperty(e)&&r.a.debug.warning("A table named "+e+" already exists; overriding it"),t.match(/^http/))c.push({name:e,table:t});else{if(!(t=h(t)))return r.a.debug.error("Table "+e+" does not have the right format.");t=new l(t,e),r.a.tables[e]=t}},i.b.GetTable=function(e){return new u(e)};let f,p=[];i.b.Template=function(e,t){if(window.items)for(let e in window.items)r.a.tmpItems.indexOf(window.items[e])<0&&r.a.tmpItems.push(window.items[e]);let n={PennTemplate:[]};return r.a.tmpItems.push(n),p.push((function(){let i,h=r.a.tmpItems.length;if(e instanceof Function){t=e;let n=Object.keys(r.a.tables);if(!(n.length&&r.a.tables[n[0]]instanceof l))return r.a.debug.error("No valid table detected");i=r.a.tables[n[0]]}else if("string"==typeof e){if(!r.a.tables.hasOwnProperty(e)){let t=Object.keys(r.a.tables),n="";for(let i=0;i<t.length;i++)Object(s.e)(e,t[i])/t[i].length<.5&&(n=" Did you mean to type &lsquo;<strong>"+t[i]+"</strong>&rsquo;?");return r.a.debug.error("No table found with name "+e+"."+n)}if(!(r.a.tables[e]instanceof l))return r.a.debug.error("Table "+e+" does not have the right format.");i=r.a.tables[e]}else{if(!(e instanceof u))return r.a.debug.error("Bad format for Template's first argument (should be a PennController table, table name or function from rows to Ibex elements)");if(Object.keys(r.a.tables).length<1)return r.a.debug.error("No table was defined");if(e.name==o)i=r.a.tables[Object.keys(r.a.tables)[0]];else{if(!e.name||!r.a.tables.hasOwnProperty(e.name)){let t=Object.keys(r.a.tables),n="";for(let i=0;i<t.length;i++)Object(s.e)(e.name,t[i])/t[i].length<.5&&(n=" Did you mean to type &lsquo;</strong>"+t[i]+"</strong>&rsquo;?");return r.a.debug.error("No table named "+e.name+" was found."+n)}i=r.a.tables[e.name]}for(let t=0;t<e.actions.length;t++){let n=e.actions[t][1];switch(e.actions[t][0]){case"setItem":i.setItem(n);break;case"setLabel":i.setLabel(n);break;case"setGroup":i.setGroup(n);break;case"filter":i=i.filter(...n)}}}if(!(t instanceof Function))return r.a.debug.error("The function passed to PennController.Template is ill-defined");let c,d=[];if(i.group){for(let e=0;e<i.table.length;e++)d.indexOf(i.table[e][i.group])<0&&d.push(i.table[e][i.group]);if(d.sort(),a.map(e=>{let t=d.filter((t,n)=>t==e.groups[n]);d.indexOf(e.runningGroup)>-1&&t.length==e.groups.length&&t.length==d.length&&(c=e.runningGroup)}),void 0===c){let e=window.__counter_value_from_server__;"number"==typeof window.counterOverride&&(e=counterOverride),c=d[e%d.length]}a.push({runningGroup:c,groups:d})}let f=[];for(let e=0;e<i.table.length;e++){if(i.group){if(i.table[e][i.group]!=c)continue}let n,o=void 0,a=new Proxy(i.table[e],{get:(t,n)=>{if(n in i.table[e])return t[n];{let t=Object.keys(i.table[e]),o="";for(let e=0;e<t.length;e++)Object(s.e)(n,t[e])/t[e].length<.5&&(o=" Did you mean to type &lsquo;<strong>"+t[e]+"</strong>&rsquo;?");r.a.debug.error("No column named &lsquo;"+n+"&rsquo; found in table "+i.id+"."+o)}return""}});try{n=t.call(null,a)}catch(e){window.onerror(e.name+": "+e.message,"include=data","inside PennController.Template")}n instanceof Array?n.length%2&&"string"==typeof n[0]&&(o=n[0],n.splice(0,1)):(o=n.useLabel,n.addToItems=!1,n=["PennController",n]),o||(o=i.label&&i.table[e].hasOwnProperty(i.label)?i.table[e][i.label]:i.item&&i.table[e].hasOwnProperty(i.item)?"Item-"+i.table[e][i.item]:"Item-"+e);let l=[o];for(let t in n)n[t]instanceof Object&&(n[t]._PennController={table:i,row:e}),l.push(n[t]);f.push(l)}for(n.PennTemplate=f;r.a.tmpItems.length>h;)r.a.tmpItems.pop()})),window.items||(window.items=[]),{log:()=>r.a.debug.error("Tried to call <tt>.log</tt> command on <tt>Template()</tt>; <tt>.log</tt> commands should be called on <tt>newTrial()</tt>"),label:()=>r.a.debug.error("Tried to call <tt>.label</tt> command on <tt>Template()</tt>; <tt>.label</tt> commands should be called on <tt>newTrial()</tt>"),setOption:()=>r.a.debug.error("Tried to call <tt>.setOption</tt> command on <tt>Template()</tt>; <tt>.setOption</tt> commands should be called on <tt>newTrial()</tt>"),noHeader:()=>r.a.debug.error("Tried to call <tt>.noHeader</tt> command on <tt>Template()</tt>; <tt>.noHeader</tt> commands should be called on <tt>newTrial()</tt>"),noFooter:()=>r.a.debug.error("Tried to call <tt>.noFooter</tt> command on <tt>Template()</tt>; <tt>.noFooter</tt> commands should be called on <tt>newTrial()</tt>"),noTrialLog:()=>r.a.debug.error("Tried to call <tt>.noTrialLog</tt> command on <tt>Template()</tt>; <tt>.noTrialLog</tt> commands should be called on <tt>newTrial()</tt>")}},i.b.FeedItems=(e,t)=>i.b.Template(e,t),$(document).ready((function(){f=document.createElement("P"),f.style["text-align"]="center",f.innerHTML="Loading, please wait...",f.id="FirstLoadingMessage",document.body.appendChild(f)})),r.a.Prerun(()=>{for(let e in window.CHUNKS_DICT){if(e.match(/\.(html?|mp3)$/i))continue;let t=h(window.CHUNKS_DICT[e]);t?(t=new l(t,e),r.a.tables[e]=t):(t=$.csv.toObjects(window.CHUNKS_DICT[e],{separator:"\t"}),Object.keys(t[0]).length>1&&(t=new l(t,e),r.a.tables[e]=t))}for(let e=0;e<p.length;e++)p[e].call();f&&document.body.removeChild(f)}),Object.defineProperty(i.b,"defaultTable",{get:function(){let e=new u;return e.name=o,e}})},function(e,t,n){RegExp.escape=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")},function(){"use strict";var t;(t="undefined"!=typeof jQuery&&jQuery?jQuery:{}).csv={defaults:{separator:",",delimiter:'"',headers:!0},hooks:{castToScalar:function(e,t){if(isNaN(e))return e;if(/\./.test(e))return parseFloat(e);var n=parseInt(e);return isNaN(n)?null:n}},parsers:{parse:function(e,t){var n=t.separator,i=t.delimiter;t.state.rowNum||(t.state.rowNum=1),t.state.colNum||(t.state.colNum=1);var r=[],s=[],o=0,a="",l=!1;function u(){if(o=0,a="",t.start&&t.state.rowNum<t.start)return s=[],t.state.rowNum++,void(t.state.colNum=1);if(void 0===t.onParseEntry)r.push(s);else{var e=t.onParseEntry(s,t.state);!1!==e&&r.push(e)}s=[],t.end&&t.state.rowNum>=t.end&&(l=!0),t.state.rowNum++,t.state.colNum=1}function h(){if(void 0===t.onParseValue)s.push(a);else{var e=t.onParseValue(a,t.state);!1!==e&&s.push(e)}a="",o=0,t.state.colNum++}var c=RegExp.escape(n),d=RegExp.escape(i),f=/(D|S|\r\n|\n|\r|[^DS\r\n]+)/,p=f.source;return p=(p=p.replace(/S/g,c)).replace(/D/g,d),f=new RegExp(p,"gm"),e.replace(f,(function(e){if(!l)switch(o){case 0:if(e===n){a+="",h();break}if(e===i){o=1;break}if(/^(\r\n|\n|\r)$/.test(e)){h(),u();break}a+=e,o=3;break;case 1:if(e===i){o=2;break}a+=e,o=1;break;case 2:if(e===i){a+=e,o=1;break}if(e===n){h();break}if(/^(\r\n|\n|\r)$/.test(e)){h(),u();break}throw new Error("CSVDataError: Illegal State [Row:"+t.state.rowNum+"][Col:"+t.state.colNum+"]");case 3:if(e===n){h();break}if(/^(\r\n|\n|\r)$/.test(e)){h(),u();break}if(e===i)throw new Error("CSVDataError: Illegal Quote [Row:"+t.state.rowNum+"][Col:"+t.state.colNum+"]");throw new Error("CSVDataError: Illegal Data [Row:"+t.state.rowNum+"][Col:"+t.state.colNum+"]");default:throw new Error("CSVDataError: Unknown State [Row:"+t.state.rowNum+"][Col:"+t.state.colNum+"]")}})),0!==s.length&&(h(),u()),r},splitLines:function(e,n){if(e){var i=(n=n||{}).separator||t.csv.defaults.separator,r=n.delimiter||t.csv.defaults.delimiter;n.state=n.state||{},n.state.rowNum||(n.state.rowNum=1);var s=[],o=0,a="",l=!1,u=RegExp.escape(i),h=RegExp.escape(r),c=/(D|S|\n|\r|[^DS\r\n]+)/,d=c.source;return d=(d=d.replace(/S/g,u)).replace(/D/g,h),c=new RegExp(d,"gm"),e.replace(c,(function(e){if(!l)switch(o){case 0:if(e===i){a+=e,o=0;break}if(e===r){a+=e,o=1;break}if("\n"===e){f();break}if(/^\r$/.test(e))break;a+=e,o=3;break;case 1:if(e===r){a+=e,o=2;break}a+=e,o=1;break;case 2:var t=a.substr(a.length-1);if(e===r&&t===r){a+=e,o=1;break}if(e===i){a+=e,o=0;break}if("\n"===e){f();break}if("\r"===e)break;throw new Error("CSVDataError: Illegal state [Row:"+n.state.rowNum+"]");case 3:if(e===i){a+=e,o=0;break}if("\n"===e){f();break}if("\r"===e)break;if(e===r)throw new Error("CSVDataError: Illegal quote [Row:"+n.state.rowNum+"]");throw new Error("CSVDataError: Illegal state [Row:"+n.state.rowNum+"]");default:throw new Error("CSVDataError: Unknown state [Row:"+n.state.rowNum+"]")}})),""!==a&&f(),s}function f(){if(o=0,n.start&&n.state.rowNum<n.start)return a="",void n.state.rowNum++;if(void 0===n.onParseEntry)s.push(a);else{var e=n.onParseEntry(a,n.state);!1!==e&&s.push(e)}a="",n.end&&n.state.rowNum>=n.end&&(l=!0),n.state.rowNum++}},parseEntry:function(e,t){var n=t.separator,i=t.delimiter;t.state.rowNum||(t.state.rowNum=1),t.state.colNum||(t.state.colNum=1);var r=[],s=0,o="";function a(){if(void 0===t.onParseValue)r.push(o);else{var e=t.onParseValue(o,t.state);!1!==e&&r.push(e)}o="",s=0,t.state.colNum++}if(!t.match){var l=RegExp.escape(n),u=RegExp.escape(i),h=/(D|S|\n|\r|[^DS\r\n]+)/.source;h=(h=h.replace(/S/g,l)).replace(/D/g,u),t.match=new RegExp(h,"gm")}return e.replace(t.match,(function(e){switch(s){case 0:if(e===n){o+="",a();break}if(e===i){s=1;break}if("\n"===e||"\r"===e)break;o+=e,s=3;break;case 1:if(e===i){s=2;break}o+=e,s=1;break;case 2:if(e===i){o+=e,s=1;break}if(e===n){a();break}if("\n"===e||"\r"===e)break;throw new Error("CSVDataError: Illegal State [Row:"+t.state.rowNum+"][Col:"+t.state.colNum+"]");case 3:if(e===n){a();break}if("\n"===e||"\r"===e)break;if(e===i)throw new Error("CSVDataError: Illegal Quote [Row:"+t.state.rowNum+"][Col:"+t.state.colNum+"]");throw new Error("CSVDataError: Illegal Data [Row:"+t.state.rowNum+"][Col:"+t.state.colNum+"]");default:throw new Error("CSVDataError: Unknown State [Row:"+t.state.rowNum+"][Col:"+t.state.colNum+"]")}})),a(),r}},helpers:{collectPropertyNames:function(e){var t=[],n=[],i=[];for(t in e)for(n in e[t])e[t].hasOwnProperty(n)&&i.indexOf(n)<0&&"function"!=typeof e[t][n]&&i.push(n);return i}},toArray:function(e,n,i){n=void 0!==n?n:{};var r={};r.callback=void 0!==i&&"function"==typeof i&&i,r.separator="separator"in n?n.separator:t.csv.defaults.separator,r.delimiter="delimiter"in n?n.delimiter:t.csv.defaults.delimiter;var s=void 0!==n.state?n.state:{};n={delimiter:r.delimiter,separator:r.separator,onParseEntry:n.onParseEntry,onParseValue:n.onParseValue,state:s};var o=t.csv.parsers.parseEntry(e,n);if(!r.callback)return o;r.callback("",o)},toArrays:function(e,n,i){n=void 0!==n?n:{};var r={};r.callback=void 0!==i&&"function"==typeof i&&i,r.separator="separator"in n?n.separator:t.csv.defaults.separator,r.delimiter="delimiter"in n?n.delimiter:t.csv.defaults.delimiter;var s;if(void 0!==(n={delimiter:r.delimiter,separator:r.separator,onPreParse:n.onPreParse,onParseEntry:n.onParseEntry,onParseValue:n.onParseValue,onPostParse:n.onPostParse,start:n.start,end:n.end,state:{rowNum:1,colNum:1}}).onPreParse&&n.onPreParse(e,n.state),s=t.csv.parsers.parse(e,n),void 0!==n.onPostParse&&n.onPostParse(s,n.state),!r.callback)return s;r.callback("",s)},toObjects:function(e,n,i){n=void 0!==n?n:{};var r={};r.callback=void 0!==i&&"function"==typeof i&&i,r.separator="separator"in n?n.separator:t.csv.defaults.separator,r.delimiter="delimiter"in n?n.delimiter:t.csv.defaults.delimiter,r.headers="headers"in n?n.headers:t.csv.defaults.headers,n.start="start"in n?n.start:1,r.headers&&n.start++,n.end&&r.headers&&n.end++;var s,o=[];n={delimiter:r.delimiter,separator:r.separator,onPreParse:n.onPreParse,onParseEntry:n.onParseEntry,onParseValue:n.onParseValue,onPostParse:n.onPostParse,start:n.start,end:n.end,state:{rowNum:1,colNum:1},match:!1,transform:n.transform};var a={delimiter:r.delimiter,separator:r.separator,start:1,end:1,state:{rowNum:1,colNum:1}};void 0!==n.onPreParse&&n.onPreParse(e,n.state);var l=t.csv.parsers.splitLines(e,a),u=t.csv.toArray(l[0],n);s=t.csv.parsers.splitLines(e,n),n.state.colNum=1,n.state.rowNum=u?2:1;for(var h=0,c=s.length;h<c;h++){for(var d=t.csv.toArray(s[h],n),f={},p=0;p<u.length;p++)f[u[p]]=d[p];void 0!==n.transform?o.push(n.transform.call(void 0,f)):o.push(f),n.state.rowNum++}if(void 0!==n.onPostParse&&n.onPostParse(o,n.state),!r.callback)return o;r.callback("",o)},fromArrays:function(e,n,i){n=void 0!==n?n:{};var r={};r.callback=void 0!==i&&"function"==typeof i&&i,r.separator="separator"in n?n.separator:t.csv.defaults.separator,r.delimiter="delimiter"in n?n.delimiter:t.csv.defaults.delimiter;var s,o,a,l,u="";for(a=0;a<e.length;a++){for(s=e[a],o=[],l=0;l<s.length;l++){var h=void 0===s[l]||null===s[l]?"":s[l].toString();h.indexOf(r.delimiter)>-1&&(h=h.replace(new RegExp(r.delimiter,"g"),r.delimiter+r.delimiter));var c="\n|\r|S|D";c=(c=c.replace("S",r.separator)).replace("D",r.delimiter),h.search(c)>-1&&(h=r.delimiter+h+r.delimiter),o.push(h)}u+=o.join(r.separator)+"\n"}if(!r.callback)return u;r.callback("",u)},fromObjects:function(e,n,i){n=void 0!==n?n:{};var r={};if(r.callback=void 0!==i&&"function"==typeof i&&i,r.separator="separator"in n?n.separator:t.csv.defaults.separator,r.delimiter="delimiter"in n?n.delimiter:t.csv.defaults.delimiter,r.headers="headers"in n?n.headers:t.csv.defaults.headers,r.sortOrder="sortOrder"in n?n.sortOrder:"declare",r.manualOrder="manualOrder"in n?n.manualOrder:[],r.transform=n.transform,"string"==typeof r.manualOrder&&(r.manualOrder=t.csv.toArray(r.manualOrder,r)),void 0!==r.transform){var s,o=e;for(e=[],s=0;s<o.length;s++)e.push(r.transform.call(void 0,o[s]))}var a,l,u,h,c=t.csv.helpers.collectPropertyNames(e);if("alpha"===r.sortOrder&&c.sort(),r.manualOrder.length>0){var d=[].concat(r.manualOrder);let e;for(e=0;e<c.length;e++)d.indexOf(c[e])<0&&d.push(c[e]);c=d}for(r.headers&&(void 0).push(c),a=0;a<e.length;a++){for(u=[],l=0;l<c.length;l++)(h=c[l])in e[a]&&"function"!=typeof e[a][h]?u.push(e[a][h]):u.push("");(void 0).push(u)}return t.csv.fromArrays(void 0,n,r.callback)}},t.csvEntry2Array=t.csv.toArray,t.csv2Array=t.csv.toArrays,t.csv2Dictionary=t.csv.toObjects,e.exports&&(e.exports=t.csv)}.call(this)},function(e,t){let n=(e,t)=>{let n=Object.getOwnPropertyDescriptors(t);for(let t in n){let i=n[t];i.value instanceof Function?e[t]=i.value:i.get instanceof Function&&Object.defineProperty(e,t,i)}};window.PennController.ResetPrefix=function(e){if("string"==typeof e){if(window[e])throw"ERROR: prefix string already used for another JS object";window[e]={};var t=window[e]}else t=window;n(t,window.PennController.Elements),n(t,window.PennController)}},function(e,t,n){"use strict";var i=n(0),r=n(2);i.a.Prerun(()=>{let e=[];function t(t){return t instanceof r.a?e.indexOf(t)<0&&t.addToItems?[t.useLabel||"unlabeled","PennController",t]:null:t}if(window.items instanceof Array)for(let t=0;t<window.items.length;t++)if(window.items[t]instanceof Array&&window.items[t].length>2)for(let n=2;n<window.items[t].length;n+=2)e.push(window.items[t][n]);let n=[];for(let r=0;r<i.a.tmpItems.length;r++){let s=i.a.tmpItems[r],o=[];if(s instanceof Object&&s.hasOwnProperty("PennTemplate"))for(let e=0;e<s.PennTemplate.length;e++)o.push(t(s.PennTemplate[e]));else o.push(t(s));for(let t=0;t<o.length;t++)if(o[t]instanceof Array&&o[t].length>2)for(let n=2;n<o[t].length;n+=2)e.push(o[t][n]);n=n.concat(o)}if(window.items instanceof Array)for(let e=0;e<window.items.length;e++)n.indexOf(window.items[e])<0&&n.push(window.items[e]);window.items=n.filter(e=>e instanceof Array&&e.length>2),window.shuffleSequence||(window.conf_shuffleSequence=window.seq(window.anyType))})},function(e,t){window.PennController._AddElementType("Audio",(function(e){this.immediate=function(t,n){"string"==typeof t&&void 0===n&&(n=t);let i=!n.match(/^http/i);this.resource=e.resources.fetch(n,(function(e){this.object=new Audio,this.object.muted=!0;let t=!1;const n=()=>{if(t=!0,this.object.buffered.length&&this.object.seekable.length){if(this.object.buffered.end(0)==this.object.seekable.end(0))return this.object.pause(),this.object.currentTime=0,this.object.muted=!1,resolved=!0,e();this.object.muted=!0,this.object.play()}return window.requestAnimationFrame(n),!0};this.object.addEventListener("progress",()=>t||n()),this.object.src=this.value,this.object.load()}),i),void 0!==t&&"string"==typeof t&&0!=t.length||(t="Audio"),this.id=t},this.uponCreation=function(e){this.resource.object.controls=!0,this.audio=this.resource.object,this.hasPlayed=!1,this.disabled=!1,this.resource.object.style=null,this.jQueryElement=$(this.audio),this.jQueryElement.removeClass(),this.jQueryDisable=null,this.playEvents=[],this.endEvents=[],this.pauseEvents=[],this.seekEvents=[],this.bufferEvents=[],this.whatToSave=[],this.resource.object.onplay=()=>{this.playEvents.push(["play",this.audio.currentTime,Date.now()])},this.resource.object.onended=()=>{this.hasPlayed=!0,this.endEvents.push(["end",this.audio.currentTime,Date.now()])},this.resource.object.onpause=()=>{this.pauseEvents.push(["pause",this.audio.currentTime,Date.now()])},this.resource.object.onseeked=()=>{this.seekEvents.push(["seek",this.audio.currentTime,Date.now()])},this.resource.object.onwaiting=()=>{this.bufferEvents.push(["buffer",this.audio.currentTime,Date.now()])},this.printDisable=e=>{void 0===e&&(e=this.disabled),(!0===e||isNaN(Number(e)))&&(e=.5),this.jQueryDisable instanceof jQuery&&this.jQueryDisable.remove(),this.jQueryDisable=$("<div>").css({position:"absolute",display:"inline-block","background-color":"gray",opacity:e,width:this.jQueryElement.width(),height:this.jQueryElement.height()}),this.jQueryElement.before(this.jQueryDisable)},e()},this.end=function(){if(this.whatToSave&&this.whatToSave.indexOf("play")>-1){this.playEvents.length||e.controllers.running.save(this.type,this.id,"play","NA","Never");for(let t in this.playEvents)e.controllers.running.save(this.type,this.id,...this.playEvents[t])}if(this.whatToSave&&this.whatToSave.indexOf("end")>-1){this.endEvents.length||e.controllers.running.save(this.type,this.id,"end","NA","Never");for(let t in this.endEvents)e.controllers.running.save(this.type,this.id,...this.endEvents[t])}if(this.whatToSave&&this.whatToSave.indexOf("pause")>-1){this.pauseEvents.length||e.controllers.running.save(this.type,this.id,"pause","NA","Never");for(let t in this.pauseEvents)e.controllers.running.save(this.type,this.id,...this.pauseEvents[t])}if(this.whatToSave&&this.whatToSave.indexOf("seek")>-1){this.seekEvents.length||e.controllers.running.save(this.type,this.id,"seek","NA","Never");for(let t in this.seekEvents)e.controllers.running.save(this.type,this.id,...this.seekEvents[t])}if(this.bufferEvents)for(let t in this.bufferEvents)e.controllers.running.save(this.type,this.id,...this.bufferEvents[t]);this.resource.object.pause(),this.resource.object.currentTime=0,this.jQueryDisable&&this.jQueryDisable.remove()},this.value=function(){return this.endEvents.length?this.endEvents[this.endEvents.length-1][2]:0},this.actions={play:function(t,n){this.hasOwnProperty("audio")&&this.audio instanceof Audio?(n&&"once"==n?this.audio.removeAttribute("loop"):n&&(this.audio.loop=!0),this.audio.play()):e.debug.error("No audio to play for element ",this.id),t()},pause:function(e){this.audio.pause(),e()},print:function(t,...n){e.elements.standardCommands.actions.print.apply(this,[()=>{(this.disabled||null!==this.disabled&&!1!==this.disabled&&!isNaN(this.disabled))&&this.printDisable(this.disabled),t()},...n])},stop:function(e){this.audio.currentTime=this.audio.duration,e()},wait:function(e,t){if("first"==t&&this.hasPlayed)e();else{let n=!1,i=this.audio.onended;this.audio.onended=function(...r){if(i.apply(this,r),!n)if(t instanceof Object&&t._runPromises&&t.success){let i=this.disabled;this.disabled="tmp",t._runPromises().then(t=>{"success"==t&&(n=!0,e()),"tmp"==this.disabled&&(this.disabled=i)})}else n=!0,e()}}}},this.settings={disable:function(e,t){this.jQueryElement.addClass("PennController-disabled"),this.jQueryContainer.addClass("PennController-disabled"),t=!(!isNaN(t)&&null!==t)||Number(t),this.disabled=t,this.printDisable(t),e()},enable:function(e){this.jQueryDisable instanceof jQuery&&(this.disabled=!1,this.jQueryDisable.remove(),this.jQueryDisable=null,this.jQueryElement.removeClass("PennController-disabled"),this.jQueryContainer.removeClass("PennController-disabled"),this.jQueryElement.attr("controls",!0)),e()},once:function(e){if(this.hasPlayed)this.disabled=!0,this.printDisable();else{let e=this.audio.onended,t=this;this.audio.onended=function(...n){e.apply(this,n),t.disabled=!0,t.printDisable()}}e()},log:function(e,...t){1==t.length&&"string"==typeof t[0]?this.whatToSave.push(t[0]):t.length>1?this.whatToSave=this.whatToSave.concat(t):this.whatToSave=["play","end","pause","seek"],e()}},this.test={hasPlayed:function(){return this.hasPlayed},playing:function(){return this.audio.currentTime&&!this.audio.paused}}}))},function(e,t){window.PennController._AddElementType("Button",(function(e){this.immediate=function(e,t){void 0===t&&(t=e,void 0!==e&&"string"==typeof e&&0!=e.length||(e="Button"),this.id=e),this.initialText=t},this.uponCreation=function(e){this.text=this.initialText,this.jQueryElement=$("<button>").html(this.text),this.clicks=[],this.hasClicked=!1,this.log=!1,this.disabled=!1,this.click=()=>{this.hasClicked=!0,this.clicks.push(["Click","Click",Date.now(),"NULL"])},this.jQueryElement[0].onclick=()=>this.click(),e()},this.end=function(){if(this.log){this.clicks.length||e.controllers.running.save(this.type,this.id,"Click","NA","Never");for(let t in this.clicks)e.controllers.running.save(this.type,this.id,...this.clicks[t])}},this.value=function(){return this.clicks.length?this.clicks[this.clicks.length-1][2]:0},this.actions={click:function(e){this.click(),e()},wait:function(e,t){if("first"==t&&this.hasClicked)e();else{let n=!1,i=this.click;this.click=()=>{if(i.apply(this),!n)if(t instanceof Object&&t._runPromises&&t.success){let i=this.disabled;this.jQueryElement.attr("disabled",!0),this.disabled="tmp",t._runPromises().then(t=>{"success"==t&&(n=!0,e()),"tmp"==this.disabled&&(this.disabled=i,this.jQueryElement.attr("disabled",i))})}else n=!0,e()}}}},this.settings={callback:function(e,...t){let n=this.click;this.click=async function(){if(!this.disabled)for(let e in t)await t[e]._runPromises();n.apply(this)},e()},log:function(e){this.log=!0,e()},once:function(e){if(this.hasClicked)this.disabled=!0,this.jQueryElement.attr("disabled",!0);else{let e=this.click;this.click=()=>{e.apply(this),this.disabled=!0,this.jQueryElement.attr("disabled",!0)}}e()}},this.test={clicked:function(){return this.hasClicked}}}))},function(e,t){window.PennController._AddElementType("Canvas",(function(e){let t=e=>e.match(/^\s*\d+(\.\d+)?(px|pt|pc|vw|vh|em|ex|ch|rem|cm|mm|in|vmin|vmax|[%])?\s*?/);this.immediate=function(n,i,r){if(void 0===n)n="Canvas",this.id=n;else if(void 0===r&&t(String(n))&&t(String(i))){r=i,i=n,n="Canvas";let t=e.controllers.underConstruction;e.controllers.running&&(t=e.controllers.list[e.controllers.running.id]);let s=2;for(;t.elements.hasOwnProperty("Canvas")&&t.elements.Canvas.hasOwnProperty(n);)n+=String(s);this.id=n}this.width=i,this.height=r},this.uponCreation=function(t){this.jQueryElement=$("<div>").css({width:this.width,height:this.height,overflow:"visible",position:"relative",display:"flex","flex-direction":"column"}),this.elementCommands=[],this.showElement=(t,n,i,r)=>new Promise(async s=>{await t.print(this.jQueryElement)._runPromises();let o=t._element,a=o.jQueryElement;const l=e.controllers.running,u=[n,i,window.PennController.Elements.getCanvas(this.id)];o._lastPrint=u,o.jQueryContainer?(e.utils.printAndRefreshUntil.call(o.jQueryContainer,n,i,this.jQueryElement,()=>l!=e.controllers.running||u!=o._lastPrint),(Number(r)>0||Number(r)>0)&&o.jQueryContainer.css("z-index",r)):(e.utils.printAndRefreshUntil.call(a,n,i,this.jQueryElement,()=>l!=e.controllers.running||u!=o._lastPrint),(Number(r)>0||Number(r)>0)&&a.css("z-index",r)),s()}),t()},this.end=function(){this.log&&(this.printTime?e.controllers.running.save(this.type,this.id,"Print","NA",this.printTime,"NULL"):e.controllers.running.save(this.type,this.id,"Print","NA","Never","NULL"))},this.value=function(){return this.elementCommands.length};let n=this;this.actions={color:function(e,t){this.jQueryElement.css("background-color",t),e()},print:async function(t,...n){e.elements.standardCommands.actions.print.apply(this,[async()=>{for(let e in this.elementCommands)await this.showElement(...this.elementCommands[e]);t()},...n])},remove:async function(t,...i){i.length?n.settings.remove.call(this,t,...i):e.elements.standardCommands.actions.remove.call(this,t)}},this.settings={add:function(t,n,i,r,s){r.hasOwnProperty("_element")&&r._element.jQueryElement instanceof jQuery?(this.elementCommands.push([r,n,i,s]),this.jQueryElement.parent().length?this.showElement(r,n,i,s).then(t):t()):(e.debug.error("Invalid element referenced to add to Canvas "+this.id),t())},remove:async function(t,n){if(n.hasOwnProperty("_element")){let t=this.elementCommands.map(e=>e[0]._element).indexOf(n._element);t>-1?(this.elementCommands.splice(t,1),await n.remove()._runPromises()):e.debug.error("Element referenced to remove from canvas not found in Canvas "+this.id)}else e.debug.error("Invalid element referenced to remove from Canvas "+this.id);t()}}}))},function(e,t){window.PennController._AddElementType("Controller",(function(e){this.immediate=function(e,t,n){void 0===n&&("string"==typeof t?n={}:(n=t||{},t=e)),this.id=e,this.controller=t,this.options=n},this.uponCreation=function(t){this.jQueryElement=$("<div>"),this.log=!1,this.results=[],this.finishedCallback=()=>this.done=!0;let n=this;this.options._finishedCallback=function(e){n.done||(n.results.push([Date.now(),e]),addSafeBindMethodPair("PennController"),n.finishedCallback(),this.destroy())},this.options._cssPrefix=this.controller+"-",this.options._utils=e.controllers.running.utils,this.options._utilsClass=e.controllers.running.options._utilsClass,this.options._controllerDefaults=e.controllers.running.options._controllerDefaults;let i=Object.getOwnPropertyNames($.ui).filter(e=>$.ui[e]instanceof Function&&$.ui[e]._ibex_options);if(i.indexOf(this.controller)>=0);else{let t={score:1,controllerName:""};for(let n=0;n<i.length;n++){let r=e.utils.levensthein(this.controller,i[n])/this.controller.length;r<t.score&&(t.score=r,t.controllerName=i[n])}t.score<.5&&(add=" Did you mean to type <strong>"+t.controllerName+"</strong>?"),e.debug.error("Controller &lsquo;"+this.controller+"&rsquo; not found."+add)}t()},this.end=function(){if(this.log)for(let t=0;t<this.results.length;t++){let n=this.results[t][0],i=this.results[t][1];for(let t=0;t<i.length;t++){let r=i[t],s="Controller-"+this.controller,o=this.id,a="NULL",l="NULL";r.length>0&&(a=r[0][1]),r.length>1&&(l=r[1][1]);for(let t=2;t<r.length;t++)e.controllers.running.controller.appendResultLine.push([r[t][0],r[t][1]]);e.controllers.running.save(s,o,a,l,n,"Any addtional parameters were appended as additional columns");for(let t=2;t<r.length;t++)e.controllers.running.controller.appendResultLine.pop()}}},this.value=function(){return this.controller},this.actions={callback:function(e,...t){const n=this.finishedCallback;this.finishedCallback=function(...e){n.call(this,e),t.forEach(async e=>{e.hasProperty("_runPromises")&&e._runPromises instanceof Function?await e._runPromises():e instanceof Function&&await e.call(this)})},e()},print:function(t,...n){this.done=!1;e.elements.standardCommands.actions.print.call(this,()=>{this.jQueryElement[this.controller]("destroy"),addSafeBindMethodPair(this.controller),this.jQueryElement.empty(),this.jQueryElement[this.controller](this.options),t()},...n)},wait:function(e,t){if("first"==t&&this.done)e();else{let n=!1,i=this.finishedCallback;this.finishedCallback=()=>{i.apply(this),n||(t instanceof Object&&t._runPromises&&t.success?t._runPromises().then(t=>{"success"==t&&(n=!0,e())}):(n=!0,e()))}}}}}))},function(e,t){(()=>{let e,t;PennController._AddElementType("DragDrop",(function(n){this.immediate=function(n,...i){this._initParameters=i,this.drop=(n,i,r=!0)=>{if(this.disabled)return;const s=this._drops[i].pointer._element.jQueryElement,o=this._drags[n].pointer._element.jQueryElement,a=this._drops[i].indicesDrag;let l=null;this._drags[n].indexDrop>=0&&(l=this._drops[this._drags[n].indexDrop]);let u=this._drops[i].swap;void 0===u&&(u=this._swap),u&&a.length>=0&&(a.forEach(i=>{const r=this._drags[i].pointer._element.jQueryElement;r.appendTo(o.parent()),e<0?r.css({position:o.css("position"),top:o.css("top"),left:o.css("left")}):r.css({position:t.old_position,top:t.old_top,left:t.old_left}),l?(l.indicesDrag=l.indicesDrag.filter(e=>e!=n),l.indicesDrag.push(i)):r.css({top:0,left:0}),this._drags[i].indexDrop=this._drags[n].indexDrop}),this._drops[i].indicesDrag=[]);const h=this._drops[i].offset;if(h.length>1&&("unset"!=h[0]||"unset"!=h[1]))o.css({position:"absolute",top:h[1],left:h[0]});else{const e=o[0].getBoundingClientRect(),t=this._drops[i].pointer._element.jQueryElement[0].getBoundingClientRect();o.css({position:"absolute",top:e.top-t.top,left:e.left-t.left})}if(o.appendTo(s),r&&(this._events[this._events.length-1][2]=Date.now(),this._events[this._events.length-1][3]=this._drops[i].pointer._element.id),this._drags[n].indexDrop>=0){const e=this._drops[this._drags[n].indexDrop];e.indicesDrag=e.indicesDrag.filter(e=>e!=n)}this._drags[n].indexDrop=i,this._drops[i].indicesDrag.push(n),r&&(this._callbacks.forEach(async e=>{for(let t=0;t<e.length;t++)e[t]instanceof Function?await e.call(this):e[t]._runPromises instanceof Function&&await e[t]._runPromises()}),this._waits=this._waits.filter(e=>e.call()))},this._mousedown=n=>{if(!this.disabled)for(let i=0;i<this._drags.length;i++){const r=this._drags[i].pointer;if(void 0===r._runPromises||void 0===r._element)return;const s=r._element;if(!(s.jQueryElement instanceof jQuery))return;if(s.jQueryElement[0]===n.target){e=i;const r=n.target.getBoundingClientRect();t={x:n.clientX,y:n.clientY,top:r.top,left:r.left,old_top:n.target.style.top,old_left:n.target.style.left,old_position:n.target.style.position},$(n.target).css({position:"fixed",top:r.top,left:r.left}),this._events.push([s.id,Date.now()]);break}}},this._mousemove=n=>{if(this.disabled)return;if(e<0)return;return this._drags[e].pointer._element.jQueryElement.css({top:t.top+(n.clientY-t.y),left:t.left+(n.clientX-t.x),"z-index":999999}),n.preventDefault(),n.stopPropagation(),!1},this._mouseup=n=>{if(this.disabled)return e=-1;if(e<0)return e=-1;const i=this._drags[e].pointer._element.jQueryElement;let r=!1;for(let t=0;t<this._drops.length;t++){const i=this._drops[t].pointer;if(void 0===i._runPromises||void 0===i._element)return e=-1;const s=i._element;if(!(s.jQueryElement instanceof jQuery))return e=-1;const o=s.jQueryElement,a=this._drops[t].indicesDrag,l=o[0].getBoundingClientRect();if(n.clientX>l.left&&n.clientX<l.left+l.width&&n.clientY>l.top&&n.clientY<l.top+l.height&&(!this._single||0===a.length)){this.drop(e,t,!0),r=!0;break}}if(!r)if(this._bungee)i.css({position:t.old_position,left:t.old_left,top:t.old_top});else{const e=i[0].getBoundingClientRect();i.appendTo($("body")).css({position:"absolute",top:e.top+window.scrollY,left:e.left+window.scrollX})}e=-1},this._touch=t=>{ev=t.originalEvent;const n={clientX:0,clientY:0,preventDefault:()=>ev.preventDefault(),stopPropagation:()=>ev.stopPropagation()};let i=ev.changedTouches;(void 0===i||i.length<1)&&(i=ev.targetTouches),(void 0===i||i.length<1)&&(i=ev.touches);for(let e=0;e<i.length;e++){const t=i[e];n.clientX+=t.clientX,n.clientY+=t.clientY,n.target=t.target}switch(n.clientX=n.clientX/i.length,n.clientY=n.clientY/i.length,ev.type){case"touchstart":this._mousedown(n);break;case"touchmove":e>=0&&ev.preventDefault(),this._mousemove(n);break;case"touchend":e>=0&&ev.preventDefault(),this._mouseup(n)}},Object.defineProperty(this,"dragElements",{get:()=>this._drags.map(e=>e.pointer._element)}),Object.defineProperty(this,"dropElements",{get:()=>this._drops.map(e=>e.pointer._element)})},this.uponCreation=function(n){this._log=!1,this._drags=[],this._drops=[],this._offset=[],this._waits=[],this._events=[],this._callbacks=[],this._bungee=!1,this._swap=!1,this._single=!1,this._initParameters.forEach(e=>{e.match(/bungee/i)?this._bungee=!0:e.match(/swap/i)?this._swap=!0:e.match(/single/i)&&(this._single=!0)}),e=-1,t={x:0,y:0,top:0,left:0,old_top:0,old_left:0,old_position:"unset"},$(document).bind("mousedown",".PennController-elementContainer > *",this._mousedown),$(document).bind("mousemove",this._mousemove),$(document).bind("mouseup",this._mouseup),$(document).bind("touchstart",".PennController-elementContainer > *",this._touch),$(document).bind("touchmove",this._touch),$(document).bind("touchend",this._touch),n()},this.end=function(){if($(document).unbind("mousedown",".PennController-elementContainer > *",this._mousedown),$(document).unbind("mousemove",this._mousemove),$(document).unbind("mouseup",this._mouseup),$(document).unbind("touchstart",".PennController-elementContainer > *",this._touch),$(document).unbind("touchmove",this._touch),$(document).unbind("touchend",this._touch),e=-1,"all"==this._log&&this._events.forEach(e=>{e.length<3?n.controllers.running.save(this.type,this.id,"Drag",e[0],e[1],"Not dropped"):(n.controllers.running.save(this.type,this.id,"Drag",e[0],e[1],"Dropped on "+e[3]),n.controllers.running.save(this.type,this.id,"Drop",e[3],e[2],"Dopped "+e[0]))}),this._log){let e=[];this._drags.forEach(t=>{if(void 0===t.pointer||void 0===t.pointer._element||void 0===t.pointer._runPromises)return;const n=t.pointer._element.id.replace(/:;/g,"_");t.indexDrop>=0?e.push(n+":"+this._drops[t.indexDrop].pointer._element.id.replace(/:;/g,"_")):e.push(n+":")}),n.controllers.running.save(this.type,this.id,"Final",e.join(";"),Date.now(),"NULL")}},this.value=function(){},this.actions={addDrag:function(e,...t){t.forEach(e=>this._drags.push({pointer:e,indexDrop:-1})),e()},addDrop:function(e,...t){this._offset.length>1?t.forEach(e=>this._drops.push({pointer:e,indicesDrag:[],offset:[this._offset[0],this._offset[1]]})):t.forEach(e=>this._drops.push({pointer:e,indicesDrag:[],offset:[],swap:void 0})),e()},bungee:function(e,...t){this._bungee=!0,e()},callback:function(e,...t){this._callbacks.push(t),e()},drop:function(e,t,n,i=!1){if(void 0===t._element||void 0===n._element)return;const r=this.dragElements,s=this.dropElements;let o,a;if(o=r.indexOf(t._element),o<0){if(o=r.indexOf(n._element),o<0)return e();if(a=s.indexOf(t),a<0)return e()}else if(a=s.indexOf(n._element),a<0)return e();this.drop(o,a,i),e()},log:function(e,t=!0){this._log=t,e()},offset:function(e,t,n,...i){if(void 0===n?n=t:n._runPromises&&(i=[n,...i],n=t),i.length>0){const e=this._drops.map(e=>e.pointer._element);i.forEach(i=>{const r=e.indexOf(i._element);r<0||(this._drops[r].offset=[t,n])})}else this._drops.forEach(e=>e.offset=[t,n]),this._offset=[t,n];e()},removeDrag:function(e,...t){const n=t.map(e=>e._element);this._drags=this._drags.filter(e=>void 0===e.pointer._element||n.indexOf(e.pointer._element)<0),e()},removeDrop:function(e,...t){const n=t.map(e=>e._element);this._drops=this._drops.filter(e=>void 0===e.pointer._element||n.indexOf(e.pointer._element)<0),e()},single:function(e,...t){this._single=!0,e()},swap:function(e,...t){if(t.length>0){const e=this._drops.map(e=>e.pointer._element);t.forEach(t=>{const n=e.indexOf(t._element);n<0||(this._drops[n].swap=!0)})}else this._drops.forEach(e=>e.swap=!0),this._swap=!0;e()},wait:function(e,t){let n=e;t&&t._runPromises instanceof Function&&t.success&&(n=()=>t._runPromises().then(t=>"success"==t&&e())),this._waits.push(n)}},this.test={dropped:function(...e){if(0==e.length)return this._drags.filter(e=>e.indexDrop>=0).length>0;const t=this.dragElements,n=this.dropElements;if(e.length>1){let i=e[0],r=e[1];if(void 0===i._element||void 0===r._element)return this._drags.filter(e=>e.indexDrop>=0).length;let s,o=t.indexOf(i._element);if(o<0&&(i=e[1],o=t.indexOf(i._element),r=e[0]),s=n.indexOf(r._element),o>=0&&s>=0)return this._drags[o].indexDrop==s}let i=!0;return e.forEach(e=>{if(void 0===e._element)return;const r=t.indexOf(e._element);if(r>=0)return i=i&&this._drags[r].indexDrop>=0;const s=n.indexOf(e._element);return s>=0?i=i&&this._drops[s].indicesDrag.length>0:void 0}),i}}}))})()},function(e,t){window.PennController._AddElementType("DropDown",(function(e){this.immediate=function(e,t){void 0===t&&(t=e,void 0!==e&&"string"==typeof e&&0!=e.length||(e="DropDown"),this.id=e),this.id=e,this.initialText=t},this.uponCreation=function(e){this.options=[],this.selections=[],this.change=()=>{if(this.jQueryElement.attr("disabled"))return;let e=this.jQueryElement.find("option:selected").val(),t=0;for(let n=0;n<this.options.length;n++)this.options[n]==e&&(t=n);this.selections.push(["Selected",e,Date.now(),t])},this.jQueryElement=$("<select>").append($("<option>").html(this.initialText).attr({value:this.initialText,selected:!0,disabled:!0,hidden:!0})),e()},this.value=function(){let e=this.selections;return e instanceof Array&&e.length>0?e[e.length-1][1]:""},this.end=function(){if(this.log)if(this.selections.length)if("string"==typeof this.log&&this.log.match(/^\W*first\W*$/i))e.controllers.running.save(this.type,this.id,...this.selections[0]);else if("string"==typeof this.log&&this.log.match(/^\W*all\W*$/i))for(let t=0;t<this.selections.length;t++)e.controllers.running.save(this.type,this.id,...this.selections[t]);else e.controllers.running.save(this.type,this.id,...this.selections[this.selections.length-1]);else e.controllers.running.save(this.type,this.id,"Selected",this.jQueryElement.find("option:selected").val(),"Never","Default")};let t=this;this.actions={print:function(t,...n){e.elements.standardCommands.actions.print.call(this,()=>{this.jQueryElement.change(()=>this.change()),t()},...n)},shuffle:function(e,t){if(t){let e=this.jQueryElement.find("option:selected");t=!!e.length&&e.val()}fisherYates(this.options),this.jQueryElement.empty(),this.jQueryElement.append($("<option>").html(this.initialText).attr({value:this.initialText,selected:!0,disabled:!0,hidden:!0}));for(let e=0;e<this.options.length;e++)this.jQueryElement.append($("<option>").html(this.options[e]).attr("value",this.options[e]));t&&this.jQueryElement.find("option[value='"+t+"']").attr("selected",!0),e()},remove:function(n,...i){i.length?t.settings.remove.call(this,n,...i):e.elements.standardCommands.actions.remove.call(this,n)},select:function(e,t){this.options.indexOf(t)>-1?(this.jQueryElement.find("option").removeAttr("selected"),this.jQueryElement.find("option[value='"+t+"']").attr("selected",!0)):Number(t)>-1&&Number(t)<this.options.length&&(this.jQueryElement.find("option").removeAttr("selected"),this.jQueryElement.find("option[value='"+this.options[Number(t)]+"']").attr("selected",!0)),e()},wait:function(e,t){if("first"==t&&this.selections.length)e();else{let n=!1,i=this.change;this.change=()=>{if(i.call(this),!n)if(t instanceof Object&&t._runPromises&&t.success){let i=this.disabled;this.jQueryElement.attr("disabled",!0),this.disabled="tmp",t._runPromises().then(t=>{"success"==t&&(n=!0,e()),"tmp"==this.disabled&&(this.disabled=i,this.jQueryElement.attr("disabled",i))})}else n=!0,e()}}}},this.settings={add:function(e,...t){for(let e=0;e<t.length;e++)t[e]=String(t[e]),this.options.indexOf(t[e])<0&&(this.options.push(t[e]),this.jQueryElement.append($("<option>").html(t[e]).attr("value",t[e])));e()},callback:function(e,...t){let n=this.change;this.change=async function(){let e=this.jQueryElement.attr("disabled");if(await n.apply(this),!e)for(let e=0;e<t.length;e++)t[e]._runPromises?await t[e]._runPromises():t[e]instanceof Function&&await t[e]()},e()},once:function(e){let t=this.change;this.change=()=>{t.apply(this),this.jQueryElement.attr("disabled",!0)},e()},remove:function(e,t){let n=this.options.indexOf(t);n>-1&&(this.jQueryElement.find("option[value='"+t+"']").remove(),this.options.splice(n,1)),e()}},this.test={selected:function(e){let t=this.jQueryElement.find("option:selected");return!!this.selections.length&&(void 0===e||(e==t.val()||(Number(e)>-1&&Number(e)<this.options.length?t.val()==this.options[Number(e)]:void 0)))}}}))},function(e,t){window.PennController._AddElementType("EyeTracker",(function(e){let t,i,r,s=!1,o=!1,a=[[],[]],l=!1,u=null,h=null,c="",d=!1;window.PennController.EyeTrackerURL=e=>c=e;const f=new Audio("data:audio/wav;base64,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");function p(e){for(var t,n={},i=(e+"").split(""),r=[],s=i[0],o=256,a=1;a<i.length;a++)null!=n[s+(t=i[a])]?s+=t:(r.push(s.length>1?n[s]:s.charCodeAt(0)),n[s+t]=o,o++,s=t);r.push(s.length>1?n[s]:s.charCodeAt(0));for(a=0;a<r.length;a++)r[a]=String.fromCharCode(r[a]);return r.join("")}function m(){if(window.webgazer&&t)return window.webgazer;e.debug.error("Tried to access the EyeTracker before it was set.")}function g(e){e=!(!1===e),m().showFaceFeedbackBox(e),m().showFaceOverlay(e),m().showPredictionPoints(e),m().showVideo(e),$("#webgazerGazeDot").css("pointer-events","none")}function y(e){let t=window.innerHeight,i=window.innerWidth,r=e[0],s=e[1],o=i/2,a=t/2,l=new Array(50);!function(e,t,i,r,s,o){for(n=0;n<50;n++){let a=s-i[n],l=o-r[n],u=Math.sqrt(a*a+l*l),h=t/2,c=0;c=u<=h?100-u/h*100:0,e[n]=c}}(l,t,r,s,o,a);let u=function(e){let t=0;for(n=0;n<50;n++)t+=e[n];return t/=50,t}(l);return Math.round(u)}const b=(e,t)=>{d=!0,o&&(a[0].push(e.x),a[1].push(e.y),a[0].length>50&&a[0].shift(),a[1].length>50&&a[1].shift()),i&&i.look(e,t)};let w=function(){r=e.utils.guidGenerator(),s=!0;let n=document.createElement("script");n.setAttribute("src","https://cdn.jsdelivr.net/gh/penncontroller/penncontroller/releases/latest/webgazer.min.js"),document.head.appendChild(n);let i=()=>{window.webgazer?function(){a=[[],[]],t=window.webgazer.setRegression("weightedRidge").setTracker("TFFacemesh").setGazeListener((e,t)=>{null!=e&&(e instanceof Promise?e.then(e=>b(e,t)):e.x&&b(e,t))});let e=document.addEventListener;document.addEventListener=function(...t){"mousemove"!=t[0]||"function"!=typeof t[1]||!0!==t[2]||u||(u=t[1]),"click"!=t[0]||"function"!=typeof t[1]||!0!==t[2]||h||(h=t[1]),e.apply(document,t)},t.params.showVideoPreview=!0,t.begin(),window.webgazer.showPredictionPoints(!0),g(!1)}():setTimeout(i,100)};void 0===t&&i()};this.immediate=function(e,t,n){s||w(),"number"==typeof e&&(void 0===t||"number"==typeof t&&void 0===n)&&(n=t,t=e,void 0!==e&&"string"==typeof e&&0!=e.length||(e="EyeTracker"),this.id=e),this.span=Number(t),this.proportion=n},this.uponCreation=function(t){let n;this.enabled=!1,this.elements=[],this.counts={times:[]},this.callback=null,this.log=!1,this.trainOnMouseMove=!0,this.look=function(t,i){if(this.enabled&&null!=t&&void 0!==t.x&&void 0!==t.y){this.elements.map(e=>e.jQueryElement.removeClass("PennController-eyetracked"));for(let n=0;n<this.elements.length;n++){const i=this.elements[n].jQueryElement,r=e.utils.overToScale.call(i,t.x,t.y);if(r?this.counts["_"+this.elements[n].id].push(1):this.counts["_"+this.elements[n].id].push(0),isNaN(this.span))r&&(i.addClass("PennController-eyetracked"),this.callback&&this.callback instanceof Function&&this.callback.call(this.elements[n],t.x,t.y));else{this.hasOwnProperty("gazes")&&this.elements.length==this.gazes.length||(this.gazes=this.elements.map(()=>[])),r?this.gazes[n].push(!0):this.gazes[n].push(!1),this.gazes[n].length>this.span&&this.gazes[n].shift();let e=Number(this.proportion);isNaN(e)&&(e=this.span/100),e<=0?e=.01:e>=1&&(e=.99),this.gazes[n].filter(e=>e).length/this.gazes[n].length>e&&i.addClass("PennController-eyetracked"),this.callback&&this.callback instanceof Function&&this.callback.call(this.elements[n],t.x,t.y)}}void 0===n&&(n=i),this.counts.times.push(Math.round(i-n)),n=i}},t()},this.end=function(){if(g(!1),m().removeMouseEventListeners(),this.enabled=!1,i=void 0,this.log&&this.counts.times.length){let t=c,n=window.location.href.replace(/[^/]+$/,"").replace(/[^\w\d]/g,"").replace(/[\.]{2,}/g,"");e.debug.log("expname",n);let i=(i,s)=>{let o={experiment:n,id:r,pcnumber:e.controllers.running.id,parameter:i,value:s},a="json="+JSON.stringify(o);var l=new XMLHttpRequest;l.open("POST",t,!0),l.setRequestHeader("Content-Type","application/x-www-form-urlencoded"),l.onreadystatechange=()=>{200!=l.status&&e.controllers.running.save(this.type,this.id,"Upload","Error",Date.now(),i)},l.send(a)};e.debug.log("about to send times",this.counts),i("times",p(this.counts.times.join("."))),delete this.counts.times;let s=Object.keys(this.counts);for(let e=0;e<s.length;e++)i(s[e],p(this.counts[s[e]].join(".")));e.controllers.running.save(this.type,this.id,"Filename",n+"/"+r,Date.now(),"NULL")}delete this.counts},this.value=function(){return"EyeTracker"},this.actions={calibrate(t,n,i){Number(i)>0||(i=-1),function t(n,i,r,s){m().addMouseEventListeners(),e.debug.log("Starting calibration"),a=[[],[]];let u=$("<div>").css({position:"absolute",left:0,top:0,width:"100vw",height:"100vh","background-color":"white","text-align":"center"}),c=async()=>{await new Promise(e=>setTimeout(e,1e3));const c=$("<div>").css({position:"fixed",display:"block",width:"48px",height:"48px",background:"green","border-radius":"100%",left:"calc(50vw - 24px)",top:"calc(50vh - 24px)","z-index":999999});$("body").append(c),h({clientX:window.innerWidth/2,clientY:window.innerHeight/2}),$(this).attr("disabled",!0),o=!0,setTimeout(()=>{o=!1,c.detach();let h=y(a);i._precision=h,e.debug.log("Tracker's precision: "+h),a=[[],[]],e.controllers.running.save(i.type,i.id,"calibration",h,Date.now(),1==s?"Last attempt":"NULL"),r&&Number(r)>0&&h<r&&1!=s?(l=!1,$(this).remove(),g(!0),u.append($("<div>").html("<p>It looks like we were not able to precisely calibrate the tracker:</p><p>You calibration score is "+h+" and you need at least "+r+"</p><p>Here are a few tips to help you better self-calibrate:</p><p>- try adjusting your webcam based on the video in the top-left corner.</p><p>- if you use an external webcam, make sure it is fixed to the top of your screen.</p><p>- try raising your screen so as to align your webcam with your eyes</p><p><img style='display: inline-block; height: 75px;' src='http://files.lab.florianschwarz.net/ibexfiles/Pictures/lookdown.png'><img style='display: inline-block; height: 75px;' src='http://files.lab.florianschwarz.net/ibexfiles/Pictures/lookstraight.png'></p><p>- make sure no one is standing next to you.</p><p>- make sure you are not wearing eyeglasses reflecting ambiant light.</p><p>- make sure the algorithm detects your face (it should appear green).</p><p>- make sure there is enough ambient light for face-detection.</p><p>- make sure you follow your mouse pointer with your eyes.</p><p>- make sure you keep looking at the middle button until the end.</p>").css({margin:"auto","margin-top":"5em"})).append($("<button>Retry</button>").click((function(){u.remove(),window.webgazer.reg.RidgeWeightedReg.call(window.webgazer.getRegression()[0]),t(n,i,r,s-1)})).css("margin","auto"))):(l=!0,u.remove(),m().removeMouseEventListeners(),n())},3e3)};if(l)c();else{g(!0);const e=48,t=48,n=120;let i=[];const r=async s=>{const o=i.shift(),a=$("<div>").css({position:"fixed",display:"block",width:e+"px",height:t+"px",background:"green","border-radius":"100%",left:o[0],top:o[1],"z-index":999999});await new Promise(e=>setTimeout(e,750)),$("body").append(a),f.play(),await new Promise(e=>setTimeout(e,250));let l=n;const u=()=>{l%2&&h({clientX:o[0]+e/2,clientY:o[1]+t/2}),0==l?(a.detach(),i.length?r():c()):(l--,window.requestAnimationFrame(u))};u()},s=()=>$("body").append($("<button>I'm ready. Start calibration</button>").bind("click",n=>{m().removeMouseEventListeners(),g(!1),$(n.target).detach();const s=window.innerWidth,o=window.innerHeight;i=[[(s-e)/2,(o-t)/2],...[[0,0],[(s-e)/2,0],[s-e,o-t],[(s-e)/2,o-t],[s-e,(o-t)/2],[s-e,0],[0,(o-t)/2],[0,o-t]].sort(e=>.5-Math.random()),[(s-e)/2,(o-t)/2]],r()}).css({position:"fixed",display:"block",left:"50vw",top:"50vh",transform:"translate(-50%,-50%)"}));if(d)s();else{const e=$("<p>Wait until your face is detected (you should see green contours around it)                                    and then click anywhere on the page until you see a red dot</p>");e.css({position:"fixed",left:"50vw",top:"50vh",transform:"translate(-50%,-50%)"}),$("body").append(e);const t=()=>{d?(e.remove(),s()):window.requestAnimationFrame(t)};t()}}$("#webgazerVideoFeed").before(u)}(t,this,n,i)},hideFeedback:function(e){g(!1),e()},start:function(e){this.enabled=!0,i=this,e()},stop:function(e){this.enabled=!1,i=void 0,e()},stopTraining:function(e){m().removeMouseEventListeners(),m().showPredictionPoints(!1),e()},showFeedback:function(e){g(),e()},train:function(e,t){m().addMouseEventListeners(),this.trainOnMouseMove||document.removeEventListener("mousemove",u,!0),m().showPredictionPoints(t),e()}},this.settings={add:function(e,...t){for(let e=0;e<t.length;e++){let n=t[e];n&&n._element&&this.elements.indexOf(n._element)<0&&(this.elements.push(n._element),this.counts["_"+n._element.id]=[])}e()},callback:function(e,t){t instanceof Function&&(this.callback=t),e()},log:function(e){this.log=!0,e()},trainOnMouseMove:function(e,t){this.trainOnMouseMove=void 0===t||t,this.trainOnMouseMove||document.removeEventListener("mousemove",u,!0),e()}},this.test={calibrated:function(){return l},ready:function(){return window.webgazer&&window.webgazer.isReady()},score:function(e){const t=this._precision;return e instanceof Function?e.call(this,t):isNaN(Number(e))?l:t>=Number(e)}}}))},function(e,t){window.PennController._AddElementType("Function",(function(e){this.immediate=function(e,t){"function"==typeof e&&(t=e,void 0!==e&&"string"==typeof e&&0!=e.length||(e="Function"),this.id=e),this.function=t},this.uponCreation=function(t){e.controllers.running.hasOwnProperty("internalVariables")||(e.controllers.running.internalVariables={}),t()},this.end=function(){e.controllers.running.internalVariables=void 0},this.value=function(){return this.function.apply(e.controllers.running.internalVariables)},this.actions={call:async function(t,...n){await this.function.apply(e.controllers.running.internalVariables,n),t()}},this.test={is:function(t){let n=this.function.apply(e.controllers.running.internalVariables);return void 0===t?!n:n==t}}}))},function(e,t){window.PennController._AddElementType("Html",(function(e){function t(e,t){var n=$("label.error[for=__ALL_FIELDS__]");if(n.length>0)n.addClass("Form-error-text").text(t);else{var i=$("label.error[for="+escape(e)+"]");i.length>0?i.addClass("Form-error-text").text(t):alert(t)}}function n(){for(var e=this.jQueryElement[0],t=$(e).find("input[type=text]"),n=$(e).find("textarea"),i=0;i<n.length;++i)t.push(n[i]);for(i=0;i<t.length;++i){var r=$(t[i]);if(r.hasClass("obligatory")&&(!r.attr("value")||r.attr("value").match(/^\s*$/)))return!1}var s=$(e).find("input[type=checkbox]");for(i=0;i<s.length;++i){var o=$(s[i]);if(!o.attr("checked")&&o.hasClass("obligatory"))return!1}var a=$(e).find("input[type=radio]"),l={};for(i=0;i<a.length;++i){var u=$(a[i]);u.attr("name")&&(l[u.attr("name")]||(l[u.attr("name")]=[]),l[u.attr("name")].push(u))}for(var h in l){var c=!1,d=!1;for(i=0;i<l[h].length;++i)l[h][i].hasClass("obligatory")&&(c=!0),l[h][i].attr("checked")&&(d=!0);if(c&&!d)return!1}return!0}this.immediate=function(e,t){void 0===t&&(t=e,void 0!==e&&"string"==typeof e&&0!=e.length||(e="Html"),this.id=e),this.html=t},this.uponCreation=function(e){CHUNKS_DICT.hasOwnProperty(this.html)?this.jQueryElement=$("<div>").html(htmlCodeToDOM({include:this.html})):this.jQueryElement=$("<div>").append(this.html),this.log=!1,this.checkboxWarningMessage="You must check the %name% checkbox to continue.",this.inputWarningMessage="The ‘%name%’ field is obligatory.",this.radioWarningMessage="You must select an option for ‘%name%’.",e()},this.end=function(){if(this.log){for(var t=this.jQueryElement[0],n=$(t).find("input[type=text]"),i=$(t).find("textarea"),r=0;r<i.length;++r)n.push(i[r]);for(r=0;r<n.length;++r){var s=$(n[r]);e.controllers.running.save(this.type,this.id,csv_url_encode(s.attr("name")),csv_url_encode(s.attr("value")),Date.now(),"text input")}var o=$(t).find("input[type=checkbox]");for(r=0;r<o.length;++r){var a=$(o[r]);e.controllers.running.save(this.type,this.id,a.attr("name"),a.attr("checked")?"checked":"unchecked",Date.now(),"checkbox")}var l=$(t).find("input[type=radio]"),u={};for(r=0;r<l.length;++r){var h=$(l[r]);h.attr("name")&&(u[h.attr("name")]||(u[h.attr("name")]=[]),u[h.attr("name")].push(h))}for(var c in u){var d,f=!1;for(r=0;r<u[c].length;++r)u[c][r].attr("checked")&&(f=!0,d=r);f&&e.controllers.running.save(this.type,this.id,u[c][0].attr("name"),u[c][d].attr("value"),Date.now(),"radio button")}}},this.value=function(){return n.apply(this)},this.actions={warn:function(e){for(var n=this.jQueryElement[0],i=$(n).find("input[type=text]"),r=$(n).find("textarea"),s=0;s<r.length;++s)i.push(r[s]);for(s=0;s<i.length;++s){var o=$(i[s]);!o.hasClass("obligatory")||o.attr("value")&&!o.attr("value").match(/^\s*$/)||t(o.attr("name"),this.inputWarningMessage.replace(/%name%/gi,o.attr("name")))}var a=$(n).find("input[type=checkbox]");for(s=0;s<a.length;++s){var l=$(a[s]);!l.attr("checked")&&l.hasClass("obligatory")&&t(l.attr("name"),this.checkboxWarningMessage.replace(/%name%/gi,l.attr("name")))}var u=$(n).find("input[type=radio]"),h={};for(s=0;s<u.length;++s){var c=$(u[s]);c.attr("name")&&(h[c.attr("name")]||(h[c.attr("name")]=[]),h[c.attr("name")].push(c))}for(var d in h){var f=!1,p=!1;for(s=0;s<h[d].length;++s)h[d][s].hasClass("obligatory")&&(f=!0),h[d][s].attr("checked")&&(p=!0);f&&!p&&t(h[d][0].attr("name"),this.radioWarningMessage.replace(/%name%/gi,h[d][0].attr("name")))}e()}},this.settings={checkboxWarning:function(e,t){this.checkboxWarningMessage=t,e()},inputWarning:function(e,t){this.inputWarningMessage=t,e()},log:function(e){this.log=!0,e()},radioWarning:function(e,t){this.radioWarningMessage=t,e()}},this.test={complete:function(){return n.apply(this)}}}))},function(e,t){window.PennController._AddElementType("Image",(function(e){this.immediate=function(t,n){"string"==typeof t&&void 0===n&&(n=t),this.id=t;let i=!n.match(/^http/i);this.resource=e.resources.fetch(n,(function(e){this.object=new Image,this.object.onload=e,this.object.src=this.value}),i)},this.uponCreation=function(e){this.image=this.resource.object,this.image&&(this.image.style=null),this.jQueryElement=$(this.image),this.jQueryElement.removeClass(),e()},this.end=function(){this.log&&(this.printTime?e.controllers.running.save(this.type,this.id,"Print","NA",this.printTime,"NULL"):e.controllers.running.save(this.type,this.id,"Print","NA","Never","NULL"))},this.value=function(){return this.jQueryElement.parent().length}}))},function(e,t){window.PennController._AddElementType("Key",(function(e){this.immediate=function(t,...n){n.length<1&&(n=[t],void 0!==t&&"string"==typeof t&&0!=t.length||(t="Key"),this.id=t),this.keys=[],this.specialKeys=[];for(let i=0;i<n.length;i++)"number"==typeof n[i]&&n[i]>0?this.keys.push(String.fromCharCode(n[i])):"string"!=typeof n[i]?e.debug.error("Invalid key(s) passed to new Key &quot;"+t+"&quot; (should be a string or a key code number)",n[i]):n[i].isSpecialKey()||n[i].replace(/^(Left|Right)/i,"").isSpecialKey()?this.specialKeys.push(n[i].toUpperCase()):n[i].length&&this.keys.push(n[i].toUpperCase())},this.uponCreation=function(t){this.pressed=[],this.pressedWait=[],this.log=!1,this.enabled=!0,e.events.keypress(e=>{if(!this.enabled)return;let t=e.key.isSpecialKey(),n=e.key.toUpperCase(),i={0:"",1:"LEFT",2:"RIGHT"};(0==this.keys.length&&0==this.specialKeys.length||t&&this.specialKeys.filter(t=>t==n||t===i[e.location]+n).length||!t&&this.keys.filter(e=>e.indexOf(n)>-1).length)&&this.press(e.key)}),this.press=e=>{this.pressed.push(["PressedKey",e.toUpperCase(),Date.now(),"NULL"])},t()},this.end=function(){if(this.log&&this.log instanceof Array)if(0==this.pressed.length)e.controllers.running.save(this.type,this.id,"Key","NA","Never","NULL");else if(this.log.indexOf("all")>-1)for(let t in this.pressed)e.controllers.running.save(this.type,this.id,...this.pressed[t]);else if(this.log.indexOf("wait")>-1){let t=!1;for(let n in this.pressed)"Wait success"==this.pressed[n][3]&&(e.controllers.running.save(this.type,this.id,...this.pressed[n]),t=!0);t||e.controllers.running.save(this.type,this.id,"Key","NA","Never","(failed keypresses happened)")}else 1==this.pressed.length?e.controllers.running.save(this.type,this.id,...this.pressed[0]):(this.log.indexOf("first")>-1&&e.controllers.running.save(this.type,this.id,...this.pressed[0]),this.log.indexOf("last")>-1&&e.controllers.running.save(this.type,this.id,...this.pressed[this.pressed.length-1]))},this.value=function(){return this.pressed.length?this.pressed[this.pressed.length-1][1]:""},this.actions={wait:function(e,t){if("first"==t&&this.pressed.length)e();else{let n=!1,i=this.press,r=document.activeElement;for(;r;)r.disabled?(r.blur(),r=null):r=r.parentElement;this.press=r=>{if(i.apply(this,[r]),!n)if(t instanceof Object&&t._runPromises&&t.success){let i=this.enabled;this.enabled=0,t._runPromises().then(t=>{"success"==t?(this.pressed[this.pressed.length-1][3]="Wait success",n=!0,e()):this.pressed[this.pressed.length-1][3]="Wait failure",0===this.enabled&&(this.enabled=i)})}else this.pressed[this.pressed.length-1][3]="Wait success",n=!0,e()}}}},this.settings={callback:function(e,...t){let n=this.press;this.press=async function(e){if(n.apply(this,[e]),this.enabled)for(let e in t)await t[e]._runPromises()},e()},disable:function(e){this.enabled=!1,e()},enable:function(e){this.enabled=!0,e()},log:function(e,...t){t.length?this.log=t:this.log=["wait"],e()}},this.test={pressed:function(e,t){for(let n in this.pressed){let i=this.pressed[n][1];if(Number(e)>0&&i.toUpperCase()==String.fromCharCode(e).toUpperCase())return!0;if("string"==typeof e&&e.toUpperCase()==i.toUpperCase())return!0;if(void 0===e)return!0;if(t)return!1}return!1}}}))},function(e,t){window.PennController._AddElementType("MouseTracker",(function(e){let t,n;this.immediate=function(e){void 0!==e&&"string"==typeof e&&0!=e.length||(e="MouseTracker"),this.id=e,$(document).mousemove(e=>{t=e.clientX,n=e.clientY,this.move&&this.move instanceof Function&&this.enabled&&this.move(e)}),$(document).click(e=>{this.click&&this.click instanceof Function&&this.enabled&&this.click(e)})},this.uponCreation=function(e){this.coordinates=[],this.enabled=!1,this.callbacks=[],this.clickCallbacks=[],this.currentStream=[],this.log=[],this.clicks=[];let i=this;this.click=async e=>{if(this.enabled){this.clicks.push([Date.now(),e.clientX,e.clientY]);for(let t=0;t<this.clickCallbacks.length;t++){let n=this.clickCallbacks[t];n instanceof Function?await n.apply(this,[e.clientX,e.clientY]):n._runPromises&&n._runPromises instanceof Function&&await n._runPromises(e.clientX,e.clientY)}}},this.move=async function(){if(i.enabled&&(i.currentStream.push([Date.now(),t,n]),i.callbacks.length))for(let e=0;e<i.callbacks.length;e++)i.callbacks[e]instanceof Function?await i.callbacks[e].apply(this,[t,n]):i.callbacks[e]._runPromises&&i.callbacks[e]._runPromises instanceof Function&&await i.callbacks[e]._runPromises(t,n)},this.finishStream=()=>{if(this.currentStream.length>1){let e=this.currentStream[0][1],t=this.currentStream[0][2],n=this.currentStream[0][0];void 0===e&&(e=this.currentStream[1][1]),void 0===t&&(t=this.currentStream[1][2]);let i="x"+e+"y"+t+"w"+this.currentStream[0][3]+"h"+this.currentStream[0][4];for(let r=1;r<this.currentStream.length;r++){let s=this.currentStream[r][1]-e,o=this.currentStream[r][2]-t;i+="t"+(this.currentStream[r][0]-n),i+=(s>=0?"+":"")+s,i+=(o>=0?"+":"")+o,e=this.currentStream[r][1],t=this.currentStream[r][2],n=this.currentStream[r][0]}let r="NULL";window.innerWidth==this.currentStream[0][3]&&window.innerHeight==this.currentStream[0][4]||(r="Size of window changed to "+window.innerWidth+" * "+window.innerHeight),this.coordinates.push([i,this.currentStream[0][0],r])}this.currentStream=[]},e()},this.end=function(){this.enabled=!1,this.finishStream&&this.finishStream instanceof Function&&this.finishStream(),this.log.map(t=>{"string"==typeof t&&(t.match(/move/i)?this.coordinates.map(t=>e.controllers.running.save(this.type,this.id,"Move",...t)):t.match(/click/i)&&this.clicks.map(t=>e.controllers.running.save(this.type,this.id,"Click",t[1]+":"+t[2],t[0],"NULL")))})},this.value=function(){return t&&n?t+"-"+n:"NA-NA"},this.actions={start:function(e){this.currentStream=[[Date.now(),t,n,window.innerWidth,window.innerHeight]],this.enabled=!0,e()},stop:function(e){this.enabled=!1,this.finishStream(),e()}},this.settings={callback:function(e,...t){0!=t.length&&("string"==typeof t[0]&&t[0].match(/click/i)?(t.shift(),this.clickCallbacks=this.clickCallbacks.concat(t)):this.callbacks=this.callbacks.concat(t),e())},log:function(e,...t){console.log("log what?",t),t.length?this.log=t:this.log=["clicks","movements"],e()}},this.test={over:function(i){return i instanceof jQuery?e.utils.overToScale.call(i,t,n):!!(i._element&&i._element.hasOwnProperty("jQueryElement")&&i._element.jQueryElement instanceof jQuery)&&e.utils.overToScale.call(i._element.jQueryElement,t,n)}}}))},function(e,t){window.PennController._AddElementType("Palette",(function(e){this.immediate=function(e,t){void 0===t&&(t=e),this.mode=t||"background",void 0!==e&&"string"==typeof e&&0!=e.length||(e="Palette"),this.id=e},this.uponCreation=function(e){this.currentColor=null,this.enabled=!0,this.elements=[],this.colors=[],this.brushes=[],this.log=!1,this.select=e=>{if(!this.enabled||!this.currentColor)return;let t=this.elements.map(e=>e[0]).indexOf(e);if(t<0)return;this.elements[t][1]=this.currentColor;let n=e.jQueryElement;this.brushes.push([e.id,this.currentColor,Date.now()]),"background"==this.mode?n.css("background-color",this.currentColor):(n._tinter&&n._tinter instanceof jQuery&&n._tinter.remove(),n._tinter=$("<div>").css({display:"block",position:"absolute",width:n.width(),height:n.height(),"margin-top":-1*n.width(),background:this.elements[t][1],opacity:.5}),n.before(n._tinter))},e()},this.end=function(){if(this.enabled=!1,$("#bod").css("cursor","default"),this.log){if("all"==this.log)for(let t=0;t<this.brushes.length;t++)e.controllers.running.save(this.type,this.id,this.brushes[t][0],this.brushes[t][1],this.brushes[t][2],"NULL");for(let t=0;t<this.elements.length;t++)e.controllers.running.save(this.type,this.id,this.elements[t][0].id,this.elements[t][1],"Final","NULL")}},this.value=function(){return this.brushes.length},this.actions={brush:function(e,t,n){if(t._element){let e=this.currentColor;this.currentColor=n,this.select(t._element),this.currentColor=e}e()},clear:function(e){for(let e in this.elements)"background"==this.mode?this.elements[e][0].jQueryElement.css("background-color","transparent"):this.elements[e].jQueryElement._tinter&&this.elements[e][0].jQueryElement._tinter.remove(),this.elements[e][1]=null;e()},unselect:function(e){$(".PennController-"+this.type+"-palette-selected").removeClass("PennController-"+this.type+"-palette-selected"),$("#bod").css("cursor","default"),this.currentColor=null,e()},wait:function(e,t){if("first"==t&&this.brushes.length)e();else{let n=!1,i=this.select;this.select=r=>{let s=i.apply(this,[r]);n||!this.enabled&&!s||(t instanceof Object&&t._runPromises&&t.success?t._runPromises().then(t=>{"success"==t&&(n=!0,e())}):(n=!0,e()))}}}},this.settings={addColor:function(t,n,...i){this.colors.indexOf(n)<0&&this.colors.push(n);let r=[],s=()=>{this.colors.indexOf(n)<0||(this.currentColor=n,$(".PennController-"+this.type+"-palette-selected").removeClass("PennController-"+this.type+"-palette-selected"),r.map(e=>e.jQueryElement.addClass("PennController-"+this.type+"-palette-selected")),$("#bod").css("cursor","crosshair"))};for(let t in i){let n=i[t];"string"==typeof n?e.events.keypress(e=>{n.toUpperCase().indexOf(String.fromCharCode(e.which).toUpperCase())>-1?s():27==e.which&&($(".PennController-"+this.type+"-palette-selected").removeClass("PennController-"+this.type+"-palette-selected"),$("#bod").css("cursor","default"),this.currentColor=null)}):n._element&&n._element.jQueryElement&&(n._element.jQueryElement.bind("click",s),n._element.jQueryElement.addClass("PennController-"+this.type+"-palette"),n._element.jQueryElement.addClass("PennController-"+this.id+"-palette"),r.push(n._element))}t()},addElement:function(e,...t){for(let e in t){let n=t[e];n._element&&n._element.jQueryElement&&(n._element.jQueryElement.bind("click",()=>{this.select(n._element)}),this.elements.map(e=>e[0]).indexOf(n._element)<0&&this.elements.push([n._element,null]))}e()},callback:function(e,...t){let n=this.select;this.select=async function(e){if(n.apply(this,[e]),this.enabled)for(let e in t)await t[e]._runPromises()},e()},enable:function(e){this.jQueryContainer.removeClass("PennController-disabled"),this.jQueryElement.removeClass("PennController-disabled"),this.enabled=!0,e()},disable:function(e){this.jQueryContainer.addClass("PennController-disabled"),this.jQueryElement.addClass("PennController-disabled"),this.enabled=!1,e()},log:function(e,t){this.log=t||"all",e()},once:function(e){if(this.brushes.length)this.enabled=!1,$(".PennController-"+this.type+"-palette-selected").removeClass("PennController-"+this.type+"-palette-selected"),$("#bod").css("cursor","default"),this.currentColor=null;else{let e=this.select;this.select=t=>{if(e.apply(this,[t]),this.enabled)return this.enabled=!1,$(".PennController-"+this.type+"-palette-selected").removeClass("PennController-"+this.type+"-palette-selected"),$("#bod").css("cursor","default"),this.currentColor=null,"once"}}e()},removeColor:function(e,t){let n=this.colors.indexOf(t);n>-1&&this.colors.splice(n,1),e()}},this.test={color:function(e,t){if(e._element&&e._element){let n=this.elements.map(e=>e[0]).indexOf(e._element);return!(n<0)&&this.elements[n][1]==t}return!1}}}))},function(e,t){window.PennController._AddElementType("Scale",(function(e){function t(){this.jQueryElement.find("input").attr("disabled",!0),this.jQueryElement.find("div,label").css("cursor",""),this.disabled=!0}function n(){this.jQueryElement.find("input").removeAttr("disabled"),this.jQueryElement.find("div").css("cursor","pointer"),this.disabled=!1}function i(e,t){if("slider"==this.scaleType?this.jQueryElement.find("input[type=range]")[0].value=e:this.jQueryElement.find(`input#${this.id}-${e}`).attr("checked",!0).change(),t){let t=this.buttons[e];null!=t&&""!=t||(t=e+1),this.choice(t)}}async function r(){let t=this.defaultValue,n=this.orientation,i=this.scaleType;if(this.jQueryElement.empty(),"slider"==i){var r=$("<input>").attr({type:"range",min:"0",max:String(this.buttons.length-1),value:String((this.buttons.length-1)/2),step:"1"});Number(t)>=0&&Number(t)<=this.buttons.length-1&&r.attr("value",String(t)),this.disabled&&r.attr("disabled",!0),r[0].oninput=()=>{this.firstClick||(this.firstClick=Date.now())},r[0].onchange=()=>this.choice(r[0].value),"vertical"==n&&(r.attr("orient","vertical"),r.css({"writing-mode":"vertical-lr","-webkit-appearance":"slider-vertical"})),r.css({width:"100%",height:"100%"}),this.jQueryElement.append(r)}else{this.jQueryElement.css({display:"inline-flex","justify-content":"space-between"});for(let n=0;n<this.buttons.length;n++){let r=this.buttons[n];(null==r||""==r||r instanceof e.PennElementCommands)&&(r=n+1);let s=$("<label>").attr({for:this.id+"-"+n}).html(r).css("cursor","pointer"),o=$("<input>").attr({name:this.id,value:r,type:"checkbox"==i?"checkbox":"radio",id:this.id+"-"+n}),a=$("<div>").addClass("option").css({cursor:"pointer",display:"flex","align-items":"center"}).append(o).append(s);r._runPromises&&r.print(s.empty())._runPromises(),t!=r&&t!=n||o.attr("checked",!0),this.disabled&&o.attr("disabled",!0),o[0].onchange=()=>{this.choice(this.buttons[n]||r,"checkbox"==i&&!o[0].checked),this.jQueryElement.find("label").css("outline","none"),"buttons"==i&&s.css("outline","dotted 1px black")},"buttons"==i&&o.css("display","none"),"top"==this.labels?a.css("flex-direction","column-reverse"):"bottom"==this.labels?a.css("flex-direction","column"):"left"==this.labels&&a.css("flex-direction","row-reverse"),this.jQueryElement.append(a),"radio"==i&&!1===this.labels?s.css("display","none"):this.buttons[n]instanceof e.PennElementCommands&&await this.buttons[n].print(s.empty())._runPromises()}"vertical"==n&&this.jQueryElement.css("flex-direction","column")}this.width||this.jQueryElement.css("max-width","max-content")}this.immediate=function(e,...t){t.length||(t=[e],void 0!==e&&"string"==typeof e&&0!=e.length||(e="Scale")),this.id=e,"string"!=typeof t[0]&&Number(t[0])>0?this.initialButtons=new Array(Number(t[0])):this.initialButtons=t},this.uponCreation=function(t){this.jQueryElement=$("<div>").css("display","inline-block"),this.choices=[],this.log=!1,this.labels=!1,this.disabled=!1,this.vertical=!1,this.scaleType="radio",this.defaultValue=null,this.orientation="horizontal",this.width=null,this.keys=[],this.buttons=this.initialButtons,this.choice=(e,t)=>{if(this.disabled)return;this.unselected=t||void 0,e&&e._runPromises&&(e=e._element.id);let n=null;"slider"==this.scaleType&&this.firstClick&&(n=Date.now()-this.firstClick,this.firstClick=void 0),this.choices.push([t?"Unselect":"Choice",e,Date.now(),n||"NULL"])},e.controllers.running.safeBind($(document),"keydown",e=>{if(!this.disabled)for(let t=0;t<this.keys.length;t++)if(String.fromCharCode(e.which)==this.keys[t])return i.apply(this,[t,!0])}),t()},this.end=function(){const t=this;if(this.log&&this.log instanceof Array)if("checkbox"==this.scaleType&&this.jQueryElement.find("input[type=checkbox]").each((function(n){e.controllers.running.save(t.type,t.id,t.buttons[n],this.checked?"checked":"unchecked",Date.now(),"Status")})),this.choices.length)if(1==this.choices.length)e.controllers.running.save(this.type,this.id,...this.choices[0]);else if(this.log.indexOf("all")>-1)for(let t in this.choices)e.controllers.running.save(this.type,this.id,...this.choices[t]);else this.log.indexOf("first")>-1&&e.controllers.running.save(this.type,this.id,...this.choices[0]),this.log.indexOf("last")>-1&&e.controllers.running.save(this.type,this.id,...this.choices[this.choices.length-1]);else e.controllers.running.save(this.type,this.id,"Choice","NA","Never","No selection happened")},this.value=function(){return this.choices.length&&void 0===this.unselected?this.choices[this.choices.length-1][1]:NaN},this.actions={print:async function(t,...n){await r.apply(this),e.elements.standardCommands.actions.print.apply(this,[t,...n])},select:function(t,n,r){for(var s=0;s<this.buttons.length;s++){let e=this.buttons[s];if(e&&e==n)break;if(e&&e._element&&e._element.id==n)break;if(s==n)break}if(s>=this.buttons.length)return t(e.debug.error("Option "+n+" not found for selection on Scale "+this.id));i.apply(this,[s,r]),t()},unselect:function(e){if("slider"==this.scaleType){let e=this.jQueryElement.find("input[type=range]")[0];e.value=(e.max-e.min)/2}else this.jQueryElement.find("input").removeAttr("checked").change();this.unselected=!0,e()},wait:function(e,t){if("first"==t&&this.choices.length)e();else{let n=!1,i=this.choice;this.choice=r=>{if(i.apply(this,[r]),!n)if(t instanceof Object&&t._runPromises&&t.success){let i=this.disabled;this.disabled="tmp",t._runPromises().then(t=>{"success"==t&&(n=!0,e()),"tmp"==this.disabled&&(this.disabled=i)})}else n=!0,e()}}}},this.settings={button:async function(e){this.scaleType="buttons",await r.apply(this),e()},callback:function(e,...t){let n=this.choice;this.choice=async function(e){let i=this.disabled;if(n.apply(this,[e]),!i)for(let e in t)await t[e]._runPromises()},e()},checkbox:async function(e){this.scaleType="checkbox",await r.apply(this),e()},default:function(t,n){this.buttons.indexOf(n)>-1||Number(n)>=0&&Number(n)<this.buttons.length?(this.defaultValue=n,n._element&&(n=n._element.id),this.choices.push(["Default",n,Date.now(),this.scaleType])):e.debug.error("Invalid default value for Scale "+this.id,n),t()},disable:function(e){t.apply(this),this.jQueryContainer.addClass("PennController-disabled"),this.jQueryElement.addClass("PennController-disabled"),e()},enable:function(e){n.apply(this),this.jQueryContainer.removeClass("PennController-disabled"),this.jQueryElement.addClass("PennController-disabled"),e()},horizontal:async function(e){this.orientation="horizontal",this.jQueryElement.parent().length&&await r.apply(this),e()},keys:function(t,...n){if(n instanceof Array&&n.length==this.buttons.length){if(n.filter(e=>"string"==typeof e&&1==e.length).length!=n.length)return t(e.debug.error("Every key should be a string of length 1 in Scale "+this.id,n));this.keys=n.map(e=>e.toUpperCase())}else this.buttons.filter(e=>"string"==typeof e&&1==e.length).length==this.buttons.length?this.keys=this.buttons.map(e=>e.toUpperCase()):this.keys=Array.from({length:this.buttons.length},(e,t)=>t+1);t()},label:async function(e,t,n){if(isNaN(Number(t))||t<0||t>=this.buttons.length)return e();this.buttons[t]=n,await r.apply(this),e()},labels:function(e,t){this.labels=t,e()},labelsPosition:async function(e,t){this.labels=t,await r.apply(this),e()},log:function(e,...t){t.length?this.log=t:this.log=["last"],e()},once:function(e){if(this.hasClicked)t.apply(this);else{let e=this.choice;this.choice=n=>{e.apply(this,[n]),t.apply(this)}}e()},radio:async function(e){this.scaleType="radio",await r.apply(this),e()},size:async function(t,n,i){this.width=n,await r.apply(this),e.elements.standardCommands.settings.size.apply(this,[t,n,i])},slider:async function(e){this.scaleType="slider",await r.apply(this),e()},vertical:async function(e){this.orientation="vertical",this.jQueryElement.parent().length&&await r.apply(this),e()}},this.test={selected:function(e){return!(!this.choices.length||this.unselected)&&(null==e||e==this.choices[this.choices.length-1][1])}}}))},function(e,t){window.PennController._AddElementType("Selector",(function(e){async function t(t,...n){let i=[];if(n.length)for(let t in n){if(!(n[t]._element&&n[t]._element.jQueryElement instanceof jQuery)){e.debug.error("Invalid element #"+t+" in shuffling selector "+this.id);continue}let r=this.elements.map(e=>e[0]).indexOf(n[t]._element);r<0?e.debug.error("Cannot shuffle element "+n[t]._element.id+" for it has not been added to selector "+this.id):i.push(r)}else i=[...new Array(this.elements.length)].map((e,t)=>t);let r=[...i];fisherYates(r);const s=[],o=i.map(e=>{const t=this.elements[e][0],n=t._lastPrint;if(void 0===n[0]){const n=t.jQueryContainer;if(n instanceof jQuery&&n.parent().length){const t=$("<span>");n.before(t),s[e]=t}}else if(n[0]instanceof jQuery&&(n[0].hasClass("PennController-after")||n[0].hasClass("PennController-before"))){const e={};let s=n[0][0].className.replace(/^.*PennController-(after|before).*$/,"$1");s=s.replace(/^[ab]/,e=>e.toUpperCase());for(let n=0;n<i.length;n++){const o=this.elements[i[n]][0];if(!(o["jQuery"+s]instanceof Array))continue;const a=o["jQuery"+s].length;if(o["jQuery"+s]=o["jQuery"+s].filter(e=>e._element!=t),o["jQuery"+s].length<a)return e[s]=this.elements[r[n]][0],e}}return n});i.forEach(async e=>{const t=this.elements[e][0];await window.PennController.Elements["get"+t.type](t.id).remove()._runPromises()}),r.forEach(async(e,t)=>{let n=this.elements[e][0],r=o[t];if(void 0===r)return;const a=window.PennController.Elements["get"+n.type](n.id);r.hasOwnProperty("After")?await window.PennController.Elements["get"+r.After.type](r.After.id).after(a)._runPromises():r.hasOwnProperty("Before")?await window.PennController.Elements["get"+r.Before.type](r.Before.id).after(a)._runPromises():await a.print(...r)._runPromises();const l=s[i[t]];l instanceof jQuery&&(n.jQueryContainer.css("position","unset"),l.before(n.jQueryContainer),l.remove())});const a=[...this.elements];i.forEach((e,t)=>this.elements[e]=a[r[t]]),t()}this.immediate=function(e){void 0!==e&&"string"==typeof e&&0!=e.length||(e="Selector"),this.id=e},this.uponCreation=function(t){this.elements=[],this.selections=[],this.disabled=!1,this.frame=$("<div>").css({position:"absolute",display:"inline-block",margin:"auto",outline:"dotted 1px grey","z-index":100}).addClass("PennController-"+this.type.replace(/[\s_]/g,"")+"-selectionFrame"),this.noClick=!1,this.select=t=>{if(!this.disabled){if(this.elements.map(e=>e[0]).indexOf(t)<0)return e.debug.error("Tried to select an element not part of Selector "+this.id);this.selections.push(["Selection",t.id,Date.now(),this.elements.map(e=>e[0].id).join(";")]),this.frame.css({width:t.jQueryElement.outerWidth(),height:t.jQueryElement.outerHeight(),"pointer-events":"none"}),"absolute"==t.jQueryElement.css("position")&&this.frame.css({left:t.jQueryElement.css("left"),top:t.jQueryElement.css("top")}),t.jQueryElement.before(this.frame),this.elements.map(e=>e[0].jQueryElement.removeClass("PennController-"+this.type.replace(/[\s_]/g,"")+"-selected")),t.jQueryElement.addClass("PennController-"+this.type.replace(/[\s_]/g,"")+"-selected")}},e.events.keypress(e=>{if(!this.disabled)for(let t=0;t<this.elements.length;t++){let n="";this.elements[t].length>1&&(n=this.elements[t][1]);let i=e.key.isSpecialKey(),r=e.key.toUpperCase(),s={0:"",1:"LEFT",2:"RIGHT"};if(i===n.replace(/^(Left|Right)/i,"").isSpecialKey()&&(n.toUpperCase()==r||n.toUpperCase()==s[e.location]+r))return this.select(this.elements[t][0])}}),t()},this.end=function(){if(this.select=()=>{},this.frame&&this.frame instanceof jQuery&&this.frame.remove(),this.log&&this.log instanceof Array)if(this.selections.length)if(1==this.selections.length)e.controllers.running.save(this.type,this.id,...this.selections[0]);else if(this.log.indexOf("all")>-1)for(let t in this.selections)e.controllers.running.save(this.type,this.id,...this.selections[t]);else this.log.indexOf("first")>-1&&e.controllers.running.save(this.type,this.id,...this.selections[0]),this.log.indexOf("last")>-1&&e.controllers.running.save(this.type,this.id,...this.selections[this.selections.length-1]);else e.controllers.running.save(this.type,this.id,"Selection","NA","Never",this.elements.map(e=>e[0].id).join(";")+";No selection happened");this.elements=[]},this.value=function(){if(this.selections.length){let e=this.selections[this.selections.length-1][1],t=this.elements.filter(t=>t[0].id==e);return t.length?(t=t[0][0],window.PennController.Elements["get"+t.type](t.id)):null}return null},this.actions={select:function(t,n){if(!isNaN(Number(n))&&Number(n)>=0&&Number(n)<this.elements.length&&(n={_element:this.elements[Number(n)][0]}),n._element&&n._element.jQueryElement instanceof jQuery){let e=this.disabled;this.disabled=!1,this.select(n._element),this.disabled=e}else e.debug.error("Invalid element passed to select command for selector "+this.id);t()},shuffle:function(e,...n){t.apply(this,[e].concat(n))},unselect:function(e){this.selections.push(["Unselect","Unselect",Date.now(),this.elements.map(e=>e[0].id).join(";")+";From script"]),this.frame.detach(),this.elements.map(e=>e[0].jQueryElement.removeClass("PennController-"+this.type+"-selected")),e()},wait:function(e,t){if("first"==t&&this.selections.length)e();else{let n=!1,i=this.select;this.select=r=>{let s=i.apply(this,[r]);if(!(n||this.disabled&&!s))if(t instanceof Object&&t._runPromises&&t.success){let i=this.disabled;this.disabled="tmp",t._runPromises().then(t=>{"success"==t&&(n=!0,e()),"tmp"==this.disabled&&(this.disabled=i)})}else n=!0,e()}}}},this.settings={add:function(t,...n){for(w in n){let t=n[w]._element;if(null==t||null==t.id)e.debug.error("Invalid element added to selector "+this.id);else if(this.elements.map(e=>e[0]).indexOf(t)>-1)e.debug.error("Element "+t.id+" already part of selector "+this.id);else if(null!=t.jQueryElement&&t.jQueryElement instanceof jQuery){this.elements.push([t]);let e=()=>{this.noClick||t.jQueryElement.css("cursor","pointer");let e=t.jQueryElement[0].onclick;t.jQueryElement[0].onclick=(...n)=>{e instanceof Function&&e.apply(t.jQueryElement[0],n),this.noClick||this.select(t)}};t.jQueryElement.parent().length?e():t._printCallback.push(e)}else e.debug.error("Element "+t.id+" has no visble element to be chosen in selector "+this.id)}t()},callback:function(e,...t){let n=this.select;this.select=async function(e){let i=this.disabled;if(n.apply(this,[e]),!i)for(let e in t)await t[e]._runPromises()},e()},disable:function(e){this.disabled=!0,this.elements.map(e=>e[0].jQueryElement.css("cursor","")),this.jQueryContainer.addClass("PennController-disabled"),this.jQueryElement.addClass("PennController-disabled"),e()},disableClicks:function(e){this.noClick=!0,this.elements.map(e=>e[0].jQueryElement.css("cursor","")),e()},enable:function(e){this.disabled=!1,this.noClick||this.elements.map(e=>e[0].jQueryElement.css("cursor","pointer")),this.jQueryContainer.removeClass("PennController-disabled"),this.jQueryElement.removeClass("PennController-disabled"),e()},enableClicks:function(e){this.noClick=!1,this.elements.map(e=>e[0].jQueryElement.css("cursor","pointer")),e()},frame:function(e,t){this.frame.css.apply(this.frame,["outline",t]),e()},keys:function(e,...t){for(let e=0;e<t.length;e++){let n=t[e];if(e>=this.elements.length)break;"string"!=typeof n&&Number(n)>0&&(n=String.fromCharCode(n)),this.elements[e]=[this.elements[e][0],n]}e()},log:function(e,...t){t.length?this.log=t:this.log=["last"],e()},once:function(e){if(this.selections.length)this.disabled=!0,this.elements.map(e=>e[0].jQueryElement.css("cursor",""));else{let e=this.select;this.select=t=>{if(e.apply(this,[t]),!this.disabled)return this.disabled=!0,this.elements.map(e=>e[0].jQueryElement.css("cursor","")),"once"}}e()},shuffle:function(e,...n){t.apply(this,[e].concat(n))}},this.test={selected:function(t){if(0===this.selections.length)return!1;let n=this.selections[this.selections.length-1][1];return null==t?this.selections.length>0:"string"==typeof t?t==n:t._element?t._element.id==n:(e.debug.error("Invalid element tested for Selector "+this.id,t._element.id),!1)},index:function(t,n){return null==t||null==t._element?e.debug.error("Invalid element tested for selector "+this.id,t._element.id):Number(n)>=0?this.elements.map(e=>e[0]).indexOf(t._element)==Number(n):this.elements.map(e=>e[0]).indexOf(t._element)>=0}}})),window.PennController._AddStandardCommands((function(e){this.settings={selector:async function(t,n){var i;if("string"==typeof n){let t=e.controllers.running.options.elements;if(!t.hasOwnProperty("Selector")||!t.Selector.hasOwnProperty(n))return e.debug.error("No selector found named "+n);i=t.Selector[n]}else n._element&&n._runPromises&&("Selector"==n._element.type?(await n._runPromises(),i=n._element):e.debug.error("Tried to add "+this.name+" to an invalid Selector"));if(i.elements.map(e=>e[0]).indexOf(this)>-1)e.debug.error("Element "+this.id+" already part of Selector "+i.id);else if(null!=this.jQueryElement&&this.jQueryElement instanceof jQuery){i.elements.push([this]),this.noClick||this.jQueryElement.css("cursor","pointer");let e=this.jQueryElement[0].onclick;this.jQueryElement[0].onclick=(...t)=>{e instanceof Function&&e.apply(this.jQueryElement[0],t),i.noClick||i.select(this)}}else e.debug.error("Element "+this.id+" has no visble element to be chosen in Selector "+i.id);t()}}}))},function(e,t){window.PennController._AddElementType("Text",(function(e){this.immediate=function(e,t){void 0===t&&(t=e),this.id=e,t=t.replace(/(^\s|\s$)/,"&nbsp;"),this.initialText=t,this.text=t},this.uponCreation=function(e){this.jQueryElement=$("<span>"+this.initialText+"</span>").css("display","inline-block"),e()},this.value=function(){return this.text},this.end=function(){this.log&&(this.printTime?e.controllers.running.save(this.type,this.id,"Print","NA",this.printTime,"NULL"):e.controllers.running.save(this.type,this.id,"Print","NA","Never","NULL"))},this.actions={unfold:function(t,n){let i=()=>{let e=Number(n);if(e>0){let t=Date.now();this.jQueryElement.css("visibility","visible");let n=this.jQueryElement.width(),i=$("<div>").css({display:"inline-block","overflow-x":"hidden",width:0,margin:0,padding:0,"white-space":"nowrap"});i=this.jQueryElement.wrap(i).parent();let r=0,s=()=>{let o=(Date.now()-t)/e;o>=1&&(o=1);let a=Math.round(n*o);a>r&&i.width(a),r=a,o<1&&window.requestAnimationFrame(s)};window.requestAnimationFrame(s)}};this.jQueryContainer instanceof jQuery&&this.jQueryContainer.parent().length?i():e.elements.standardCommands.actions.print.call(this,i),t()}},this.settings={text:function(t,n){n instanceof e.PennElementCommands&&(n=n.value),this.text=n,this.jQueryElement.html(n),t()}},this.test={text:function(e){return e instanceof RegExp?this.text.match(e):e==this.text}}}))},function(e,t){window.PennController._AddElementType("TextInput",(function(e){this.immediate=function(e,t){void 0!==e&&"string"==typeof e&&0!=e.length||(e="TextInput"),this.initialText=t,this.id=e},this.uponCreation=function(e){this.text=this.initialText,this.jQueryElement=$("<textarea>"),this.jQueryElement.attr({name:this.id,rows:1,cols:40}).val(this.text),this.rows=1,this.disabled=!1,this.log=[],this.types=[],this.validations=[],this.entered=!1,this.pressEnter=()=>{this.entered=!0,this.validations.push(["EnterReturn",this.jQueryElement.val(),Date.now(),"NULL"])},this.jQueryElement[0].addEventListener("keydown",e=>{let t=this.jQueryElement.val();if(this.types.push(["Type",t,Date.now(),e.key]),"Enter"==e.key)if(this.pressEnter(),1==this.rows)e.preventDefault();else if(this.rows>1){let n=t.match(/[\r\n]/g);n instanceof Array&&n.length+1>=this.rows&&e.preventDefault()}}),this.jQueryElement[0].addEventListener("keypress",e=>{if("Enter"==e.key&&this.rows>0){let t=this.jQueryElement.val().match(/[\r\n]/g);t instanceof Array&&t.length+1>=this.rows&&e.preventDefault()}e.key.isSpecialKey()||this.length!=this.jQueryElement.val().length||this.jQueryElement[0].selectionStart!=this.jQueryElement[0].selectionEnd||e.preventDefault()}),this.jQueryElement[0].addEventListener("keyup",e=>{let t=this.jQueryElement.val();this.length&&t.length>this.length&&this.jQueryElement.val(t.substr(0,this.length));let n=t.match(/[\r\n]/g);if(this.rows>0&&n instanceof Array&&n.length>=this.rows+1){let e="([\\n\\r]?[^\\n\\r]*){"+this.rows+"}";this.jQueryElement.val(t.match(RegExp(e))[0])}}),this.jQueryElement[0].addEventListener("paste",e=>{let t=this.jQueryElement.val(),n=(e.clipboardData||window.clipboardData).getData("Text"),i=this.jQueryElement[0].selectionStart,r=t.substring(0,i)+n+t.substring(this.jQueryElement[0].selectionEnd,t.length),s=r.match(/[\r\n]/g);if(this.rows>0&&s instanceof Array&&s.length>=this.rows){let t="([\\n\\r]?[^\\n\\r]*){"+this.rows+"}";r=r.match(RegExp(t))[0],this.jQueryElement.val(r),e.preventDefault()}this.length>0&&r.length>=this.length&&(this.jQueryElement.val(r.substring(0,this.length)),e.preventDefault())}),e()},this.end=function(){if(this.log&&this.log instanceof Array)if(this.log.indexOf("all")>-1){let t=Date.now();if(e.controllers.running.save(this.type,this.id,"Final",csv_url_encode(this.jQueryElement.val()),t,"All saved, see documentation"),this.types.length){e.controllers.running.save(this.type,this.id,"NTypingEvents",this.types.length,t,"All saved, see documentation");let n=[],i=[],r=[];this.types.map(e=>{n.push(csv_url_encode(e[1])),i.push(e[2]),r.push(e[3])}),e.controllers.running.save(this.type,this.id,"TypingEvent","Keys","NULL",...r),e.controllers.running.save(this.type,this.id,"TypingEvent","Texts","NULL",...n),e.controllers.running.save(this.type,this.id,"TypingEvent","Times","NULL",...i)}for(let t in this.validations)this.validations[t][1]=csv_url_encode(this.validations[t][1]),e.controllers.running.save(this.type,this.id,...this.validations[t])}else{if(this.log.indexOf("validate")>-1)for(let t in this.validations)this.validations[t][1]=csv_url_encode(this.validations[t][1]),e.controllers.running.save(this.type,this.id,...this.validations[t]);if(this.log.indexOf("final")>-1&&e.controllers.running.save(this.type,this.id,"Final",csv_url_encode(this.jQueryElement.val()),Date.now(),"NULL"),this.log.indexOf("first")>-1&&this.types.length){let t=[].concat(this.types[0]);t[0]="First",t[1]=csv_url_encode(t[1]),e.controllers.running.save(this.type,this.id,...t)}if(this.log.indexOf("last")>-1&&this.types.length){let t=[].concat(this.types[this.types.length-1]);t[0]="Last",t[1]=csv_url_encode(t[1]),e.controllers.running.save(this.type,this.id,...t)}}},this.value=function(){return this.jQueryElement.val()},this.actions={callback:function(t,...n){let i=this.pressEnter;this.pressEnter=()=>{i.apply(this),n.forEach(async t=>{t instanceof Function?await t.apply(this):t instanceof e.PennElementCommands&&await t._runPromises()})},t()},print:function(t,...n){e.elements.standardCommands.actions.print.apply(this,[()=>{this.jQueryElement.focus(),t()},...n])},wait:function(e,t){if("first"==t&&this.entered)e();else{let n=!1,i=this.pressEnter;this.pressEnter=()=>{if(i.apply(this),!n)if(t instanceof Object&&t._runPromises&&t.success){let i=this.disabled;this.disabled="tmp",t._runPromises().then(t=>{"success"==t&&(n=!0,e()),"tmp"==this.disabled&&(this.disabled=i)})}else n=!0,e()}}}},this.settings={length:function(e,t){this.length=Number(t),isNaN(this.length)&&(this.length=0),e()},lines:function(e,t){this.rows=Number(t),isNaN(this.rows)&&(this.rows=0),this.jQueryElement.attr("rows",this.rows),e()},log:function(t,...n){n.length||(n=["final","validate","first"]),this.log=n,n.indexOf("all")>-1&&e.debug.warning("<div style='color:red;'>Now logging all typing events in inputText element "+this.id+": this can drastically increase the weight of the results file</div>"),t()},once:function(e){if(this.entered)this.jQueryElement.attr("disabled",!0);else{let e=this.pressEnter;this.pressEnter=function(){e.apply(this),this.jQueryElement.attr("disabled",!0)}}e()},text:function(e,t){this.text=t,this.jQueryElement.val(t),e()}},this.test={text:function(e){return e instanceof RegExp?this.jQueryElement.val().match(e):this.jQueryElement.val()==e}}}))},function(e,t){window.PennController._AddElementType("Timer",(function(e){this.immediate=function(t,n){void 0===n&&Number(t)>0&&(n=t,void 0!==t&&"string"==typeof t&&0!=t.length||(t="Timer")),this.id=t,this.initialDuration=0,Number(n)>0?this.initialDuration=Number(n):e.debug.error("Invalid duration for Timer &quot;"+t+"&quot;")},this.uponCreation=function(e){this.elapsed=!1,this.events=[],this.log=!1,this.running=!1,this.duration=this.initialDuration,this.start=()=>{this.startTime=Date.now(),this.running=!0,this.events.push(["Start","Start",this.startTime,"NULL"]);let e=()=>{this.running&&(Date.now()-this.startTime>=this.duration?this.done():setTimeout(e,0))};e()},this.done=()=>{this.running=!1,this.events.push(["End","End",Date.now(),"NULL"]),this.elapsed=!0,this.startTime=null},e()},this.end=function(){if(this.running&&(this.running=!1,this.events.push(["End","NA","Never","Had to halt the timer at the end of the trial"])),this.log)for(let t in this.events)e.controllers.running.save(this.type,this.id,...this.events[t])},this.value=function(){return this.elapsed},this.actions={pause:function(e){this.running&&(this.running=!1,this.pausedTimestamp=Date.now(),this.events.push(["Pause","Pause",this.pausedTimestamp,"NULL"])),e()},resume:function(e){if(!this.running&&this.pausedTimestamp){this.resumedTimestamp=Date.now();const e=this.resumedTimestamp-this.pausedTimestamp,t=this.startTime+e;this.events.push(["Resume","Resume",this.resumedTimestamp,"NULL"]),this.start(),this.startTime=t}e()},set:function(t,n){const i=Number(n);isNaN(i)||i<0?e.debug.error(`Invalid duration passed for timer ${this.id} (&quot;${n}&quot;)`):this.duration=i,t()},start:function(e){this.start(),e()},stop:function(e){this.running&&this.done(),e()},wait:function(e,t){if("first"==t&&this.elapsed)e();else{let n=!1,i=this.done;this.done=()=>{i.apply(this),n||(t instanceof Object&&t._runPromises&&t.success?t._runPromises().then(t=>{"success"==t&&(n=!0,e())}):(n=!0,e()))}}}},this.settings={callback:function(e,...t){let n=this.done;this.done=async function(){n.apply(this);for(let e in t)await t[e]._runPromises()},e()},log:function(e){this.log=!0,e()}},this.test={ended:function(){return this.elapsed},running:function(){return this.running}}}))},function(e,t){window.PennController._AddElementType("Tooltip",(function(e){function t(){this.jQueryElement.remove(),this.jQueryContainer instanceof jQuery&&this.jQueryContainer.detach(),this.frame&&this.frame instanceof jQuery&&this.frame.detach()}this.immediate=function(e,t,n){void 0===t&&(t=e),this.initialText=t,this.initialLabel=n,void 0!==e&&"string"==typeof e&&0!=e.length||(e="Tooltip"),this.id=e},this.uponCreation=function(e){this.text=this.initialText,"string"==typeof this.initialLabel&&this.initialLabel.length?this.label=this.initialLabel:this.label="OK",this.resetLabel=!1,this.jQueryElement=$("<div>").html(this.text),this.jQueryContainer=void 0,this.jQueryLabel=$("<a>").html(this.label),this.validations=[],this.frame=$("<div>").addClass("PennController-"+this.type.replace(/[\s_]/g,"")+"-tooltip-frame"),this.jQueryElement.addClass("PennController-"+this.type.replace(/[\s_]/g,"")+"-tooltip"),this.jQueryElement.addClass("PennController-"+this.id.replace(/[\s_]/g,"")),this.jQueryElement.css({background:"floralwhite",position:"relative"}),this.jQueryLabel.css({border:"dotted 1px gray",cursor:"pointer",position:"absolute",bottom:"2px",right:"2px"}),this.wasValidated=!1,this.disabled=!1,this.log=!1,this.validate=()=>{this.delayedPrinting||this.disabled||(this.wasValidated=!0,this.validations.push(["Validate","Validate",Date.now(),"NULL"]),t.apply(this))},e()},this.end=function(){if(this.jQueryElement&&this.jQueryElement instanceof jQuery&&t.apply(this),this.log)for(let t in this.validations)e.controllers.running.save(this.type,this.id,...this.validations[t])},this.value=function(){return this.wasValidated},this.actions={print:async function(t,n,...i){if(n&&n.hasOwnProperty("_element")&&n._element.jQueryElement instanceof jQuery&&(n=n._element.jQueryElement),this.jQueryElement.append(this.jQueryLabel),this.jQueryLabel.click(()=>{this.noClicks||this.validate()}),this.jQueryElement.css("text-align","left"),n instanceof jQuery){n.before(this.jQueryElement);let e=n.width(),i=n.height();this.jQueryElement.css({position:"absolute",display:"inline-block",visibility:"hidden",overflow:"auto",top:"auto",left:"auto","margin-top":1+i,"margin-left":1+e,"z-index":9999,padding:"1px"}),this.frameParent&&n.before(this.frame.css({position:"absolute",display:"inline-block",width:e,height:i,border:this.frameParent,"z-index":100,"pointer-events":"none"}));let r=n.css("top"),s=n.css("left");if("0px"==r&&(r="auto"),"0px"==s&&(s="auto"),this.jQueryElement.css({left:s,top:r}),this.frame.css({left:s,top:r}),this.jQueryElement.addClass("PennController-"+this.type.replace(/[\s_]/g,"")),"none"!=this.jQueryLabel.css("display")&&this.jQueryElement.css("padding-bottom","20px"),this.relativePosition){let e=()=>this.relativePosition.match(/top/i)?-1*this.jQueryElement.outerHeight()-1:this.relativePosition.match(/middle/i)?.5*(n.height()-this.jQueryElement.outerHeight()):n.height()+1,i=()=>this.relativePosition.match(/left/i)?-1*this.jQueryElement.outerWidth()-1:this.relativePosition.match(/center/i)?.5*(n.width()-this.jQueryElement.outerWidth()):n.width()+1;this.delayedPrinting=!0,setTimeout(()=>{this.jQueryElement.css({"margin-top":e(),"margin-left":i()}),setTimeout(()=>{this.jQueryElement.css({"margin-top":e(),"margin-left":i(),visibility:"visible"}),this.delayedPrinting=!1,t()})})}else this.jQueryElement.css("visibility","visible"),t()}else i.length>1?this.jQueryContainer=void 0:this.jQueryContainer=$("<div>"),await new Promise(t=>e.elements.standardCommands.actions.print.apply(this,[t,n,...i])),this.jQueryElement.css({position:"relative",left:"",top:"",margin:0,display:"inline-block"}),"none"!=this.jQueryLabel.css("display")&&this.jQueryElement.css("padding-bottom","20px"),t()},remove:function(e){t.apply(this),e()},wait:function(e,t){if("first"==t&&this.wasValidated)e();else{let n=!1,i=this.validate;this.validate=()=>{if(i.apply(this),!n)if(t instanceof Object&&t._runPromises&&t.success){let i=this.disabled;this.disabled="tmp",t._runPromises().then(t=>{"success"==t&&(n=!0,e()),"tmp"==this.disabled&&(this.disabled=i)})}else n=!0,e()}}}},this.settings={disable:function(e){this.disabled=!0,this.jQueryContainer.addClass("PennController-disabled"),this.jQueryElement.addClass("PennController-disabled"),e()},enable:function(e){this.disabled=!1,this.jQueryContainer.removeClass("PennController-disabled"),this.jQueryElement.removeClass("PennController-disabled"),e()},frame:function(e,t){"string"==typeof t&&t.length?this.frameParent=t:this.frameParent="dotted 1px gray",e()},key:function(t,n,i){" "==n||isNaN(Number(n))||(n=String.fromCharCode(n)),"string"!=typeof n&&t(e.debug.error("Invalid key(s) passed to Tooltip &quot;"+id+"&quot; (should be a string or a key code number)",n)),n=n.toUpperCase(),e.events.keypress(e=>{if(!this.jQueryElement.parent().length)return;let t=e.key.isSpecialKey(),i=e.key.toUpperCase();(void 0===n||0==n.length||t&&(n==i||n=={0:"",1:"LEFT",2:"RIGHT"}[e.location]+i)||!t&&n.indexOf(i)>-1)&&this.validate()}),i&&(this.noClicks=!0,this.jQueryLabel.css("cursor",""),this.initialLabel||this.resetLabel||this.jQueryLabel.css("display","none")),t()},label:function(e,t){this.label=t,this.resetLabel=!0,"string"!=typeof t||t.match(/^[\s\t]*$/)?this.jQueryLabel.css("display","none"):(this.jQueryLabel.html(t),this.jQueryLabel.css("display","inherit")),e()},log:function(e){this.log=!0,e()},position:function(e,t){this.relativePosition=t,e()},text:function(e,t){this.text=t,this.jQueryElement.html(t),this.jQueryElement.append(this.jQueryLabel),this.jQueryLabel.click(()=>{this.noClicks||this.validate()}),"none"!=this.jQueryLabel.css("display")&&this.jQueryElement.css("padding-bottom","20px"),e()}}}))},function(e,t){!function(){var e=null;let t=window.PennController.ResetPrefix;window.PennController.ResetPrefix=function(n){t(n),e="string"==typeof n?window[n]:window};let n={};window.PennController._AddElementType("Var",(function(t){this.immediate=function(i,r){(t=>{let n=window.PennController.Elements.getVar;window.PennController.Elements.getVar=function(e){let i=t.controllers.underConstruction;if(t.controllers.running&&(i=t.controllers.list[t.controllers.running.id]),i.elements.hasOwnProperty("Var")&&i.elements.Var.hasOwnProperty(e))return n(e);{let t=window.PennController.Elements.newVar(e).settings.global();return t._element.scope="global",t}},e&&(e.getVar=window.PennController.Elements.getVar)})(t);let s=t.controllers.underConstruction;if(t.controllers.running&&(s=t.controllers.list[t.controllers.running.id]),s.elements.hasOwnProperty("Var")&&s.elements.Var.hasOwnProperty(i)){"global"==s.elements.Var[i].scope&&delete s.elements.Var[i]}this.scope="local",this.initialValue=r,this._value=r,this.getter=()=>"local"==this.scope?this._value:n[this.id],this.setter=e=>{"local"==this.scope?this._value=e:n[this.id]=e},Object.defineProperty(this,"value",{get:this.getter,set:this.setter}),this.evaluate=()=>this.value&&"Var"===this.value.type?this.value.evaluate():this.value},this.uponCreation=function(e){this.scope="local",this.value=this.initialValue,this.values=[],e()},this.end=function(){if(this.log&&this.log instanceof Array&&(this.log.indexOf("final")>-1&&t.controllers.running.save(this.type,this.id,"Final",this.value,Date.now(),"Value at the end of the trial"),this.log.indexOf("set")>-1)){for(let e in this.values)t.controllers.running.save(this.type,this.id,...this.values[e]);this.values.length||t.controllers.running.save(this.type,this.id,"Set","NA","Never","The Var element was never set during the trial")}},this.value=function(){return this.evaluate()},this.actions={set:function(e,t){"object"==typeof t&&t.hasOwnProperty("value")?this.value=t.value:this.value=t instanceof Function?t.call(this,this.value):t,void 0===this.values&&(this.values=[]),this.values.push(["Set",this.value,Date.now(),"NULL"]),e()}},this.settings={local:function(e){this.scope="local",e()},log:function(e,...t){t.length?this.log=t:this.log=["final"],e()},global:function(e){n.hasOwnProperty(this.id)||(n[this.id]=this.value),this.scope="global",e()}},this.test={is:function(e){let t=this.evaluate();return e&&e.value&&(e=e.value),e&&e._element&&(e=e._element),t&&t._element&&(t=t._element),e instanceof RegExp&&"text"==typeof t?t.match(e):e instanceof Function?e(t):t==e}}})),window.PennController._AddStandardCommands((function(e){this.actions={setVar:function(t,i){if("string"==typeof i){if(!e.controllers.running.options.elements.hasOwnProperty("Var"))return e.debug.error("No Var element named "+i+" found");let t=e.controllers.running.options.elements.Var[i];if(t)t.value=window.PennController.Elements["get"+this.type](this).value;else{if(!n[i])return e.debug.error("No Var element named "+i+" found");n[i].value=window.PennController.Elements["get"+this.type](this).value}}else e.debug.error("Invalid variable reference when trying to store "+this.id+"'s value",i);t()}}}))}()},function(e,t){window.PennController._AddElementType("Video",(function(e){this.immediate=function(t,n){"string"==typeof t&&void 0===n&&(n=t);let i=!n.match(/^http/i);this.resource=e.resources.fetch(n,(function(e){this.object=document.createElement("video"),this.object.muted=!0;let t=!1;const n=()=>{if(t=!0,this.object.buffered.length&&this.object.seekable.length){if(this.object.buffered.end(0)==this.object.seekable.end(0))return this.object.pause(),this.object.currentTime=0,this.object.muted=!1,resolved=!0,e();this.object.muted=!0,this.object.play()}return window.requestAnimationFrame(n),!0};this.object.addEventListener("progress",()=>t||n()),this.object.src=this.value,this.object.load()}),i),void 0!==t&&"string"==typeof t&&0!=t.length||(t="Video"),this.id=t},this.uponCreation=function(e){this.resource.object.controls=!0,this.video=this.resource.object,this.hasPlayed=!1,this.disabled=!1,this.resource.object.style=null,this.resource.object.currentTime=0,this.jQueryElement=$(this.video),this.jQueryElement.removeClass(),this.jQueryDisable=null,this.playEvents=[],this.endEvents=[],this.pauseEvents=[],this.seekEvents=[],this.bufferEvents=[],this.whatToSave=[],this.resource.object.onplay=()=>{this.playEvents.push(["play",this.video.currentTime,Date.now()])},this.resource.object.onended=()=>{this.hasPlayed=!0,this.endEvents.push(["end",this.video.currentTime,Date.now()])},this.resource.object.onpause=()=>{this.pauseEvents.push(["pause",this.video.currentTime,Date.now()])},this.resource.object.onseeked=()=>{this.seekEvents.push(["seek",this.video.currentTime,Date.now()])},this.resource.object.onwaiting=()=>{this.bufferEvents.push(["buffer",this.video.currentTime,Date.now()])},this.printDisable=e=>{void 0===e&&(e=this.disabled),(!0===e||isNaN(Number(e)))&&(e=.5),this.jQueryDisable instanceof jQuery&&this.jQueryDisable.remove(),this.jQueryDisable=$("<div>").css({position:"absolute",display:"inline-block","background-color":"gray",opacity:e,width:this.jQueryElement.width(),height:this.jQueryElement.height()}),this.jQueryElement.before(this.jQueryDisable),this.jQueryElement.removeAttr("controls")},e()},this.end=function(){if(this.whatToSave&&this.whatToSave.indexOf("play")>-1){this.playEvents.length||e.controllers.running.save(this.type,this.id,"play","NA","Never");for(let t in this.playEvents)e.controllers.running.save(this.type,this.id,...this.playEvents[t])}if(this.whatToSave&&this.whatToSave.indexOf("end")>-1){this.endEvents.length||e.controllers.running.save(this.type,this.id,"end","NA","Never");for(let t in this.endEvents)e.controllers.running.save(this.type,this.id,...this.endEvents[t])}if(this.whatToSave&&this.whatToSave.indexOf("pause")>-1){this.pauseEvents.length||e.controllers.running.save(this.type,this.id,"pause","NA","Never");for(let t in this.pauseEvents)e.controllers.running.save(this.type,this.id,...this.pauseEvents[t])}if(this.whatToSave&&this.whatToSave.indexOf("seek")>-1){this.seekEvents.length||e.controllers.running.save(this.type,this.id,"seek","NA","Never");for(let t in this.seekEvents)e.controllers.running.save(this.type,this.id,...this.seekEvents[t])}if(this.bufferEvents)for(let t in this.bufferEvents)e.controllers.running.save(this.type,this.id,...this.bufferEvents[t]);this.jQueryDisable&&this.jQueryDisable.remove()},this.value=function(){return this.endEvents.length?this.endEvents[this.endEvents.length-1][2]:0},this.actions={play:function(t){this.hasOwnProperty("video")&&this.video.nodeName&&"VIDEO"==this.video.nodeName?this.video.play():e.debug.error("No video to play for Video ",this.id),t()},pause:function(e){this.video.pause(),e()},print:function(t,...n){e.elements.standardCommands.actions.print.apply(this,[()=>{this.disabled&&this.printDisable(this.disabled),t()},...n])},stop:function(e){this.video.pause(),this.video.currentTime=0,e()},wait:function(e,t){if("first"==t&&this.hasPlayed)e();else{let n=!1,i=this.video.onended;this.video.onended=function(...r){if(i.apply(this,r),!n)if(t instanceof Object&&t._runPromises&&t.success){let i=this.disabled;this.disabled="tmp",t._runPromises().then(t=>{"success"==t&&(n=!0,e()),"tmp"==this.disabled&&(this.disabled=i)})}else n=!0,e()}}}},this.settings={disable:function(e,t){(isNaN(t)||null===t)&&(t=!0),this.disabled=t,this.printDisable(t),this.jQueryContainer.addClass("PennController-disabled"),this.jQueryElement.addClass("PennController-disabled"),e()},enable:function(e){this.jQueryDisable instanceof jQuery&&(this.disabled=!1,this.jQueryDisable.remove(),this.jQueryDisable=null,this.jQueryContainer.addClass("PennController-disabled"),this.jQueryElement.addClass("PennController-disabled"),this.jQueryElement.attr("controls",!0)),e()},once:function(e){if(this.hasPlayed)this.disabled=!0,this.printDisable();else{let e=this.video.onended,t=this;this.video.onended=function(...n){e.apply(this,n),t.disabled=!0,t.printDisable()}}e()},log:function(e,...t){1==t.length&&"string"==typeof t[0]?this.whatToSave.push(t):t.length>1?this.whatToSave=this.whatToSave.concat(t):this.whatToSave=["play","end","pause","seek"],e()}},this.test={hasPlayed:function(){return this.hasPlayed},playing:function(){return this.video.currentTime&&!this.video.paused}}}))},function(e,t){window.PennController._AddElementType("MediaRecorder",(function(e){let t,n,i="This experiment collects recording samples from its participants. Your browser should now be prompting a permission request to use your recording device (if applicable). By giving your authorization to record, and by participating in this experiment, you are giving permission to the designer(s) of this experiment to anonymously collect the samples recorded during this experiment. The recordings will be uploaded to, and hosted on, a server designated by the experimenter(s). If you accept the request, a label will remain visible at the top of this window throughout the whole experiment, indicating whether you are currently being recorded.",r="By clicking this link I understand that I grant this experiment's script access to my recording device for the purpose of uploading recordings to the server designated by the experimenter(s).",s=e=>i=e,o={audio:null,video:null,onlyvideo:null},a=[],l="",u=!1,h=!1,c=[],d=new Map,f=[],p=[];const m=()=>new Promise(e=>setTimeout(()=>0==p.length&&e()||m(),10));let g=!1,y=!1;const b={audio:{"audio/webm":"webm","audio/ogg":"ogg"},video:{"video/webm":"webm","video/mp4":"mp4"}};function w(e){const t=b[e];for(let e in t)if(MediaRecorder.isTypeSupported(e))return{mimeType:e,extension:t[e]}}window.PennController.InitiateRecorder=function(a,h,p){if(void 0===window.MediaRecorder)return e.debug.error("This browser does not support audio recording"),alert("Your browser does not support audio recording");"string"!=typeof a&&e.debug.error("MediaRecorder's save URL is incorrect",a),l=a,u=!0;let m=e.controllers.new();m.id="InitiateRecorder",m.runHeader=!1,m.runFooter=!1,e.controllers.list.pop(),e.tmpItems.push(m),"string"==typeof h&&h.length&&s(h),"string"==typeof p&&p.length&&s(p),m.sequence=()=>new Promise(s=>{let a=e.controllers.running;if(!navigator.mediaDevices)return a.element.append($("<p>Sorry, you cannot complete this experiment because your browser does not support recording.</p>"));a.element.append($("<p>"+i+"</p>"));let l={};g&&(l.audio=!0),y&&(l.video=!0);let u=[];navigator.mediaDevices.getUserMedia(l).then((function(e){if(g){let t=e;y&&(t=t.clone(),t.getVideoTracks().map(e=>t.removeTrack(e))),o.audio=new MediaRecorder(t,{mimeType:w("audio").mimeType})}if(y){let t=e.clone();t.getAudioTracks().map(e=>t.removeTrack(e)),o.onlyvideo=t,o.video=new MediaRecorder(e,{mimeType:w("video").mimeType})}[o.audio,o.video].map(e=>{null!==e&&(e.recording=!1,e.onstop=function(i){n.css({"font-weight":"normal",color:"black","background-color":"lightgray"}),n.html("Not recording");let r=w(t.mediaType).mimeType;t.mediaPlayer.srcObject=null,t.blob=new Blob(u,{type:r}),t.mediaPlayer.src=URL.createObjectURL(t.blob),u=[];const s=d.get(t);for(;s&&s instanceof Array&&s.length;)s.shift().call();e.recording=!1},e.onstart=function(i){n.css({"font-weight":"bold",color:"white","background-color":"red"}),n.html("Recording..."),"video"==t.mediaType&&(t.mediaPlayer.srcObject=o.onlyvideo,t.mediaPlayer.play()),e.recording=!0,c.shift().call()},e.ondataavailable=function(e){u.push(e.data)})}),a.element.append($("<a>"+r+"</a>").addClass("Message-continue-link").click(s)),n=$("<div>Not recording</div>"),n.css({position:"fixed",top:0,left:"50%",transform:"translateX(-50%)",padding:"2px","background-color":"lightgray"}),$("#bod").append(n)})).catch((function(e){a.element.append($("<p>The following error occurred: "+e+"</p>"))}))});let b=m.log;return m.log=(...e)=>(f.push(e),b.apply(m,e),m),m.warning=e=>(s(e),m),m.consent=e=>((e=>{r=e})(e),m),e.ArgumentCallback(t=>{t==m&&(e.tmpItems=e.tmpItems.filter(e=>e!=m))}),e.NewTrialArgumentCallback(t=>{t==m&&(e.tmpItems=e.tmpItems.filter(e=>e!=m))}),m._runPromises=m.sequence,m},window.PennController.UploadRecordings=function(t,n){let i=e.controllers.new();e.tmpItems.push(i);const r=t=>{t==i&&(e.tmpItems=e.tmpItems.filter(e=>e!=i))};e.NewTrialArgumentCallback(r),e.ArgumentCallback(r),"string"==typeof t&&t.length&&(i.useLabel=t),i.id="UploadRecordings",i.runHeader=!1,i.runFooter=!1,i.countsForProgressBar=!1,i.sequence=()=>new Promise((async function(t){let i=e.controllers.running;i.element.append($("<p>Please wait while the archive of your recordings is being uploaded to the server...</p>")),n||await m();const r=new e.utils.JSZip,s=[];if(a.forEach(e=>{"uploaded"!==e.uploadStatus&&(r.file(e.name,e.data),e.uploadStatus="uploading",s.push(e))}),0===s.length)return t();const o={};p.push(o),r.generateAsync({compression:"DEFLATE",type:"blob"}).then((function(r){window.PennController.downloadRecordingsArchive=()=>e.utils.saveAs(r,"RecordingsArchive.zip");let a=e.utils.guidGenerator()+".zip";var u=new File([r],a);l.match(/^aws:/i)?e.debug.error("The 'aws:' prefix in InitiateRecorder is no longer supported"):e.utils.upload(l,a,u,"application/zip").then(i=>{a=i,e.controllers.running.save("PennController","UploadRecordings","Filename",a,Date.now(),n?"async":"NULL"),e.controllers.running.save("PennController","UploadRecordings","Status","Success",Date.now(),n?"async":"NULL"),e.debug.log("Recordings sent to the server");for(let e=0;e<s.length;e++)s[e].uploadStatus="uploaded";n||t(),p=p.filter(e=>e!=o)}).catch(l=>{e.controllers.running.save("PennController","UploadRecordings","Filename",a,Date.now(),n?"async":"NULL");for(let e=0;e<s.length;e++)s[e].uploadStatus="local";window.PennController.UploadRecordingsError=l||"error",e.debug.error("MediaRecorder's Ajax post failed",l),e.controllers.running.save("PennController","UploadRecordings","Status","Failed",Date.now(),"Error Text: "+l),i.element.append($("<p>There was an error uploading the recordings: "+l+"</p>")).append($("<p>Please click here to download a copy of your recordings in case you need to send them manually.</p>").bind("click",()=>{e.utils.saveAs(r,"RecordingsArchive.zip"),n||t()}).addClass("Message-continue-link")),p=p.filter(e=>e!=o)})})),n&&t()}));for(let e=0;e<f.length;e++)uploadzipController.log(...f[e]);return i._promises=[i.sequence],i._runPromises=i.sequence,i},e.Prerun(()=>{let t=window.conf_modifyRunningOrder;window.conf_modifyRunningOrder=function(n){if(t instanceof Function&&(n=t.apply(this,[n])),!h)return n;let i=!1,r=!1,s=[-1,-1];for(let e=0;e<n.length;++e)for(let t=0;t<n[e].length;++t){const o=n[e][t].controller,a=n[e][t].options.id;"PennController"==o&&"UploadRecordings"==a?(i=!0,s[0]>=0&&alert("WARNING: upload of recording archive set AFTER sending of results; check your Sequence definition.")):"__SendResults__"==o&&s[0]<0&&!i?s=[e,t]:"PennController"==o&&"InitiateRecorder"==a&&(r=!0)}r||e.debug.error("This project uses MediaRecorder but InitiateRecorder is not included in the Sequence");const o=window.PennController.UploadRecordings();e.tmpItems.pop();const a=new DynamicElement("PennController",o);return s[0]>=0?n.splice(s[0],0,[a]):n.push([a]),n}}),this.immediate=function(e,t){h=!0,void 0===e||"string"!=typeof e||0==e.length?e="MediaRecorder":void 0===t&&(t=e),"string"!=typeof t||!t.match(/audio/)||t.match(/video/i)&&!t.match(/no\W*video/i)?"string"==typeof t&&(t.match(/(only\W*video|video\W*only)/i)||t.match(/video/i)&&t.match(/no\W*audio/))?(this.mediaType="video",y=!0):(this.mediaType="video",g=!0,y=!0):(this.mediaType="audio",g=!0),this.id=e,Object.defineProperty(this,"recorder",{get:()=>o[this.mediaType]})},this.uponCreation=function(n){0==l.length&&e.debug.error("Recorder not initiated. Make sure the sequence of items contains an InitiateRecorder trial."),d.set(this,[]),this.log=!1,this.recordings=[],this.recording=!1,"audio"==this.mediaType?this.mediaPlayer=document.createElement("audio"):"video"==this.mediaType&&(this.mediaPlayer=document.createElement("video")),this.mediaPlayer.setAttribute("controls",!0),this.mediaPlayer.onended=()=>this.hasPlayed=!0,this.videoFeedback=$("<div>").css({position:"absolute"}),this.jQueryElement=$("<span>").addClass("PennController-"+this.type.replace(/[\s_]/g,"")+"-ui");let i=$("<button>Record</button>").addClass("PennController-"+this.type.replace(/[\s_]/g,"")+"-record");i.click(()=>{this.mediaPlayer.pause(),this.mediaPlayer.currentTime=0,this.recording?(this.stop(),this.recording=!1,i.text("Record"),clearInterval(null)):(i.text("Stop"),this.recording=!0,this.start())}),this.start=()=>new Promise(e=>{t=this,"recording"==this.recorder.state&&this.recorder.stop(),this.recording=!0,c.push(()=>{this.recordings.push(["Recording","Start",Date.now(),"NULL"]),e()}),this.recorder.start(),i.text("Stop")}),this.stop=()=>new Promise(e=>{this.recording=!1,i.text("Record"),t=this,"recording"==this.recorder.state?(d.get(this).push(()=>{this.recordings.push(["Recording","Stop",Date.now(),"NULL"]),e()}),this.recorder.stop()):e()}),this.jQueryElement.append($(this.mediaPlayer)).append(i),n()},this.end=async function(){t=this,this.recorder&&"recording"==this.recorder.state&&await new Promise(e=>{const t=this.recorder.onstop;this.recorder.onstop=function(...n){"function"==typeof t&&t.apply(this,n),e()},this.recorder.stop()});const n=d.get(this);if(n instanceof Array&&n.length>0&&await new Promise(e=>n.push(e)),this.blob){const t=w(this.mediaType).extension,n=a.map(e=>e.name);let i=this.id+"."+t,r=0;for(;n.indexOf(i)>=0;)r++,i=this.id+"-"+r+"."+t;a.push({name:i,data:this.blob,uploadStatus:"local"}),e.controllers.running.save(this.type,this.id,"Filename",i,Date.now(),"NULL")}if(this.log)for(let t in this.recordings)e.controllers.running.save(this.type,this.id,...this.recordings[t])},this.value=function(){return this.blob},this.actions={play:function(e){this.mediaPlayer&&this.mediaPlayer.src?(this.mediaPlayer.currentTime&&0!=this.mediaPlayer.currentTime&&(this.mediaPlayer.currentTime=0),this.mediaPlayer.play().then(()=>e())):e()},record:async function(e){await this.start(),e()},stop:async function(e){await this.stop(),this.mediaPlayer&&this.mediaPlayer.src&&(this.mediaPlayer.pause(),this.mediaPlayer.currentTime&&0!=this.mediaPlayer.currentTime&&(this.mediaPlayer.currentTime=0)),e()},wait:function(e,t){if(t&&"string"==typeof t&&t.match(/first/i)&&this.recordings.length)e();else if(t&&"string"==typeof t&&t.match(/play/i)&&this.mediaPlayer){let t=this.mediaPlayer.onended;this.mediaPlayer.onended=function(...n){t instanceof Function&&t.apply(this,n),e()}}else{let n=!1,i=this.stop;this.stop=()=>new Promise(r=>{i.apply(this).then(()=>{if(r(),!n)if(t instanceof Object&&t._runPromises&&t.success){let i=this.disabled;this.disabled="",t._runPromises().then(t=>{"success"==t&&(n=!0,e()),""==this.disabled&&(this.disabled=i)})}else n=!0,e()})})}}},this.settings={disable:function(e){this.disabled=!0,this.jQueryElement.find("button.PennController-"+this.type+"-record").attr("disabled",!0).css("background-color","brown"),this.jQueryContainer.addClass("PennController-disabled"),this.jQueryElement.addClass("PennController-disabled"),e()},enable:function(e){this.disabled=!1,this.jQueryElement.find("button.PennController-"+this.type+"-record").removeAttr("disabled").css("background-color","red"),this.jQueryContainer.removeClass("PennController-disabled"),this.jQueryElement.removeClass("PennController-disabled"),e()},once:function(e){if(this.recordings.length)this.disabled=!0,this.jQueryElement.find("button.PennController-"+this.type+"-record").attr("disabled",!0).css("background-color","brown");else{let e=this.stop;this.stop=()=>new Promise(t=>{e instanceof Function?e.apply(this).then(t):t(),this.disabled=!0,this.jQueryElement.find("button.PennController-"+this.type+"-record").attr("disabled",!0).css("background-color","brown")})}e()},log:function(e){this.log=!0,e()}},this.test={hasPlayed:function(){return this.hasPlayed},playing:function(){return this.mediaPlayer.currentTime&&!this.mediaPlayer.paused},recorded:function(){return this.blob}}})),window.PennController.DownloadRecordingButton=function(e){return"<button type=\"button\" onclick=\"if (PennController.hasOwnProperty('downloadRecordingsArchive'))  PennController.downloadRecordingsArchive();  else  alert('ERROR: could not find an archive for recordings');\">"+e+"</button>"},window.PennController.DownloadVoiceButton=window.PennController.DownloadRecordingButton,window.PennController.Elements.newVoiceRecorder=e=>window.PennController.Elements.newMediaRecorder(e,"audio"),window.PennController.Elements.getVoiceRecorder=e=>window.PennController.Elements.getMediaRecorder(e)},function(e,t){window.PennController._AddElementType("Youtube",(function(e){const t=window.MutationObserver||window.WebKitMutationObserver||window.MozMutationObserver;let n=[];$(document).ready((function(){let e=document.createElement("script");e.src="https://www.youtube.com/iframe_api";let t=document.getElementsByTagName("script")[0];t.parentNode.insertBefore(e,t),window.onYouTubeIframeAPIReady=function(){for(let e in n)n[e].call()}})),this.immediate=function(t,i,r){void 0===i&&"string"==typeof t&&(i=t),i&&"string"==typeof i||e.debug.error("Invalid code for Youtube element "+t,i),r=r&&!r.match(/^\W*no\W*controls?\W*$/i)?1:0,this.resource=e.resources.fetch(i,(function(t){let s=i+"-"+e.resources.list.length;this.ended=function(){},this.playing=function(){},this.paused=function(){},this.buffering=function(){};let o=!1,a=$("<iframe>");a.attr({src:"https://www.youtube-nocookie.com/embed/"+i+"?enablejsapi=1&controls="+r,id:s,frameborder:0}).bind("load",()=>o=!0).css({display:"none",position:"absolute"}),$(document).ready(()=>$(document.body).append(a)),n.push(()=>{let e=!0,n=()=>this.player=new YT.Player(s,{playerVars:{controls:r},events:{onReady:e=>{a=e.target.cueVideoById(i),e.target.playVideo()},onStateChange:n=>{n.data!=YT.PlayerState.ENDED||e?n.data==YT.PlayerState.PLAYING?e?(n.target.pauseVideo(),n.target.seekTo(0),e=!1,t()):this.playing(n):n.data!=YT.PlayerState.PAUSED||e?n.data!=YT.PlayerState.BUFFERING||e||this.buffering(n):this.paused(n):this.ended(n)}}});o?n():a.bind("load",n)}),this.object=a}),!1),this.id=t},this.uponCreation=function(e){this.iframe=this.resource.object,this.player=this.resource.player,this.log=!1,this.hasPlayed=!1,this.events=[],this.onplay=()=>this.events.push(["Play",this.player.getCurrentTime(),Date.now(),"NULL"]),this.onpause=()=>this.events.push(["Pause",this.player.getCurrentTime(),Date.now(),"NULL"]),this.onbuffer=()=>this.events.push(["Buffer",this.player.getCurrentTime(),Date.now(),"NULL"]),this.onend=()=>{this.hasPlayed=!0,this.events.push(["End",this.player.getCurrentTime(),Date.now(),"NULL"])};let t=this,n=this.resource.ended;this.resource.ended=function(e){n.apply(this,e),t.onend()};let i=this.resource.playing;this.resource.playing=function(e){i.apply(this,e),t.onplay()};let r=this.resource.paused;this.resource.paused=function(e){r.apply(this,e),t.onpause()};let s=this.resource.buffering;this.resource.buffering=function(e){s.apply(this,e),t.onbuffer()},this.jQueryElement=$("<div>").css("display","inline-block"),this.visual={top:0,left:0,width:this.iframe.width(),height:this.iframe.height()},this.jQueryElement.css({width:this.visual.width,height:this.visual.height}),this.player.seekTo(0),this.disabled=!1,this.jQueryDisable=null,this.printDisable=()=>{this.jQueryDisable instanceof jQuery&&this.jQueryDisable.remove(),this.jQueryDisable=$("<div>").css({position:"absolute",display:"inline-block","background-color":"gray",opacity:.5,width:this.jQueryElement.width(),height:this.jQueryElement.height()}),this.jQueryElement.before(this.jQueryDisable),this.jQueryElement.addClass("PennController-"+this.type.replace(/[\s_]/g,"")+"-disabled")},e()},this.end=function(){if(this.observer&&this.observer instanceof t&&this.observer.disconnect(),this.player&&this.player.getPlayerState()==YT.PlayerState.PLAYING&&this.player.pauseVideo(),this.iframe.css("display","none"),this.jQueryDisable&&this.jQueryDisable.remove(),this.log&&this.log instanceof Array)if(this.events.length)if(this.log.indexOf("all")>-1)for(let t in this.events)e.controllers.running.save(this.type,this.id,...this.events[t]);else{if(this.log.indexOf("play")>-1){let t=this.events.filter(e=>"Play"==e[0]);for(let n in t)e.controllers.running.save(this.type,this.id,...t[n])}if(this.log.indexOf("end")>-1){let t=this.events.filter(e=>"End"==e[0]);for(let n in t)e.controllers.running.save(this.type,this.id,...t[n])}if(this.log.indexOf("pause")>-1){let t=this.events.filter(e=>"Pause"==e[0]);for(let n in t)e.controllers.running.save(this.type,this.id,...t[n])}if(this.log.indexOf("buffer")>-1){let t=this.events.filter(e=>"Buffer"==e[0]);for(let n in t)e.controllers.running.save(this.type,this.id,...t[n])}}else e.controllers.running.save(this.type,this.id,"play","NA","Never","The video was never played during the trial")},this.value=function(){return this.hasPlayed},this.actions={play:function(e){this.player.playVideo(),e()},pause:function(e){this.player.pauseVideo(),e()},print:function(n,...i){e.elements.standardCommands.actions.print.apply(this,[()=>{let e=this.jQueryElement.offset();this.iframe.css({position:"absolute",left:e.left,top:e.top,display:"inline-block"}),this.observer=new t(()=>{if(this.jQueryElement[0].offsetParent&&$.contains(document.body,this.jQueryElement[0])){this.iframe.css("display",this.jQueryElement.css("display"));let e=this.jQueryElement.width(),t=this.jQueryElement.height();e==this.visual.width&&t==this.visual.height||(this.iframe.css({width:e,height:t}),this.visual.width=e,this.visual.height=t);let n=this.jQueryElement.offset();n.left==this.visual.left&&n.top==this.visual.top||(this.iframe.css({left:n.left,top:n.top}),this.visual.left=n.left,this.visual.top=n.top),this.observer.disconnect(),this.observer.observe(this.jQueryElement.parent()[0],{childList:!0,attributes:!0,subtree:!0})}else this.iframe.css("display","none")}),this.observer.observe(this.jQueryElement.parent()[0],{childList:!0,attributes:!0,subtree:!0}),this.disabled&&this.printDisable(),n()},...i])},remove:function(t){this.iframe.css("display","none"),e.elements.standardCommands.actions.remove.apply(this,[t])},stop:function(e){this.player.pauseVideo(),this.player.seekTo(0),e()},wait:function(e,t){if("first"==t&&this.hasPlayed)e();else{let n=!1,i=this.onend;this.onend=function(...r){if(i.apply(this,r),!n)if(t instanceof Object&&t._runPromises&&t.success){let i=this.disabled;this.disabled="tmp",t._runPromises().then(t=>{"success"==t&&(n=!0,e()),"tmp"==this.disabled&&(this.disabled=i)})}else n=!0,e()}}}},this.settings={disable:function(e){this.printDisable(),this.disabled=!0,this.jQueryContainer.addClass("PennController-disabled"),this.jQueryElement.addClass("PennController-disabled"),e()},enable:function(e){this.jQueryDisable instanceof jQuery&&(this.disabled=!1,this.jQueryDisable.remove(),this.jQueryDisable=null,this.jQueryContainer.removeClass("PennController-disabled"),this.jQueryElement.removeClass("PennController-disabled")),e()},once:function(e){if(this.hasPlayed)this.disabled=!0;else{let e=this.onend,t=this;this.onend=function(...n){e.apply(this,n),t.disabled=!0,t.printDisable()}}e()},log:function(e,...t){t.length?this.log=t:this.log=["play"],e()},size:function(t,n,i){e.elements.standardCommands.settings.size.apply(this,[()=>{this.iframe.css({width:n,height:i}),this.visual.width=n,this.visual.height=i,t()},n,i])}},this.test={hasPlayed:function(){return this.hasPlayed},playing:function(){return 1==this.player.getPlayerState()}}}))},,function(e,t,n){"use strict";n.r(t);n(1),n(0),n(6),n(2),n(7),n(8),n(17),n(19),n(20),n(21),n(22),n(23),n(24),n(25),n(26),n(27),n(28),n(29),n(30),n(31),n(32),n(33),n(34),n(35),n(36),n(37),n(38),n(39),n(40),n(41),n(42),n(43)}]);